/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.beanmapping;

import java.util.Objects;
import org.mapstruct.ap.internal.model.beanmapping.SourceReference;
import org.mapstruct.ap.internal.model.beanmapping.TargetReference;
import org.mapstruct.ap.internal.model.source.MappingOptions;

public class MappingReference {
    private MappingOptions mapping;
    private TargetReference targetReference;
    private SourceReference sourceReference;

    public MappingReference(MappingOptions mapping, TargetReference targetReference, SourceReference sourceReference) {
        this.mapping = mapping;
        this.targetReference = targetReference;
        this.sourceReference = sourceReference;
    }

    public MappingOptions getMapping() {
        return this.mapping;
    }

    public SourceReference getSourceReference() {
        return this.sourceReference;
    }

    public void setSourceReference(SourceReference sourceReference) {
        this.sourceReference = sourceReference;
    }

    public TargetReference getTargetReference() {
        return this.targetReference;
    }

    public MappingReference popTargetReference() {
        TargetReference newTargetReference;
        if (this.targetReference != null && (newTargetReference = this.targetReference.pop()) != null) {
            return new MappingReference(this.mapping, newTargetReference, this.sourceReference);
        }
        return null;
    }

    public MappingReference popSourceReference() {
        SourceReference newSourceReference;
        if (this.sourceReference != null && (newSourceReference = this.sourceReference.pop()) != null) {
            return new MappingReference(this.mapping, this.targetReference, newSourceReference);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingReference that = (MappingReference)o;
        if (".".equals(that.mapping.getTargetName())) {
            return false;
        }
        if (!Objects.equals(this.mapping.getTargetName(), that.mapping.getTargetName())) {
            return false;
        }
        if (!Objects.equals(this.mapping.getConstant(), that.mapping.getConstant())) {
            return false;
        }
        if (!Objects.equals(this.mapping.getJavaExpression(), that.mapping.getJavaExpression())) {
            return false;
        }
        if (this.sourceReference == null) {
            return that.sourceReference == null;
        }
        if (that.sourceReference == null) {
            return false;
        }
        return Objects.equals(this.sourceReference.getPropertyEntries(), that.sourceReference.getPropertyEntries());
    }

    public int hashCode() {
        return Objects.hash(this.mapping);
    }

    public boolean isValid() {
        return this.sourceReference == null || this.sourceReference.isValid();
    }

    public String toString() {
        String targetRefStr = this.targetReference.toString();
        String sourceRefStr = "null";
        if (this.sourceReference != null) {
            sourceRefStr = this.sourceReference.toString();
        }
        return "MappingReference {\n    sourceReference='" + sourceRefStr + "',\n    targetReference='" + targetRefStr + "',\n}";
    }
}

