/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.mapstruct.ap.internal.gem.BuilderGem;
import org.mapstruct.ap.internal.gem.NullValueCheckStrategyGem;
import org.mapstruct.ap.internal.gem.NullValuePropertyMappingStrategyGem;
import org.mapstruct.ap.internal.model.AbstractBaseBuilder;
import org.mapstruct.ap.internal.model.BuilderFinisherMethodResolver;
import org.mapstruct.ap.internal.model.CollectionAssignmentBuilder;
import org.mapstruct.ap.internal.model.ContainerMappingMethod;
import org.mapstruct.ap.internal.model.ContainerMappingMethodBuilder;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.IterableMappingMethod;
import org.mapstruct.ap.internal.model.MapMappingMethod;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NestedPropertyMappingMethod;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.PresenceCheckMethodResolver;
import org.mapstruct.ap.internal.model.StreamMappingMethod;
import org.mapstruct.ap.internal.model.assignment.AdderWrapper;
import org.mapstruct.ap.internal.model.assignment.ArrayCopyWrapper;
import org.mapstruct.ap.internal.model.assignment.EnumConstantWrapper;
import org.mapstruct.ap.internal.model.assignment.GetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.internal.model.assignment.SetterWrapper;
import org.mapstruct.ap.internal.model.assignment.StreamAdderWrapper;
import org.mapstruct.ap.internal.model.assignment.UpdateWrapper;
import org.mapstruct.ap.internal.model.beanmapping.MappingReferences;
import org.mapstruct.ap.internal.model.beanmapping.PropertyEntry;
import org.mapstruct.ap.internal.model.beanmapping.SourceReference;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.BuilderType;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.PresenceCheck;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.presence.AllPresenceChecksPresenceCheck;
import org.mapstruct.ap.internal.model.presence.JavaExpressionPresenceCheck;
import org.mapstruct.ap.internal.model.presence.NullPresenceCheck;
import org.mapstruct.ap.internal.model.presence.OptionalPresenceCheck;
import org.mapstruct.ap.internal.model.presence.SuffixPresenceCheck;
import org.mapstruct.ap.internal.model.source.DelegatingOptions;
import org.mapstruct.ap.internal.model.source.MappingControl;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;
import org.mapstruct.ap.internal.util.accessor.ReadAccessor;

public class PropertyMapping
extends ModelElement {
    private final String name;
    private final String sourcePropertyName;
    private final String sourceBeanName;
    private final String targetWriteAccessorName;
    private final ReadAccessor targetReadAccessorProvider;
    private final Type targetType;
    private final Assignment assignment;
    private final Set<String> dependsOn;
    private final Assignment defaultValueAssignment;
    private final boolean constructorMapping;

    private PropertyMapping(String name, String targetWriteAccessorName, ReadAccessor targetReadAccessorProvider, Type targetType, Assignment propertyAssignment, Set<String> dependsOn, Assignment defaultValueAssignment, boolean constructorMapping) {
        this(name, null, null, targetWriteAccessorName, targetReadAccessorProvider, targetType, propertyAssignment, dependsOn, defaultValueAssignment, constructorMapping);
    }

    private PropertyMapping(String sourcePropertyName, String name, String sourceBeanName, String targetWriteAccessorName, ReadAccessor targetReadAccessorProvider, Type targetType, Assignment assignment, Set<String> dependsOn, Assignment defaultValueAssignment, boolean constructorMapping) {
        this.sourcePropertyName = sourcePropertyName;
        this.name = name;
        this.sourceBeanName = sourceBeanName;
        this.targetWriteAccessorName = targetWriteAccessorName;
        this.targetReadAccessorProvider = targetReadAccessorProvider;
        this.targetType = targetType;
        this.assignment = assignment;
        this.dependsOn = dependsOn != null ? dependsOn : java.util.Collections.emptySet();
        this.defaultValueAssignment = defaultValueAssignment;
        this.constructorMapping = constructorMapping;
    }

    public String getName() {
        return this.name;
    }

    public String getSourcePropertyName() {
        return this.sourcePropertyName;
    }

    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public String getTargetWriteAccessorName() {
        return this.targetWriteAccessorName;
    }

    public String getTargetReadAccessorName() {
        return this.targetReadAccessorProvider == null ? null : this.targetReadAccessorProvider.getReadValueSource();
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public Assignment getDefaultValueAssignment() {
        return this.defaultValueAssignment;
    }

    public boolean isConstructorMapping() {
        return this.constructorMapping;
    }

    @Override
    public Set<Type> getImportTypes() {
        if (this.defaultValueAssignment == null) {
            return this.assignment.getImportTypes();
        }
        return Collections.asSet(this.assignment.getImportTypes(), new Collection[]{this.defaultValueAssignment.getImportTypes()});
    }

    public Set<String> getDependsOn() {
        return this.dependsOn;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 67 * hash + (this.targetType != null ? this.targetType.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyMapping other = (PropertyMapping)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.targetType, other.targetType);
    }

    public String toString() {
        return "PropertyMapping {\n    name='" + this.name + "',\n    targetWriteAccessorName='" + this.targetWriteAccessorName + "',\n    targetReadAccessorName='" + this.getTargetReadAccessorName() + "',\n    targetType=" + this.targetType + ",\n    propertyAssignment=" + this.assignment + ",\n    defaultValueAssignment=" + this.defaultValueAssignment + ",\n    dependsOn=" + this.dependsOn + "\n}";
    }

    public static class JavaExpressionMappingBuilder
    extends MappingBuilderBase<JavaExpressionMappingBuilder> {
        private String javaExpression;

        JavaExpressionMappingBuilder() {
            super(JavaExpressionMappingBuilder.class);
        }

        public JavaExpressionMappingBuilder javaExpression(String javaExpression) {
            this.javaExpression = javaExpression;
            return this;
        }

        public PropertyMapping build() {
            ModelElement assignment = new SourceRHS(this.javaExpression, null, this.existingVariableNames, "");
            assignment = this.targetWriteAccessor.getAccessorType() == AccessorType.SETTER || this.targetWriteAccessor.getAccessorType().isFieldAssignment() ? new SetterWrapper((Assignment)((Object)assignment), this.method.getThrownTypes(), this.isFieldAssignment()) : new GetterWrapperForCollectionsAndMaps((Assignment)((Object)assignment), this.method.getThrownTypes(), this.targetType, this.isFieldAssignment());
            return new PropertyMapping(this.targetPropertyName, this.targetWriteAccessor.getSimpleName(), this.targetReadAccessor, this.targetType, (Assignment)((Object)assignment), this.dependsOn, null, this.targetWriteAccessorType == AccessorType.PARAMETER);
        }
    }

    public static class ConstantMappingBuilder
    extends MappingBuilderBase<ConstantMappingBuilder> {
        private String constantExpression;
        private FormattingParameters formattingParameters;
        private MappingControl mappingControl;
        private SelectionParameters selectionParameters;

        ConstantMappingBuilder() {
            super(ConstantMappingBuilder.class);
        }

        public ConstantMappingBuilder constantExpression(String constantExpression) {
            this.constantExpression = constantExpression;
            return this;
        }

        public ConstantMappingBuilder formattingParameters(FormattingParameters formattingParameters) {
            this.formattingParameters = formattingParameters;
            return this;
        }

        public ConstantMappingBuilder selectionParameters(SelectionParameters selectionParameters) {
            this.selectionParameters = selectionParameters;
            return this;
        }

        public ConstantMappingBuilder options(MappingOptions options) {
            this.mappingControl = options.getMappingControl(this.ctx.getElementUtils());
            return this;
        }

        public PropertyMapping build() {
            String sourceErrorMessagePart = "constant '" + this.constantExpression + "'";
            String errorMessageDetails = null;
            Class<Object> baseForLiteral = null;
            try {
                baseForLiteral = NativeTypes.getLiteral(this.targetType.getFullyQualifiedName(), this.constantExpression);
            }
            catch (IllegalArgumentException ex) {
                errorMessageDetails = ex.getMessage();
            }
            if (baseForLiteral == null) {
                this.constantExpression = "\"" + this.constantExpression + "\"";
                baseForLiteral = String.class;
            }
            Type sourceType = this.ctx.getTypeFactory().getTypeForLiteral(baseForLiteral);
            SelectionCriteria criteria = SelectionCriteria.forMappingMethods(this.selectionParameters, this.mappingControl, this.targetPropertyName, this.method.getMappingTargetParameter() != null);
            Assignment assignment = null;
            assignment = !this.targetType.isEnumType() ? this.ctx.getMappingResolver().getTargetAssignment(this.method, null, this.targetType, this.formattingParameters, criteria, new SourceRHS(this.constantExpression, sourceType, this.existingVariableNames, sourceErrorMessagePart), this.positionHint, () -> null) : this.getEnumAssignment();
            if (assignment != null) {
                if (this.targetWriteAccessor.getAccessorType() == AccessorType.SETTER || this.targetWriteAccessor.getAccessorType().isFieldAssignment()) {
                    if (assignment.isCallingUpdateMethod()) {
                        if (this.targetReadAccessor == null) {
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.positionHint, Message.CONSTANTMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                        }
                        MethodReference factoryMethod = ObjectFactoryMethodResolver.getFactoryMethod(this.method, this.targetType, null, this.ctx);
                        assignment = new UpdateWrapper(assignment, this.method.getThrownTypes(), factoryMethod, this.isFieldAssignment(), this.targetType, false, false, false);
                    } else {
                        assignment = new SetterWrapper(assignment, this.method.getThrownTypes(), this.isFieldAssignment());
                    }
                } else {
                    assignment = new GetterWrapperForCollectionsAndMaps(assignment, this.method.getThrownTypes(), this.targetType, this.isFieldAssignment());
                }
            } else if (errorMessageDetails == null) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.positionHint, Message.CONSTANTMAPPING_MAPPING_NOT_FOUND, this.constantExpression, this.targetType.describe(), this.targetPropertyName);
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.positionHint, Message.CONSTANTMAPPING_MAPPING_NOT_FOUND_WITH_DETAILS, this.constantExpression, this.targetType.describe(), this.targetPropertyName, errorMessageDetails);
            }
            return new PropertyMapping(this.targetPropertyName, this.targetWriteAccessor.getSimpleName(), this.targetReadAccessor, this.targetType, assignment, this.dependsOn, null, this.targetWriteAccessorType == AccessorType.PARAMETER);
        }

        private Assignment getEnumAssignment() {
            ModelElement assignment = null;
            String enumExpression = this.constantExpression.substring(1, this.constantExpression.length() - 1);
            if (this.targetType.getEnumConstants().contains(enumExpression)) {
                String sourceErrorMessagePart = "constant '" + this.constantExpression + "'";
                assignment = new SourceRHS(enumExpression, this.targetType, this.existingVariableNames, sourceErrorMessagePart);
                assignment = new EnumConstantWrapper((Assignment)((Object)assignment), this.targetType);
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.positionHint, Message.CONSTANTMAPPING_NON_EXISTING_CONSTANT, this.constantExpression, this.targetType.describe(), this.targetPropertyName);
            }
            return assignment;
        }
    }

    public static class PropertyMappingBuilder
    extends MappingBuilderBase<PropertyMappingBuilder> {
        private String defaultValue;
        private String defaultJavaExpression;
        private String conditionJavaExpression;
        private SourceReference sourceReference;
        private SourceRHS rightHandSide;
        private FormattingParameters formattingParameters;
        private SelectionParameters selectionParameters;
        private MappingControl mappingControl;
        private MappingReferences forgeMethodWithMappingReferences;
        private boolean forceUpdateMethod;
        private boolean forgedNamedBased = true;
        private NullValueCheckStrategyGem nvcs;
        private NullValuePropertyMappingStrategyGem nvpms;

        PropertyMappingBuilder() {
            super(PropertyMappingBuilder.class);
        }

        public PropertyMappingBuilder sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public PropertyMappingBuilder selectionParameters(SelectionParameters selectionParameters) {
            this.selectionParameters = selectionParameters;
            return this;
        }

        public PropertyMappingBuilder formattingParameters(FormattingParameters formattingParameters) {
            this.formattingParameters = formattingParameters;
            return this;
        }

        public PropertyMappingBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public PropertyMappingBuilder defaultJavaExpression(String defaultJavaExpression) {
            this.defaultJavaExpression = defaultJavaExpression;
            return this;
        }

        public PropertyMappingBuilder conditionJavaExpression(String conditionJavaExpression) {
            this.conditionJavaExpression = conditionJavaExpression;
            return this;
        }

        public PropertyMappingBuilder forgeMethodWithMappingReferences(MappingReferences mappingReferences) {
            this.forgeMethodWithMappingReferences = mappingReferences;
            return this;
        }

        public PropertyMappingBuilder forceUpdateMethod(boolean forceUpdateMethod) {
            this.forceUpdateMethod = forceUpdateMethod;
            return this;
        }

        public PropertyMappingBuilder forgedNamedBased(boolean forgedNamedBased) {
            this.forgedNamedBased = forgedNamedBased;
            return this;
        }

        public PropertyMappingBuilder options(DelegatingOptions options) {
            this.mappingControl = options.getMappingControl(this.ctx.getElementUtils());
            this.nvcs = options.getNullValueCheckStrategy();
            if (this.method.isUpdateMethod()) {
                this.nvpms = options.getNullValuePropertyMappingStrategy();
            }
            return this;
        }

        public PropertyMapping build() {
            this.rightHandSide = this.getSourceRHS(this.sourceReference);
            this.ctx.getMessager().note(2, Message.PROPERTYMAPPING_MAPPING_NOTE, this.rightHandSide, this.targetWriteAccessor);
            this.rightHandSide.setUseElementAsSourceTypeForMatching(this.targetWriteAccessorType == AccessorType.ADDER);
            boolean preferUpdateMethods = this.targetWriteAccessorType == AccessorType.ADDER ? false : this.method.getMappingTargetParameter() != null;
            SelectionCriteria criteria = SelectionCriteria.forMappingMethods(this.selectionParameters, this.mappingControl, this.targetPropertyName, preferUpdateMethods);
            Assignment assignment = null;
            assignment = this.forgeMethodWithMappingReferences == null ? this.ctx.getMappingResolver().getTargetAssignment(this.method, this.getForgedMethodHistory(this.rightHandSide), this.targetType, this.formattingParameters, criteria, this.rightHandSide, this.positionHint, this::forge) : this.forge();
            Type sourceType = this.rightHandSide.getSourceType();
            if (assignment != null) {
                this.ctx.getMessager().note(2, Message.PROPERTYMAPPING_SELECT_NOTE, assignment);
                assignment = this.targetType.isCollectionOrMapType() ? this.assignToCollection(this.targetType, this.targetWriteAccessorType, assignment) : (this.targetType.isArrayType() && sourceType.isArrayType() && assignment.getType() == Assignment.AssignmentType.DIRECT ? this.assignToArray(this.targetType, assignment) : this.assignToPlain(this.targetType, this.targetWriteAccessorType, assignment));
            } else {
                this.reportCannotCreateMapping();
            }
            return new PropertyMapping(this.sourcePropertyName, this.targetPropertyName, this.sourceReference.getParameter().getOriginalName(), this.targetWriteAccessor.getSimpleName(), this.targetReadAccessor, this.targetType, assignment, this.dependsOn, this.getDefaultValueAssignment(assignment), this.targetWriteAccessorType == AccessorType.PARAMETER);
        }

        private Assignment forge() {
            Type sourceType = this.rightHandSide.getSourceType();
            Assignment assignment = (sourceType.isCollectionType() || sourceType.isArrayType()) && this.targetType.isIterableType() || sourceType.isIterableType() && this.targetType.isCollectionType() ? this.forgeIterableMapping(sourceType, this.targetType, this.rightHandSide) : (sourceType.isMapType() && this.targetType.isMapType() ? this.forgeMapMapping(sourceType, this.targetType, this.rightHandSide) : (sourceType.isMapType() && !this.targetType.isMapType() ? this.forgeMapping(sourceType, this.targetType.withoutBounds(), this.rightHandSide) : (sourceType.isIterableType() && this.targetType.isStreamType() || sourceType.isStreamType() && this.targetType.isStreamType() || sourceType.isStreamType() && this.targetType.isIterableType() ? this.forgeStreamMapping(sourceType, this.targetType, this.rightHandSide) : this.forgeMapping(this.rightHandSide))));
            if (assignment != null) {
                this.ctx.getMessager().note(2, Message.PROPERTYMAPPING_CREATE_NOTE, assignment);
            }
            return assignment;
        }

        private void reportCannotCreateMapping() {
            if (this.forgeMethodWithMappingReferences != null && this.ctx.isErroneous()) {
                return;
            }
            if (this.method instanceof ForgedMethod && ((ForgedMethod)this.method).getHistory() != null) {
                ForgedMethodHistory history = this.getForgedMethodHistory(this.rightHandSide);
                this.reportCannotCreateMapping(this.method, this.positionHint, history.createSourcePropertyErrorMessage(), history.getSourceType(), history.getTargetType(), history.createTargetPropertyName());
            } else {
                this.reportCannotCreateMapping(this.method, this.positionHint, this.rightHandSide.getSourceErrorMessagePart(), this.rightHandSide.getSourceType(), this.targetType, this.targetPropertyName);
            }
        }

        private Assignment getDefaultValueAssignment(Assignment rhs) {
            if (!(this.defaultValue == null || rhs.getSourceType().isPrimitive() && rhs.getSourcePresenceCheckerReference() == null)) {
                PropertyMapping build = ((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)((ConstantMappingBuilder)new ConstantMappingBuilder().constantExpression(this.defaultValue).formattingParameters(this.formattingParameters).selectionParameters(this.selectionParameters).dependsOn(this.dependsOn)).existingVariableNames(this.existingVariableNames)).mappingContext(this.ctx)).sourceMethod(this.method)).target(this.targetPropertyName, this.targetReadAccessor, this.targetWriteAccessor)).build();
                return build.getAssignment();
            }
            if (!(this.defaultJavaExpression == null || rhs.getSourceType().isPrimitive() && rhs.getSourcePresenceCheckerReference() == null)) {
                PropertyMapping build = ((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)((JavaExpressionMappingBuilder)new JavaExpressionMappingBuilder().javaExpression(this.defaultJavaExpression).dependsOn(this.dependsOn)).existingVariableNames(this.existingVariableNames)).mappingContext(this.ctx)).sourceMethod(this.method)).target(this.targetPropertyName, this.targetReadAccessor, this.targetWriteAccessor)).build();
                return build.getAssignment();
            }
            return null;
        }

        private Assignment assignToPlain(Type targetType, AccessorType targetAccessorType, Assignment rightHandSide) {
            Assignment result = targetAccessorType == AccessorType.SETTER || targetAccessorType.isFieldAssignment() ? this.assignToPlainViaSetter(targetType, rightHandSide) : this.assignToPlainViaAdder(rightHandSide);
            return result;
        }

        private Assignment assignToPlainViaSetter(Type targetType, Assignment rhs) {
            if (rhs.isCallingUpdateMethod()) {
                MethodReference finisherMethod;
                MethodReference builderFactoryMethod;
                MethodReference factory;
                if (this.targetReadAccessor == null) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), this.positionHint, Message.PROPERTYMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                }
                if ((factory = ObjectFactoryMethodResolver.getFactoryMethod(this.method, targetType, SelectionParameters.forSourceRHS(this.rightHandSide), this.ctx)) == null && this.targetBuilderType != null && (builderFactoryMethod = ObjectFactoryMethodResolver.getBuilderFactoryMethod(targetType, this.targetBuilderType)) != null && (finisherMethod = BuilderFinisherMethodResolver.getBuilderFinisherMethod(this.method, this.targetBuilderType, this.ctx)) != null) {
                    factory = MethodReference.forMethodChaining(builderFactoryMethod, finisherMethod);
                }
                return new UpdateWrapper(rhs, this.method.getThrownTypes(), factory, this.isFieldAssignment(), targetType, !rhs.isSourceReferenceParameter(), this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_NULL && !targetType.isPrimitive(), this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_DEFAULT);
            }
            boolean includeSourceNullCheck = this.setterWrapperNeedsSourceNullCheck(rhs, targetType);
            if (!includeSourceNullCheck) {
                rhs.setSourceLocalVarName(null);
            }
            return new SetterWrapper(rhs, this.method.getThrownTypes(), this.isFieldAssignment(), includeSourceNullCheck, includeSourceNullCheck && this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_NULL && !targetType.isPrimitive(), this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_DEFAULT);
        }

        private boolean setterWrapperNeedsSourceNullCheck(Assignment rhs, Type targetType) {
            if (rhs.getSourceType().isPrimitive() && rhs.getSourcePresenceCheckerReference() == null) {
                return false;
            }
            if (this.nvcs == NullValueCheckStrategyGem.ALWAYS) {
                return true;
            }
            if (rhs.getSourcePresenceCheckerReference() != null) {
                return true;
            }
            if (this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_DEFAULT || this.nvpms == NullValuePropertyMappingStrategyGem.IGNORE) {
                return true;
            }
            if (rhs.getType().isConverted()) {
                return true;
            }
            if (rhs.getType().isDirect() && targetType.isPrimitive()) {
                return true;
            }
            return this.hasDefaultValueOrDefaultExpression();
        }

        private boolean hasDefaultValueOrDefaultExpression() {
            return this.defaultValue != null || this.defaultJavaExpression != null;
        }

        private Assignment assignToPlainViaAdder(Assignment rightHandSide) {
            String adderIteratorName;
            Assignment result = rightHandSide;
            String string = adderIteratorName = this.sourcePropertyName == null ? this.targetPropertyName : this.sourcePropertyName;
            result = result.getSourceType().isIterableType() ? new AdderWrapper(result, this.method.getThrownTypes(), this.isFieldAssignment(), adderIteratorName) : (result.getSourceType().isStreamType() ? new StreamAdderWrapper(result, this.method.getThrownTypes(), this.isFieldAssignment(), adderIteratorName) : new SetterWrapper(result, this.method.getThrownTypes(), this.isFieldAssignment(), true, this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_NULL && !this.targetType.isPrimitive(), this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_DEFAULT));
            return result;
        }

        private Assignment assignToCollection(Type targetType, AccessorType targetAccessorType, Assignment rhs) {
            return new CollectionAssignmentBuilder().mappingBuilderContext(this.ctx).method(this.method).targetReadAccessor(this.targetReadAccessor).targetType(targetType).targetPropertyName(this.targetPropertyName).targetAccessorType(targetAccessorType).rightHandSide(this.rightHandSide).assignment(rhs).nullValueCheckStrategy(this.hasDefaultValueOrDefaultExpression() ? NullValueCheckStrategyGem.ALWAYS : this.nvcs).nullValuePropertyMappingStrategy(this.nvpms).build();
        }

        private Assignment assignToArray(Type targetType, Assignment rightHandSide) {
            Type arrayType = this.ctx.getTypeFactory().getType(Arrays.class);
            return new ArrayCopyWrapper(rightHandSide, this.targetPropertyName, arrayType, targetType, this.isFieldAssignment(), this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_NULL && !targetType.isPrimitive(), this.nvpms == NullValuePropertyMappingStrategyGem.SET_TO_DEFAULT);
        }

        private SourceRHS getSourceRHS(SourceReference sourceReference) {
            Parameter sourceParam = sourceReference.getParameter();
            PropertyEntry propertyEntry = sourceReference.getDeepestProperty();
            if (propertyEntry == null) {
                SourceRHS sourceRHS = new SourceRHS(sourceParam.getName(), sourceParam.getType(), this.existingVariableNames, sourceReference.toString());
                sourceRHS.setSourcePresenceCheckerReference(this.getSourcePresenceCheckerRef(sourceReference, sourceRHS));
                return sourceRHS;
            }
            if (!sourceReference.isNested()) {
                String sourceRef = sourceParam.getName() + "." + propertyEntry.getReadAccessor().getReadValueSource();
                SourceRHS sourceRHS = new SourceRHS(sourceParam.getName(), sourceRef, null, propertyEntry.getType(), this.existingVariableNames, sourceReference.toString());
                sourceRHS.setSourcePresenceCheckerReference(this.getSourcePresenceCheckerRef(sourceReference, sourceRHS));
                return sourceRHS;
            }
            Type sourceType = propertyEntry.getType();
            if (sourceType.isPrimitive() && !this.targetType.isPrimitive()) {
                sourceType = this.ctx.getTypeFactory().getWrappedType(sourceType);
            }
            String forgedName = Strings.joinAndCamelize(sourceReference.getElementNames());
            forgedName = Strings.getSafeVariableName(forgedName, this.ctx.getReservedNames());
            Type sourceParameterType = sourceReference.getParameter().getType();
            ForgedMethod methodRef = ForgedMethod.forParameterMapping(forgedName, sourceParameterType, sourceType, this.method);
            NestedPropertyMappingMethod.Builder builder = new NestedPropertyMappingMethod.Builder();
            NestedPropertyMappingMethod nestedPropertyMapping = builder.method(methodRef).propertyEntries(sourceReference.getPropertyEntries()).mappingContext(this.ctx).build();
            if (!this.ctx.getMappingsToGenerate().contains(nestedPropertyMapping)) {
                this.ctx.getMappingsToGenerate().add(nestedPropertyMapping);
            } else {
                forgedName = this.ctx.getExistingMappingMethod(nestedPropertyMapping).getName();
            }
            String sourceRef = forgedName + "( " + sourceParam.getName() + " )";
            SourceRHS sourceRhs = new SourceRHS(sourceParam.getName(), sourceRef, null, sourceType, this.existingVariableNames, sourceReference.toString());
            sourceRhs.setSourcePresenceCheckerReference(this.getSourcePresenceCheckerRef(sourceReference, sourceRhs));
            String desiredName = propertyEntry.getName();
            sourceRhs.setSourceLocalVarName(sourceRhs.createUniqueVarName(desiredName));
            return sourceRhs;
        }

        private PresenceCheck getSourcePresenceCheckerRef(SourceReference sourceReference, SourceRHS sourceRHS) {
            if (this.conditionJavaExpression != null) {
                return new JavaExpressionPresenceCheck(this.conditionJavaExpression);
            }
            SelectionParameters selectionParameters = this.selectionParameters != null ? this.selectionParameters.withSourceRHS(sourceRHS) : SelectionParameters.forSourceRHS(sourceRHS);
            PresenceCheck presenceCheck = PresenceCheckMethodResolver.getPresenceCheck(this.method, selectionParameters, this.ctx);
            if (presenceCheck != null) {
                return presenceCheck;
            }
            PresenceCheck sourcePresenceChecker = null;
            if (!sourceReference.getPropertyEntries().isEmpty()) {
                Parameter sourceParam = sourceReference.getParameter();
                PropertyEntry propertyEntry = sourceReference.getShallowestProperty();
                if (propertyEntry.getPresenceChecker() != null) {
                    PropertyEntry entry;
                    ArrayList<PresenceCheck> presenceChecks = new ArrayList<PresenceCheck>();
                    presenceChecks.add(new SuffixPresenceCheck(sourceParam.getName(), propertyEntry.getPresenceChecker().getPresenceCheckSuffix()));
                    String variableName = sourceParam.getName() + "." + propertyEntry.getReadAccessor().getReadValueSource();
                    Type variableType = propertyEntry.getType();
                    for (int i = 1; i < sourceReference.getPropertyEntries().size() && (entry = sourceReference.getPropertyEntries().get(i)).getPresenceChecker() != null && entry.getReadAccessor() != null; ++i) {
                        if (variableType.isOptionalType()) {
                            presenceChecks.add(new OptionalPresenceCheck(variableName, this.ctx.getVersionInformation()));
                            variableName = variableName + ".get()";
                        } else {
                            presenceChecks.add(new NullPresenceCheck(variableName));
                        }
                        presenceChecks.add(new SuffixPresenceCheck(variableName, entry.getPresenceChecker().getPresenceCheckSuffix()));
                        variableName = variableName + "." + entry.getReadAccessor().getSimpleName() + "()";
                        variableType = entry.getType();
                    }
                    sourcePresenceChecker = presenceChecks.size() == 1 ? (PresenceCheck)presenceChecks.get(0) : new AllPresenceChecksPresenceCheck(presenceChecks);
                }
            }
            return sourcePresenceChecker;
        }

        private Assignment forgeStreamMapping(Type sourceType, Type targetType, SourceRHS source) {
            StreamMappingMethod.Builder builder = new StreamMappingMethod.Builder();
            return this.forgeWithElementMapping(sourceType, targetType, source, builder);
        }

        private Assignment forgeIterableMapping(Type sourceType, Type targetType, SourceRHS source) {
            IterableMappingMethod.Builder builder = new IterableMappingMethod.Builder();
            return this.forgeWithElementMapping(sourceType, targetType, source, builder);
        }

        private Assignment forgeWithElementMapping(Type sourceType, Type targetType, SourceRHS source, ContainerMappingMethodBuilder<?, ? extends ContainerMappingMethod> builder) {
            targetType = targetType.withoutBounds();
            ForgedMethod methodRef = this.prepareForgedMethod(sourceType, targetType, source, "[]");
            Supplier<MappingMethod> mappingMethodCreator = () -> ((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)builder.mappingContext(this.ctx)).method(methodRef)).selectionParameters(this.selectionParameters)).callingContextTargetPropertyName(this.targetPropertyName)).positionHint(this.positionHint)).build();
            return this.getOrCreateForgedAssignment(source, methodRef, mappingMethodCreator);
        }

        private ForgedMethod prepareForgedMethod(Type sourceType, Type targetType, SourceRHS source, String suffix) {
            String name = this.getName(sourceType, targetType);
            name = Strings.getSafeVariableName(name, this.ctx.getReservedNames());
            ForgedMethodHistory forgedMethodHistory = this.getForgedMethodHistory(source, suffix);
            return ForgedMethod.forElementMapping(name, sourceType, targetType, this.method, forgedMethodHistory, this.forgedNamedBased);
        }

        private Assignment forgeMapMapping(Type sourceType, Type targetType, SourceRHS source) {
            targetType = targetType.withoutBounds();
            ForgedMethod methodRef = this.prepareForgedMethod(sourceType, targetType, source, "{}");
            MapMappingMethod.Builder builder = new MapMappingMethod.Builder();
            Supplier<MappingMethod> mapMappingMethodCreator = () -> ((MapMappingMethod.Builder)((MapMappingMethod.Builder)builder.mappingContext(this.ctx)).method(methodRef)).build();
            return this.getOrCreateForgedAssignment(source, methodRef, mapMappingMethodCreator);
        }

        private Assignment forgeMapping(SourceRHS sourceRHS) {
            Type sourceType = this.targetWriteAccessorType == AccessorType.ADDER ? sourceRHS.getSourceTypeForMatching() : sourceRHS.getSourceType();
            if (this.forgedNamedBased && !this.canGenerateAutoSubMappingBetween(sourceType, this.targetType)) {
                return null;
            }
            return this.forgeMapping(sourceType, this.targetType, sourceRHS);
        }

        private Assignment forgeMapping(Type sourceType, Type targetType, SourceRHS sourceRHS) {
            Type returnType;
            if (sourceType.isPrimitive() || targetType.isPrimitive()) {
                return null;
            }
            String name = this.getName(sourceType, targetType);
            name = Strings.getSafeVariableName(name, this.ctx.getReservedNames());
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.method.getContextParameters());
            if (!targetType.isEnumType() && (this.method.isUpdateMethod() || this.forceUpdateMethod) && this.targetWriteAccessorType != AccessorType.ADDER) {
                parameters.add(Parameter.forForgedMappingTarget(targetType));
                returnType = this.ctx.getTypeFactory().createVoidType();
            } else {
                returnType = targetType;
            }
            ForgedMethod forgedMethod = ForgedMethod.forPropertyMapping(name, sourceType, returnType, parameters, this.method, this.getForgedMethodHistory(sourceRHS), this.forgeMethodWithMappingReferences, this.forgedNamedBased);
            return this.createForgedAssignment(sourceRHS, forgedMethod);
        }

        private ForgedMethodHistory getForgedMethodHistory(SourceRHS sourceRHS) {
            return this.getForgedMethodHistory(sourceRHS, "");
        }

        private ForgedMethodHistory getForgedMethodHistory(SourceRHS sourceRHS, String suffix) {
            ForgedMethodHistory history = null;
            if (this.method instanceof ForgedMethod) {
                ForgedMethod method = (ForgedMethod)this.method;
                history = method.getHistory();
            }
            return new ForgedMethodHistory(history, this.getSourceElementName() + suffix, this.targetPropertyName + suffix, sourceRHS.getSourceType(), this.targetType, true, "property");
        }

        private String getName(Type sourceType, Type targetType) {
            String fromName = this.getName(sourceType);
            String toName = this.getName(targetType);
            return Strings.decapitalize(fromName + "To" + toName);
        }

        private String getName(Type type) {
            StringBuilder builder = new StringBuilder();
            for (Type typeParam : type.getTypeParameters()) {
                builder.append(typeParam.getIdentification());
            }
            builder.append(type.getIdentification());
            return builder.toString();
        }

        private String getSourceElementName() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return sourceParam.getName();
            }
            if (propertyEntries.size() == 1) {
                PropertyEntry propertyEntry = propertyEntries.get(0);
                return propertyEntry.getName();
            }
            return Strings.join(this.sourceReference.getElementNames(), ".");
        }
    }

    private static class MappingBuilderBase<T extends MappingBuilderBase<T>>
    extends AbstractBaseBuilder<T> {
        protected Accessor targetWriteAccessor;
        protected AccessorType targetWriteAccessorType;
        protected Type targetType;
        protected BuilderType targetBuilderType;
        protected ReadAccessor targetReadAccessor;
        protected String targetPropertyName;
        protected String sourcePropertyName;
        protected Set<String> dependsOn;
        protected Set<String> existingVariableNames;
        protected AnnotationMirror positionHint;

        MappingBuilderBase(Class<T> selfType) {
            super(selfType);
        }

        public T sourceMethod(Method sourceMethod) {
            return (T)((MappingBuilderBase)super.method(sourceMethod));
        }

        public T target(String targetPropertyName, ReadAccessor targetReadAccessor, Accessor targetWriteAccessor) {
            this.targetPropertyName = targetPropertyName;
            this.targetReadAccessor = targetReadAccessor;
            this.targetWriteAccessor = targetWriteAccessor;
            this.targetType = this.ctx.getTypeFactory().getType(targetWriteAccessor.getAccessedType());
            BuilderGem builder = this.method.getOptions().getBeanMapping().getBuilder();
            this.targetBuilderType = this.ctx.getTypeFactory().builderTypeFor(this.targetType, builder);
            this.targetWriteAccessorType = targetWriteAccessor.getAccessorType();
            return (T)this;
        }

        T mirror(AnnotationMirror mirror) {
            this.positionHint = mirror;
            return (T)this;
        }

        public T sourcePropertyName(String sourcePropertyName) {
            this.sourcePropertyName = sourcePropertyName;
            return (T)this;
        }

        public T dependsOn(Set<String> dependsOn) {
            this.dependsOn = dependsOn;
            return (T)this;
        }

        public T existingVariableNames(Set<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return (T)this;
        }

        protected boolean isFieldAssignment() {
            return this.targetWriteAccessorType.isFieldAssignment();
        }
    }
}

