/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.util.List;
import org.mapstruct.ap.internal.conversion.ConversionProvider;
import org.mapstruct.ap.internal.model.FromOptionalTypeConversion;
import org.mapstruct.ap.internal.model.HelperMethod;
import org.mapstruct.ap.internal.model.ToOptionalTypeConversion;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.FieldReference;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;

public class OptionalWrapperConversionProvider
implements ConversionProvider {
    private final ConversionProvider conversionProvider;

    public OptionalWrapperConversionProvider(ConversionProvider conversionProvider) {
        this.conversionProvider = conversionProvider;
    }

    @Override
    public Assignment to(ConversionContext conversionContext) {
        Assignment assignment = this.conversionProvider.to(new OptionalConversionContext(conversionContext));
        return new ToOptionalTypeConversion(conversionContext.getTargetType(), assignment);
    }

    @Override
    public Assignment from(ConversionContext conversionContext) {
        Assignment assignment = this.conversionProvider.to(new OptionalConversionContext(conversionContext));
        return new FromOptionalTypeConversion(conversionContext.getSourceType(), assignment);
    }

    @Override
    public List<HelperMethod> getRequiredHelperMethods(ConversionContext conversionContext) {
        return this.conversionProvider.getRequiredHelperMethods(conversionContext);
    }

    @Override
    public List<FieldReference> getRequiredHelperFields(ConversionContext conversionContext) {
        return this.conversionProvider.getRequiredHelperFields(conversionContext);
    }

    private static class OptionalConversionContext
    implements ConversionContext {
        private final ConversionContext delegate;

        private OptionalConversionContext(ConversionContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public Type getTargetType() {
            return this.resolveType(this.delegate.getTargetType());
        }

        @Override
        public Type getSourceType() {
            return this.resolveType(this.delegate.getSourceType());
        }

        private Type resolveType(Type type) {
            if (type.isOptionalType()) {
                return type.getOptionalBaseType();
            }
            return type;
        }

        @Override
        public String getDateFormat() {
            return this.delegate.getDateFormat();
        }

        @Override
        public String getNumberFormat() {
            return this.delegate.getNumberFormat();
        }

        @Override
        public String getLocale() {
            return this.delegate.getLocale();
        }

        @Override
        public TypeFactory getTypeFactory() {
            return this.delegate.getTypeFactory();
        }
    }
}

