/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Currency;
import java.util.Locale;
import java.util.UUID;
import org.mapstruct.ap.internal.model.common.ConversionContext;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    private static String typeReferenceName(ConversionContext conversionContext, String canonicalName) {
        return conversionContext.getTypeFactory().getType(canonicalName).createReferenceName();
    }

    private static String typeReferenceName(ConversionContext conversionContext, Class<?> type) {
        return conversionContext.getTypeFactory().getType(type).createReferenceName();
    }

    public static String bigDecimal(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, BigDecimal.class);
    }

    public static String bigInteger(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, BigInteger.class);
    }

    public static String locale(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Locale.class);
    }

    public static String currency(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Currency.class);
    }

    public static String sqlDate(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Date.class);
    }

    public static String time(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Time.class);
    }

    public static String timestamp(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, Timestamp.class);
    }

    public static String decimalFormat(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, DecimalFormat.class);
    }

    public static String simpleDateFormat(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, SimpleDateFormat.class);
    }

    public static String date(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, java.util.Date.class);
    }

    public static String zoneOffset(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, ZoneOffset.class);
    }

    public static String zoneId(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, ZoneId.class);
    }

    public static String localDate(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, LocalDate.class);
    }

    public static String localDateTime(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, LocalDateTime.class);
    }

    public static String zonedDateTime(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, ZonedDateTime.class);
    }

    public static String dateTimeFormatter(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, DateTimeFormatter.class);
    }

    public static String dateTimeFormat(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, "org.joda.time.format.DateTimeFormat");
    }

    public static String stringBuilder(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, StringBuilder.class);
    }

    public static String uuid(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, UUID.class);
    }

    public static String url(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, URL.class);
    }

    public static String decimalFormatSymbols(ConversionContext conversionContext) {
        return ConversionUtils.typeReferenceName(conversionContext, DecimalFormatSymbols.class);
    }
}

