/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.gem.MapperGem;
import org.mapstruct.ap.internal.option.MappingOption;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.processor.DefaultModelElementProcessorContext;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.AnnotationProcessingException;
import org.mapstruct.ap.internal.util.AnnotationProcessorContext;
import org.mapstruct.ap.internal.util.RoundContext;
import org.mapstruct.ap.internal.util.Services;
import org.mapstruct.ap.spi.AdditionalSupportedOptionsProvider;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

@SupportedAnnotationTypes(value={"org.mapstruct.Mapper"})
public class MappingProcessor
extends AbstractProcessor {
    private static final boolean ANNOTATIONS_CLAIMED_EXCLUSIVELY = false;
    @Deprecated
    protected static final String SUPPRESS_GENERATOR_TIMESTAMP = MappingOption.SUPPRESS_GENERATOR_TIMESTAMP.getOptionName();
    @Deprecated
    protected static final String SUPPRESS_GENERATOR_VERSION_INFO_COMMENT = MappingOption.SUPPRESS_GENERATOR_VERSION_INFO_COMMENT.getOptionName();
    @Deprecated
    protected static final String UNMAPPED_TARGET_POLICY = MappingOption.UNMAPPED_TARGET_POLICY.getOptionName();
    @Deprecated
    protected static final String UNMAPPED_SOURCE_POLICY = MappingOption.UNMAPPED_SOURCE_POLICY.getOptionName();
    @Deprecated
    protected static final String DEFAULT_COMPONENT_MODEL = MappingOption.DEFAULT_COMPONENT_MODEL.getOptionName();
    @Deprecated
    protected static final String DEFAULT_INJECTION_STRATEGY = MappingOption.DEFAULT_INJECTION_STRATEGY.getOptionName();
    @Deprecated
    protected static final String ALWAYS_GENERATE_SERVICE_FILE = MappingOption.ALWAYS_GENERATE_SERVICE_FILE.getOptionName();
    @Deprecated
    protected static final String DISABLE_BUILDERS = MappingOption.DISABLE_BUILDERS.getOptionName();
    @Deprecated
    protected static final String VERBOSE = MappingOption.VERBOSE.getOptionName();
    @Deprecated
    protected static final String NULL_VALUE_ITERABLE_MAPPING_STRATEGY = MappingOption.NULL_VALUE_ITERABLE_MAPPING_STRATEGY.getOptionName();
    @Deprecated
    protected static final String NULL_VALUE_MAP_MAPPING_STRATEGY = MappingOption.NULL_VALUE_MAP_MAPPING_STRATEGY.getOptionName();
    private final Set<String> additionalSupportedOptions;
    private final String additionalSupportedOptionsError;
    private Options options;
    private AnnotationProcessorContext annotationProcessorContext;
    private Set<DeferredMapper> deferredMappers = new HashSet<DeferredMapper>();

    public MappingProcessor() {
        String additionalSupportedOptionsError;
        Set<String> additionalSupportedOptions;
        try {
            additionalSupportedOptions = MappingProcessor.resolveAdditionalSupportedOptions();
            additionalSupportedOptionsError = null;
        }
        catch (IllegalStateException ex) {
            additionalSupportedOptions = Collections.emptySet();
            additionalSupportedOptionsError = ex.getMessage();
        }
        this.additionalSupportedOptions = additionalSupportedOptions;
        this.additionalSupportedOptionsError = additionalSupportedOptionsError;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.options = new Options(processingEnv.getOptions());
        this.annotationProcessorContext = new AnnotationProcessorContext(processingEnv.getElementUtils(), processingEnv.getTypeUtils(), processingEnv.getMessager(), this.options.isDisableBuilders(), this.options.isVerbose(), this.resolveAdditionalOptions(processingEnv.getOptions()));
        if (this.additionalSupportedOptionsError != null) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.additionalSupportedOptionsError);
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (!roundEnvironment.processingOver()) {
            RoundContext roundContext = new RoundContext(this.annotationProcessorContext);
            Set<TypeElement> deferredMappers = this.getAndResetDeferredMappers();
            this.processMapperElements(deferredMappers, roundContext);
            Set<TypeElement> mappers = this.getMappers(annotations, roundEnvironment);
            this.processMapperElements(mappers, roundContext);
        } else if (!this.deferredMappers.isEmpty()) {
            for (DeferredMapper deferredMapper : this.deferredMappers) {
                TypeElement deferredMapperElement = deferredMapper.deferredMapperElement;
                Element erroneousElement = deferredMapper.erroneousElement;
                String erroneousElementName = erroneousElement instanceof QualifiedNameable ? ((QualifiedNameable)erroneousElement).getQualifiedName().toString() : (erroneousElement != null ? erroneousElement.getSimpleName().toString() : null);
                deferredMapperElement = this.annotationProcessorContext.getElementUtils().getTypeElement(deferredMapperElement.getQualifiedName());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "No implementation was created for " + deferredMapperElement.getSimpleName() + " due to having a problem in the erroneous element " + erroneousElementName + ". Hint: this often means that some other annotation processor was supposed to process the erroneous element. You can also enable MapStruct verbose mode by setting -Amapstruct.verbose=true as a compilation argument.", deferredMapperElement);
            }
        }
        return false;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Stream.concat(Stream.of(MappingOption.values()).map(MappingOption::getOptionName), this.additionalSupportedOptions.stream()).collect(Collectors.toSet());
    }

    private Set<TypeElement> getAndResetDeferredMappers() {
        HashSet<TypeElement> deferred = new HashSet<TypeElement>(this.deferredMappers.size());
        for (DeferredMapper deferredMapper : this.deferredMappers) {
            TypeElement element = deferredMapper.deferredMapperElement;
            deferred.add(this.processingEnv.getElementUtils().getTypeElement(element.getQualifiedName()));
        }
        this.deferredMappers.clear();
        return deferred;
    }

    private Set<TypeElement> getMappers(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        HashSet<TypeElement> mapperTypes = new HashSet<TypeElement>();
        for (TypeElement typeElement : annotations) {
            if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            try {
                Set<? extends Element> annotatedMappers = roundEnvironment.getElementsAnnotatedWith(typeElement);
                for (Element element : annotatedMappers) {
                    TypeElement mapperTypeElement = this.asTypeElement(element);
                    if (mapperTypeElement == null || MapperGem.instanceOn(mapperTypeElement) == null) continue;
                    mapperTypes.add(mapperTypeElement);
                }
            }
            catch (Throwable t) {
                this.handleUncaughtError(typeElement, t);
            }
        }
        return mapperTypes;
    }

    private void processMapperElements(Set<TypeElement> mapperElements, RoundContext roundContext) {
        for (TypeElement mapperElement : mapperElements) {
            try {
                List<? extends Element> tst = mapperElement.getEnclosedElements();
                DefaultModelElementProcessorContext context = new DefaultModelElementProcessorContext(this.processingEnv, this.options, roundContext, this.getDeclaredTypesNotToBeImported(mapperElement), mapperElement);
                this.processMapperTypeElement(context, mapperElement);
            }
            catch (TypeHierarchyErroneousException thie) {
                Element erroneousElement;
                TypeMirror erroneousType = thie.getType();
                Element element = erroneousElement = erroneousType != null ? roundContext.getAnnotationProcessorContext().getTypeUtils().asElement(erroneousType) : null;
                if (this.options.isVerbose()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "MapStruct: referred types not available (yet), deferring mapper: " + mapperElement);
                }
                this.deferredMappers.add(new DeferredMapper(mapperElement, erroneousElement));
            }
            catch (Throwable t) {
                this.handleUncaughtError(mapperElement, t);
                break;
            }
        }
    }

    private Map<String, String> getDeclaredTypesNotToBeImported(TypeElement element) {
        return element.getEnclosedElements().stream().filter(e -> ElementKind.CLASS.equals((Object)e.getKind())).map(Element::getSimpleName).map(CharSequence::toString).collect(Collectors.toMap(k -> k, v -> element.getQualifiedName().toString() + "." + v));
    }

    private void handleUncaughtError(Element element, Throwable thrown) {
        StringWriter sw = new StringWriter();
        thrown.printStackTrace(new PrintWriter(sw));
        String reportableStacktrace = sw.toString().replace(System.lineSeparator(), "  ");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error in the mapping processor: " + reportableStacktrace, element);
    }

    private void processMapperTypeElement(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement) {
        Object model = null;
        for (ModelElementProcessor<?, ?> processor : this.getProcessors()) {
            try {
                model = this.process(context, processor, mapperTypeElement, model);
            }
            catch (AnnotationProcessingException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement(), e.getAnnotationMirror(), e.getAnnotationValue());
                break;
            }
        }
    }

    private <P, R> R process(ModelElementProcessor.ProcessorContext context, ModelElementProcessor<P, R> processor, TypeElement mapperTypeElement, Object modelElement) {
        Object sourceElement = modelElement;
        return processor.process(context, mapperTypeElement, sourceElement);
    }

    private Iterable<ModelElementProcessor<?, ?>> getProcessors() {
        Iterator<ModelElementProcessor> processorIterator = ServiceLoader.load(ModelElementProcessor.class, MappingProcessor.class.getClassLoader()).iterator();
        ArrayList processors = new ArrayList();
        while (processorIterator.hasNext()) {
            processors.add(processorIterator.next());
        }
        processors.sort(new ProcessorComparator());
        return processors;
    }

    private TypeElement asTypeElement(Element element) {
        return element.accept(new ElementKindVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitTypeAsInterface(TypeElement e, Void p) {
                return e;
            }

            @Override
            public TypeElement visitTypeAsClass(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    private static Set<String> resolveAdditionalSupportedOptions() {
        HashSet<String> additionalSupportedOptions = null;
        for (AdditionalSupportedOptionsProvider optionsProvider : Services.all(AdditionalSupportedOptionsProvider.class)) {
            if (additionalSupportedOptions == null) {
                additionalSupportedOptions = new HashSet<String>();
            }
            Set<String> providerOptions = optionsProvider.getAdditionalSupportedOptions();
            for (String providerOption : providerOptions) {
                if (providerOption.startsWith("mapstruct")) {
                    throw new IllegalStateException("Additional SPI options cannot start with \"mapstruct\". Provider " + optionsProvider + " provided option " + providerOption);
                }
                additionalSupportedOptions.add(providerOption);
            }
        }
        return additionalSupportedOptions == null ? Collections.emptySet() : additionalSupportedOptions;
    }

    private Map<String, String> resolveAdditionalOptions(Map<String, String> options) {
        return options.entrySet().stream().filter(entry -> this.additionalSupportedOptions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class DeferredMapper {
        private final TypeElement deferredMapperElement;
        private final Element erroneousElement;

        private DeferredMapper(TypeElement deferredMapperElement, Element erroneousElement) {
            this.deferredMapperElement = deferredMapperElement;
            this.erroneousElement = erroneousElement;
        }
    }

    private static class ProcessorComparator
    implements Comparator<ModelElementProcessor<?, ?>> {
        private ProcessorComparator() {
        }

        @Override
        public int compare(ModelElementProcessor<?, ?> o1, ModelElementProcessor<?, ?> o2) {
            return Integer.compare(o1.getPriority(), o2.getPriority());
        }
    }
}

