/*
 * Decompiled with CFR 0.152.
 */
package org.logl;

import java.util.Objects;
import java.util.function.Consumer;
import org.logl.LogMessage;
import org.logl.LogWriter;

final class NullLogWriter
implements LogWriter {
    private static final NullLogWriter INSTANCE = new NullLogWriter();

    static NullLogWriter instance() {
        return INSTANCE;
    }

    private NullLogWriter() {
    }

    @Override
    public void log(LogMessage message) {
        Objects.requireNonNull(message);
    }

    @Override
    public void log(CharSequence message) {
        Objects.requireNonNull(message);
    }

    @Override
    public void log(LogMessage message, Throwable cause) {
        Objects.requireNonNull(message);
    }

    @Override
    public void log(CharSequence message, Throwable cause) {
        Objects.requireNonNull(message);
    }

    @Override
    public void logf(String format, Object ... args) {
        Objects.requireNonNull(format);
    }

    @Override
    public void batch(Consumer<LogWriter> fn) {
        Objects.requireNonNull(fn);
        fn.accept(this);
    }
}

