/*
 * Decompiled with CFR 0.152.
 */
package org.logl;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.logl.Level;
import org.logl.LogMessage;
import org.logl.LogWriter;
import org.logl.NullLogWriter;
import org.logl.NullLogger;

public interface Logger {
    public static Logger nullLogger() {
        return NullLogger.instance();
    }

    public Level getLevel();

    default public boolean isEnabled(Level level) {
        Objects.requireNonNull(level);
        if (level == Level.NONE) {
            return false;
        }
        return level.compareTo(this.getLevel()) <= 0;
    }

    default public LogWriter writer(Level level) {
        switch (level) {
            case ERROR: {
                return this.errorWriter();
            }
            case WARN: {
                return this.warnWriter();
            }
            case INFO: {
                return this.infoWriter();
            }
            case DEBUG: {
                return this.debugWriter();
            }
        }
        return NullLogWriter.instance();
    }

    default public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    default public void error(LogMessage message) {
        this.errorWriter().log(message);
    }

    default public void error(CharSequence message) {
        if (this.isErrorEnabled()) {
            this.errorWriter().log(message);
        }
    }

    default public void error(Supplier<? extends CharSequence> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.errorWriter().log(messageSupplier);
        }
    }

    default public void error(LogMessage message, Throwable cause) {
        this.errorWriter().log(message, cause);
    }

    default public void error(CharSequence message, Throwable cause) {
        if (this.isErrorEnabled()) {
            this.errorWriter().log(message, cause);
        }
    }

    default public void error(String message, Throwable cause) {
        this.error((CharSequence)message, cause);
    }

    default public void error(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.isErrorEnabled()) {
            this.errorWriter().log(messageSupplier, cause);
        }
    }

    default public void error(String pattern, Object ... args) {
        if (this.isErrorEnabled()) {
            this.errorWriter().log(pattern, args);
        }
    }

    default public void error(String pattern, Object arg) {
        if (this.isErrorEnabled()) {
            this.error(pattern, new Object[]{arg});
        }
    }

    default public void error(String pattern, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.error(pattern, new Object[]{arg1, arg2});
        }
    }

    default public void error(String pattern, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.error(pattern, new Object[]{arg1, arg2, arg3});
        }
    }

    default public void error(String pattern, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled()) {
            this.error(pattern, new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    default public void error(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isErrorEnabled()) {
            this.error(pattern, new Object[]{arg1, arg2, arg3, arg4, arg5});
        }
    }

    default public void errorf(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            this.errorWriter().logf(format, args);
        }
    }

    default public void errorf(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.errorf(format, new Object[]{arg});
        }
    }

    default public void errorf(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.errorf(format, new Object[]{arg1, arg2});
        }
    }

    default public void errorf(String format, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.errorf(format, new Object[]{arg1, arg2, arg3});
        }
    }

    default public void errorf(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled()) {
            this.errorf(format, new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    default public void errorf(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isErrorEnabled()) {
            this.errorf(format, new Object[]{arg1, arg2, arg3, arg4, arg5});
        }
    }

    public LogWriter errorWriter();

    default public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    default public void warn(LogMessage message) {
        this.warnWriter().log(message);
    }

    default public void warn(CharSequence message) {
        if (this.isWarnEnabled()) {
            this.warnWriter().log(message);
        }
    }

    default public void warn(Supplier<? extends CharSequence> messageSupplier) {
        if (this.isWarnEnabled()) {
            this.warnWriter().log(messageSupplier);
        }
    }

    default public void warn(LogMessage message, Throwable cause) {
        this.warnWriter().log(message, cause);
    }

    default public void warn(CharSequence message, Throwable cause) {
        if (this.isWarnEnabled()) {
            this.warnWriter().log(message, cause);
        }
    }

    default public void warn(String message, Throwable cause) {
        this.warn((CharSequence)message, cause);
    }

    default public void warn(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.isWarnEnabled()) {
            this.warnWriter().log(messageSupplier, cause);
        }
    }

    default public void warn(String pattern, Object ... args) {
        if (this.isWarnEnabled()) {
            this.warnWriter().log(pattern, args);
        }
    }

    default public void warn(String pattern, Object arg) {
        if (this.isWarnEnabled()) {
            this.warn(pattern, new Object[]{arg});
        }
    }

    default public void warn(String pattern, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warn(pattern, new Object[]{arg1, arg2});
        }
    }

    default public void warn(String pattern, Object arg1, Object arg2, Object arg3) {
        if (this.isWarnEnabled()) {
            this.warn(pattern, new Object[]{arg1, arg2, arg3});
        }
    }

    default public void warn(String pattern, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isWarnEnabled()) {
            this.warn(pattern, new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    default public void warn(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isWarnEnabled()) {
            this.warn(pattern, new Object[]{arg1, arg2, arg3, arg4, arg5});
        }
    }

    default public void warnf(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            this.warnWriter().logf(format, args);
        }
    }

    default public void warnf(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.warnf(format, new Object[]{arg});
        }
    }

    default public void warnf(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warnf(format, new Object[]{arg1, arg2});
        }
    }

    default public void warnf(String format, Object arg1, Object arg2, Object arg3) {
        if (this.isWarnEnabled()) {
            this.warnf(format, new Object[]{arg1, arg2, arg3});
        }
    }

    default public void warnf(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isWarnEnabled()) {
            this.warnf(format, new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    default public void warnf(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isWarnEnabled()) {
            this.warnf(format, new Object[]{arg1, arg2, arg3, arg4, arg5});
        }
    }

    public LogWriter warnWriter();

    default public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    default public void info(LogMessage message) {
        this.infoWriter().log(message);
    }

    default public void info(CharSequence message) {
        if (this.isInfoEnabled()) {
            this.infoWriter().log(message);
        }
    }

    default public void info(Supplier<? extends CharSequence> messageSupplier) {
        if (this.isInfoEnabled()) {
            this.infoWriter().log(messageSupplier);
        }
    }

    default public void info(CharSequence message, Throwable cause) {
        if (this.isInfoEnabled()) {
            this.infoWriter().log(message, cause);
        }
    }

    default public void info(String message, Throwable cause) {
        this.info((CharSequence)message, cause);
    }

    default public void info(LogMessage message, Throwable cause) {
        this.infoWriter().log(message, cause);
    }

    default public void info(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.isInfoEnabled()) {
            this.infoWriter().log(messageSupplier, cause);
        }
    }

    default public void info(String pattern, Object ... args) {
        if (this.isInfoEnabled()) {
            this.infoWriter().log(pattern, args);
        }
    }

    default public void info(String pattern, Object arg) {
        if (this.isInfoEnabled()) {
            this.info(pattern, new Object[]{arg});
        }
    }

    default public void info(String pattern, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.info(pattern, new Object[]{arg1, arg2});
        }
    }

    default public void info(String pattern, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.info(pattern, new Object[]{arg1, arg2, arg3});
        }
    }

    default public void info(String pattern, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isInfoEnabled()) {
            this.info(pattern, new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    default public void info(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isInfoEnabled()) {
            this.info(pattern, new Object[]{arg1, arg2, arg3, arg4, arg5});
        }
    }

    default public void infof(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            this.infoWriter().logf(format, args);
        }
    }

    default public void infof(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.infof(format, new Object[]{arg});
        }
    }

    default public void infof(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.infof(format, new Object[]{arg1, arg2});
        }
    }

    default public void infof(String format, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.infof(format, new Object[]{arg1, arg2, arg3});
        }
    }

    default public void infof(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isInfoEnabled()) {
            this.infof(format, new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    default public void infof(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isInfoEnabled()) {
            this.infof(format, new Object[]{arg1, arg2, arg3, arg4, arg5});
        }
    }

    public LogWriter infoWriter();

    default public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    default public void debug(LogMessage message) {
        this.debugWriter().log(message);
    }

    default public void debug(CharSequence message) {
        if (this.isDebugEnabled()) {
            this.debugWriter().log(message);
        }
    }

    default public void debug(Supplier<? extends CharSequence> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.debugWriter().log(messageSupplier);
        }
    }

    default public void debug(LogMessage message, Throwable cause) {
        this.debugWriter().log(message, cause);
    }

    default public void debug(CharSequence message, Throwable cause) {
        if (this.isDebugEnabled()) {
            this.debugWriter().log(message, cause);
        }
    }

    default public void debug(String message, Throwable cause) {
        this.debug((CharSequence)message, cause);
    }

    default public void debug(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        if (this.isDebugEnabled()) {
            this.debugWriter().log(messageSupplier, cause);
        }
    }

    default public void debug(String pattern, Object ... args) {
        if (this.isDebugEnabled()) {
            this.debugWriter().log(pattern, args);
        }
    }

    default public void debug(String pattern, Object arg) {
        if (this.isDebugEnabled()) {
            this.debug(pattern, new Object[]{arg});
        }
    }

    default public void debug(String pattern, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debug(pattern, new Object[]{arg1, arg2});
        }
    }

    default public void debug(String pattern, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.debug(pattern, new Object[]{arg1, arg2, arg3});
        }
    }

    default public void debug(String pattern, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugEnabled()) {
            this.debug(pattern, new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    default public void debug(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isDebugEnabled()) {
            this.debug(pattern, new Object[]{arg1, arg2, arg3, arg4, arg5});
        }
    }

    default public void debugf(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            this.debugWriter().logf(format, args);
        }
    }

    default public void debugf(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.debugf(format, new Object[]{arg});
        }
    }

    default public void debugf(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debugf(format, new Object[]{arg1, arg2});
        }
    }

    default public void debugf(String format, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.debugf(format, new Object[]{arg1, arg2, arg3});
        }
    }

    default public void debugf(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugEnabled()) {
            this.debugf(format, new Object[]{arg1, arg2, arg3, arg4});
        }
    }

    default public void debugf(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.isDebugEnabled()) {
            this.debugf(format, new Object[]{arg1, arg2, arg3, arg4, arg5});
        }
    }

    public LogWriter debugWriter();

    public void batch(Consumer<Logger> var1);
}

