/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.util;

import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.util.KMongoConfiguration;
import org.litote.kmongo.util.MongoIdUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u001a\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0001J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0001H\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J(\u0010\u0015\u001a\u00020\u0011\"\b\b\u0000\u0010\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\rH\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u0001J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0001J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0004J&\u0010 \u001a\u00020\u0011\"\b\b\u0000\u0010\u0016*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\rJ)\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040$2\u0006\u0010%\u001a\u00020&\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0001JG\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110*0\"\"\b\b\u0000\u0010\u0016*\u00020\u00012\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040$2\u0006\u0010%\u001a\u00020&2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\r\u00a2\u0006\u0002\u0010+J.\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110*\"\b\b\u0000\u0010\u0016*\u00020\u00012\u0006\u0010,\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\rH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/litote/kmongo/util/KMongoUtil;", "", "()V", "EMPTY_JSON", "", "getEMPTY_JSON", "()Ljava/lang/String;", "QUOTE_REPLACE_MATCHER", "kotlin.jvm.PlatformType", "SPACE_REPLACE_PATTERN", "Ljava/util/regex/Pattern;", "defaultCollectionName", "clazz", "Lkotlin/reflect/KClass;", "extractId", "obj", "filterIdToBson", "Lorg/bson/BsonDocument;", "filterIdToExtendedJson", "formatJson", "json", "generateIfAbsentAndMayBeMoveId", "T", "document", "type", "getIdValue", "value", "idFilterQuery", "id", "isJsonArray", "", "setModifier", "toBson", "toBsonList", "", "Lorg/bson/conversions/Bson;", "", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "([Ljava/lang/String;Lorg/bson/codecs/configuration/CodecRegistry;)Ljava/util/List;", "toExtendedJson", "toWriteModel", "Lcom/mongodb/client/model/WriteModel;", "([Ljava/lang/String;Lorg/bson/codecs/configuration/CodecRegistry;Lkotlin/reflect/KClass;)Ljava/util/List;", "bson", "kmongo-shared"})
public final class KMongoUtil {
    @NotNull
    private static final String EMPTY_JSON = "{}";
    private static final Pattern SPACE_REPLACE_PATTERN;
    private static final String QUOTE_REPLACE_MATCHER;
    public static final KMongoUtil INSTANCE;

    @NotNull
    public final String getEMPTY_JSON() {
        return EMPTY_JSON;
    }

    @NotNull
    public final BsonDocument toBson(@NotNull String json) {
        BsonDocument bsonDocument;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        if (Intrinsics.areEqual((Object)json, (Object)EMPTY_JSON)) {
            bsonDocument = new BsonDocument();
        } else {
            BsonDocument bsonDocument2 = BsonDocument.parse((String)json);
            bsonDocument = bsonDocument2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bsonDocument2, (String)"BsonDocument.parse(json)");
        }
        return bsonDocument;
    }

    @NotNull
    public final <T> BsonDocument toBson(@NotNull String json, @NotNull KClass<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return this.generateIfAbsentAndMayBeMoveId(this.toBson(json), type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T> BsonDocument generateIfAbsentAndMayBeMoveId(BsonDocument document, KClass<T> type) {
        KProperty1<?, ?> idProperty;
        if (document.containsKey((Object)"_id") || (idProperty = MongoIdUtil.INSTANCE.findIdProperty(type)) == null) return document;
        BsonValue idValue = (BsonValue)document.get((Object)idProperty.getName());
        if (idValue == null) {
            String toString = idProperty.getReturnType().toString();
            if (StringsKt.startsWith$default((String)toString, (String)KClasses.getDefaultType((KClass)Reflection.getOrCreateKotlinClass(ObjectId.class)).toString(), (boolean)false, (int)2, null)) {
                document.put("_id", (BsonValue)new BsonObjectId(ObjectId.get()));
            } else {
                if (!StringsKt.startsWith$default((String)toString, (String)KClasses.getDefaultType((KClass)Reflection.getOrCreateKotlinClass(String.class)).toString(), (boolean)false, (int)2, null)) throw (Throwable)new IllegalArgumentException("generation for id property type not supported : " + idProperty);
                document.put("_id", (BsonValue)new BsonString(ObjectId.get().toString()));
            }
        } else {
            document.put("_id", idValue);
        }
        if (!(Intrinsics.areEqual((Object)idProperty.getName(), (Object)"_id") ^ true)) return document;
        document.remove((Object)idProperty.getName());
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bson> toBsonList(@NotNull String[] json, @NotNull CodecRegistry codecRegistry) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)codecRegistry, (String)"codecRegistry");
        if (((Object[])json).length == 1 && this.isJsonArray(json[0])) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = (Iterable)new BsonArrayCodec(codecRegistry).decode((BsonReader)new JsonReader(json[0]), DecoderContext.builder().build());
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                BsonValue bsonValue = (BsonValue)item$iv$iv;
                void var12_15 = destination$iv$iv;
                void v0 = it;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonDocument");
                }
                BsonDocument bsonDocument = (BsonDocument)v0;
                var12_15.add(bsonDocument);
            }
            list = (List)destination$iv$iv;
        } else {
            Object[] $receiver$iv = json;
            Object[] $receiver$iv$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            for (int i = 0; i < $receiver$iv$iv.length; ++i) {
                Object item$iv$iv = $receiver$iv$iv[i];
                String it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                BsonDocument bsonDocument = INSTANCE.toBson(it);
                collection.add(bsonDocument);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final BsonDocument filterIdToBson(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return (BsonDocument)new RawBsonDocument(KMongoConfiguration.INSTANCE.getFilterIdBsonMapper().writeValueAsBytes(obj));
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        String string = SPACE_REPLACE_PATTERN.matcher(json).replaceAll(QUOTE_REPLACE_MATCHER);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SPACE_REPLACE_PATTERN.ma\u2026ll(QUOTE_REPLACE_MATCHER)");
        return string;
    }

    @NotNull
    public final String toExtendedJson(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = KMongoConfiguration.INSTANCE.getExtendedJsonMapper().writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KMongoConfiguration.exte\u2026r.writeValueAsString(obj)");
        return string;
    }

    private final String filterIdToExtendedJson(Object obj) {
        String string = KMongoConfiguration.INSTANCE.getFilterIdExtendedJsonMapper().writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KMongoConfiguration.filt\u2026r.writeValueAsString(obj)");
        return string;
    }

    private final boolean isJsonArray(String json) {
        String string = json;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (char)'[', (boolean)false, (int)2, null);
    }

    @NotNull
    public final String idFilterQuery(@NotNull Object id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return "{_id:" + this.toExtendedJson(id) + "}";
    }

    @NotNull
    public final String setModifier(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return "{" + "$" + "set:" + this.filterIdToExtendedJson(obj) + "}";
    }

    @NotNull
    public final Object extractId(@NotNull Object obj, @NotNull KClass<?> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        KProperty1<?, ?> idProperty = MongoIdUtil.INSTANCE.findIdProperty(clazz);
        if (idProperty == null) {
            throw (Throwable)new IllegalArgumentException(obj + " has to contain _id field");
        }
        Object object = MongoIdUtil.INSTANCE.getIdValue(idProperty, obj);
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("id is null");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<WriteModel<BsonDocument>> toWriteModel(@NotNull String[] json, @NotNull CodecRegistry codecRegistry, @NotNull KClass<T> type) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)codecRegistry, (String)"codecRegistry");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        if (((Object[])json).length == 1 && this.isJsonArray(json[0])) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = (Iterable)new BsonArrayCodec(codecRegistry).decode((BsonReader)new JsonReader(json[0]), DecoderContext.builder().build());
            void var5_6 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                BsonValue bsonValue = (BsonValue)item$iv$iv;
                void var13_16 = destination$iv$iv;
                void v0 = it;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonDocument");
                }
                WriteModel<BsonDocument> writeModel = INSTANCE.toWriteModel((BsonDocument)v0, type);
                var13_16.add(writeModel);
            }
            list = (List)destination$iv$iv;
        } else {
            Object[] $receiver$iv = json;
            Object[] $receiver$iv$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            for (int i = 0; i < $receiver$iv$iv.length; ++i) {
                Object item$iv$iv = $receiver$iv$iv[i];
                String it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                WriteModel<BsonDocument> writeModel = INSTANCE.toWriteModel(INSTANCE.toBson(it), type);
                collection.add(writeModel);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final <T> WriteModel<BsonDocument> toWriteModel(BsonDocument bson, KClass<T> type) {
        if (bson.containsKey((Object)"insertOne")) {
            BsonDocument bsonDocument = bson.getDocument((Object)"insertOne");
            Intrinsics.checkExpressionValueIsNotNull((Object)bsonDocument, (String)"bson.getDocument(\"insertOne\")");
            return (WriteModel)new InsertOneModel((Object)this.generateIfAbsentAndMayBeMoveId(bsonDocument, type));
        }
        if (bson.containsKey((Object)"updateOne")) {
            BsonDocument updateOne = bson.getDocument((Object)"updateOne");
            return (WriteModel)new UpdateOneModel((Bson)updateOne.getDocument((Object)"filter"), (Bson)updateOne.getDocument((Object)"update"), new UpdateOptions().upsert(updateOne.getBoolean((Object)"upsert", BsonBoolean.FALSE).getValue()));
        }
        if (bson.containsKey((Object)"updateMany")) {
            BsonDocument updateMany = bson.getDocument((Object)"updateMany");
            return (WriteModel)new UpdateManyModel((Bson)updateMany.getDocument((Object)"filter"), (Bson)updateMany.getDocument((Object)"update"), new UpdateOptions().upsert(updateMany.getBoolean((Object)"upsert", BsonBoolean.FALSE).getValue()));
        }
        if (bson.containsKey((Object)"replaceOne")) {
            BsonDocument replaceOne = bson.getDocument((Object)"replaceOne");
            return (WriteModel)new ReplaceOneModel((Bson)replaceOne.getDocument((Object)"filter"), (Object)replaceOne.getDocument((Object)"replacement"), new UpdateOptions().upsert(replaceOne.getBoolean((Object)"upsert", BsonBoolean.FALSE).getValue()));
        }
        if (bson.containsKey((Object)"deleteOne")) {
            BsonDocument deleteOne = bson.getDocument((Object)"deleteOne");
            return (WriteModel)new DeleteOneModel((Bson)deleteOne.getDocument((Object)"filter"));
        }
        if (bson.containsKey((Object)"deleteMany")) {
            BsonDocument deleteMany = bson.getDocument((Object)"deleteMany");
            return (WriteModel)new DeleteManyModel((Bson)deleteMany.getDocument((Object)"filter"));
        }
        throw (Throwable)new IllegalArgumentException("unknown write model : " + bson);
    }

    @NotNull
    public final String defaultCollectionName(@NotNull KClass<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return (String)KMongoConfiguration.INSTANCE.getDefaultCollectionNameBuilder().invoke(clazz);
    }

    @Nullable
    public final Object getIdValue(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        KProperty1<?, ?> idProperty = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(value.getClass()));
        return idProperty == null ? null : MongoIdUtil.INSTANCE.getIdValue(idProperty, value);
    }

    private KMongoUtil() {
        INSTANCE = this;
        EMPTY_JSON = EMPTY_JSON;
        SPACE_REPLACE_PATTERN = Pattern.compile("\\$\\s+");
        QUOTE_REPLACE_MATCHER = Matcher.quoteReplacement("$");
    }

    static {
        new KMongoUtil();
    }
}

