/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.util.KMongoConfiguration;
import org.litote.kmongo.util.MongoIdUtil;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u001a\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0001J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0001H\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0001J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0004J)\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001e2\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/litote/kmongo/util/KMongoUtil;", "", "()V", "EMPTY_JSON", "", "getEMPTY_JSON", "()Ljava/lang/String;", "QUOTE_REPLACE_MATCHER", "kotlin.jvm.PlatformType", "SPACE_REPLACE_PATTERN", "Ljava/util/regex/Pattern;", "defaultCollectionName", "clazz", "Lkotlin/reflect/KClass;", "extractId", "obj", "filterIdToBson", "Lorg/bson/BsonDocument;", "filterIdToExtendedJson", "formatJson", "json", "idFilterQuery", "id", "isJsonArray", "", "setModifier", "toBson", "toBsonList", "", "Lorg/bson/conversions/Bson;", "", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "([Ljava/lang/String;Lorg/bson/codecs/configuration/CodecRegistry;)Ljava/util/List;", "toExtendedJson", "kmongo-shared"})
public final class KMongoUtil {
    @NotNull
    private static final String EMPTY_JSON = "{}";
    private static final Pattern SPACE_REPLACE_PATTERN;
    private static final String QUOTE_REPLACE_MATCHER;
    public static final KMongoUtil INSTANCE;

    @NotNull
    public final String getEMPTY_JSON() {
        return EMPTY_JSON;
    }

    @NotNull
    public final BsonDocument toBson(@NotNull String json) {
        BsonDocument bsonDocument;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        if (Intrinsics.areEqual((Object)json, (Object)EMPTY_JSON)) {
            bsonDocument = new BsonDocument();
        } else {
            BsonDocument bsonDocument2 = BsonDocument.parse((String)json);
            bsonDocument = bsonDocument2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bsonDocument2, (String)"BsonDocument.parse(json)");
        }
        return bsonDocument;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bson> toBsonList(@NotNull String[] json, @NotNull CodecRegistry codecRegistry) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)codecRegistry, (String)"codecRegistry");
        if (((Object[])json).length == 1 && this.isJsonArray(json[0])) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = (Iterable)new BsonArrayCodec(codecRegistry).decode((BsonReader)new JsonReader(json[0]), DecoderContext.builder().build());
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                BsonValue bsonValue = (BsonValue)item$iv$iv;
                void var12_15 = destination$iv$iv;
                void v0 = it;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonDocument");
                }
                BsonDocument bsonDocument = (BsonDocument)v0;
                var12_15.add(bsonDocument);
            }
            list = (List)destination$iv$iv;
        } else {
            Object[] $receiver$iv = json;
            Object[] $receiver$iv$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            for (int i = 0; i < $receiver$iv$iv.length; ++i) {
                Object item$iv$iv = $receiver$iv$iv[i];
                String it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                BsonDocument bsonDocument = INSTANCE.toBson(it);
                collection.add(bsonDocument);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final BsonDocument filterIdToBson(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return (BsonDocument)new RawBsonDocument(KMongoConfiguration.INSTANCE.getFilterIdBsonMapper().writeValueAsBytes(obj));
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        String string = SPACE_REPLACE_PATTERN.matcher(json).replaceAll(QUOTE_REPLACE_MATCHER);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SPACE_REPLACE_PATTERN.ma\u2026ll(QUOTE_REPLACE_MATCHER)");
        return string;
    }

    @NotNull
    public final String toExtendedJson(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = KMongoConfiguration.INSTANCE.getExtendedJsonMapper().writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KMongoConfiguration.exte\u2026r.writeValueAsString(obj)");
        return string;
    }

    private final String filterIdToExtendedJson(Object obj) {
        String string = KMongoConfiguration.INSTANCE.getFilterIdExtendedJsonMapper().writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KMongoConfiguration.filt\u2026r.writeValueAsString(obj)");
        return string;
    }

    private final boolean isJsonArray(String json) {
        String string = json;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (char)'[', (boolean)false, (int)2, null);
    }

    @NotNull
    public final String idFilterQuery(@NotNull Object id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return "{_id:" + this.toExtendedJson(id) + "}";
    }

    @NotNull
    public final String setModifier(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return "{" + "$" + "set:" + this.filterIdToExtendedJson(obj) + "}";
    }

    @NotNull
    public final Object extractId(@NotNull Object obj, @NotNull KClass<?> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        KProperty1<?, ?> idProperty = MongoIdUtil.INSTANCE.findIdProperty(clazz);
        if (idProperty == null) {
            throw (Throwable)new IllegalArgumentException(obj + " has to contain _id field");
        }
        Object object = MongoIdUtil.INSTANCE.getIdValue(idProperty, obj);
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("id is null");
        }
        return object;
    }

    @NotNull
    public final String defaultCollectionName(@NotNull KClass<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return (String)KMongoConfiguration.INSTANCE.getDefaultCollectionNameBuilder().invoke(clazz);
    }

    private KMongoUtil() {
        INSTANCE = this;
        EMPTY_JSON = EMPTY_JSON;
        SPACE_REPLACE_PATTERN = Pattern.compile("\\$\\s+");
        QUOTE_REPLACE_MATCHER = Matcher.quoteReplacement("$");
    }

    static {
        new KMongoUtil();
    }
}

