/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.util.KMongoConfiguration;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0001J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0004J)\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/litote/kmongo/util/KMongoUtil;", "", "()V", "EMPTY_JSON", "", "getEMPTY_JSON", "()Ljava/lang/String;", "mongoJsonQuoteReplacement", "kotlin.jvm.PlatformType", "mongoJsonReplacePattern", "Ljava/util/regex/Pattern;", "defaultCollectionName", "clazz", "Lkotlin/reflect/KClass;", "extractId", "Lorg/bson/types/ObjectId;", "obj", "formatJson", "json", "idFilter", "id", "isJsonArray", "", "setModifier", "toBson", "Lorg/bson/conversions/Bson;", "toBsonList", "", "", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "([Ljava/lang/String;Lorg/bson/codecs/configuration/CodecRegistry;)Ljava/util/List;", "toExtendedJson", "kmongo-shared"})
public final class KMongoUtil {
    @NotNull
    private static final String EMPTY_JSON = "{}";
    private static final Pattern mongoJsonReplacePattern;
    private static final String mongoJsonQuoteReplacement;
    public static final KMongoUtil INSTANCE;

    @NotNull
    public final String getEMPTY_JSON() {
        return EMPTY_JSON;
    }

    @NotNull
    public final Bson toBson(@NotNull String json) {
        Bson bson;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        if (Intrinsics.areEqual((Object)json, (Object)EMPTY_JSON)) {
            bson = (Bson)new BsonDocument();
        } else {
            Bson bson2 = (Bson)BsonDocument.parse((String)json);
            bson = bson2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bson2, (String)"BsonDocument.parse(json)");
        }
        return bson;
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        String string = mongoJsonReplacePattern.matcher(json).replaceAll(mongoJsonQuoteReplacement);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mongoJsonReplacePattern.\u2026ongoJsonQuoteReplacement)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bson> toBsonList(@NotNull String[] json, @NotNull CodecRegistry codecRegistry) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)codecRegistry, (String)"codecRegistry");
        if (((Object[])json).length == 1 && this.isJsonArray(json[0])) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = (Iterable)new BsonArrayCodec(codecRegistry).decode((BsonReader)new JsonReader(json[0]), DecoderContext.builder().build());
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                BsonValue bsonValue = (BsonValue)item$iv$iv;
                void var12_15 = destination$iv$iv;
                void v0 = it;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonDocument");
                }
                BsonDocument bsonDocument = (BsonDocument)v0;
                var12_15.add(bsonDocument);
            }
            list = (List)destination$iv$iv;
        } else {
            Object[] $receiver$iv = json;
            Object[] $receiver$iv$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            for (int i = 0; i < $receiver$iv$iv.length; ++i) {
                Object item$iv$iv = $receiver$iv$iv[i];
                String it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                Bson bson = INSTANCE.toBson(it);
                collection.add(bson);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final String toExtendedJson(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = KMongoConfiguration.INSTANCE.getExtendedJsonMapper().writeValueAsString(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KMongoConfiguration.exte\u2026r.writeValueAsString(obj)");
        return string;
    }

    private final boolean isJsonArray(String json) {
        String string = json;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (char)'[', (boolean)false, (int)2, null);
    }

    @NotNull
    public final String idFilter(@NotNull ObjectId id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return "{_id:" + this.toExtendedJson(id) + "}";
    }

    @NotNull
    public final String setModifier(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return "{" + "$" + "set:" + this.toExtendedJson(obj) + "}";
    }

    @NotNull
    public final ObjectId extractId(@NotNull Object obj, @NotNull KClass<?> clazz) {
        Object v0;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Iterable iterable = KClasses.getMemberProperties(clazz);
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                KProperty1 it = (KProperty1)t;
                if (!Intrinsics.areEqual((Object)"_id", (Object)it.getName())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        Object object = ((KProperty1)v0).invoke(obj);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bson.types.ObjectId");
        }
        return (ObjectId)object;
    }

    @NotNull
    public final String defaultCollectionName(@NotNull KClass<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return (String)KMongoConfiguration.INSTANCE.getDefaultCollectionNameBuilder().invoke(clazz);
    }

    private KMongoUtil() {
        INSTANCE = this;
        EMPTY_JSON = EMPTY_JSON;
        mongoJsonReplacePattern = Pattern.compile("\\$\\s+");
        mongoJsonQuoteReplacement = Matcher.quoteReplacement("$");
    }

    static {
        new KMongoUtil();
    }
}

