/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.undercouch.bson4jackson.BsonParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.codecs.configuration.CodecProvider;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.jackson.BsonModule;
import org.litote.kmongo.jackson.ExtendedJsonModule;
import org.litote.kmongo.jackson.JacksonCodecProvider;
import org.litote.kmongo.jackson.KMongoBsonFactory;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\f\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/litote/kmongo/jackson/ObjectMapperFactory;", "", "()V", "extendedJsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getExtendedJsonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonCodecProvider", "Lorg/bson/codecs/configuration/CodecProvider;", "getJacksonCodecProvider", "()Lorg/bson/codecs/configuration/CodecProvider;", "createBsonObjectMapper", "createExtendedJsonObjectMapper", "kmongo-shared"})
public final class ObjectMapperFactory {
    @NotNull
    private static final ObjectMapper extendedJsonMapper;
    @NotNull
    private static final CodecProvider jacksonCodecProvider;
    public static final ObjectMapperFactory INSTANCE;

    @NotNull
    public final ObjectMapper getExtendedJsonMapper() {
        return extendedJsonMapper;
    }

    @NotNull
    public final CodecProvider getJacksonCodecProvider() {
        return jacksonCodecProvider;
    }

    @NotNull
    public final ObjectMapper createExtendedJsonObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule()).registerModule((Module)new ExtendedJsonModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper()\n         \u2026Include.Include.NON_NULL)");
        return objectMapper;
    }

    @NotNull
    public final ObjectMapper createBsonObjectMapper() {
        KMongoBsonFactory bsonFactory = new KMongoBsonFactory();
        bsonFactory.enable(BsonParser.Feature.HONOR_DOCUMENT_LENGTH);
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)bsonFactory).registerModule((Module)new de.undercouch.bson4jackson.BsonModule()).registerModule((Module)new KotlinModule()).registerModule((Module)new BsonModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper(bsonFactory\u2026Include.Include.NON_NULL)");
        return objectMapper;
    }

    private ObjectMapperFactory() {
        INSTANCE = this;
        extendedJsonMapper = this.createExtendedJsonObjectMapper();
        jacksonCodecProvider = new JacksonCodecProvider(this.createBsonObjectMapper());
    }

    static {
        new ObjectMapperFactory();
    }
}

