/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.serialization;

import com.github.jershell.kbson.FlexibleDecoder;
import com.github.jershell.kbson.ObjectIdSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.bson.AbstractBsonReader;
import org.bson.BsonType;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import org.litote.kmongo.id.IdGenerator;
import org.litote.kmongo.id.IdTransformer;
import org.litote.kmongo.id.ObjectIdGenerator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0002J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/litote/kmongo/serialization/IdSerializer;", "T", "Lorg/litote/kmongo/Id;", "Lkotlinx/serialization/KSerializer;", "shouldBeStringId", "", "<init>", "(Z)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Lorg/litote/kmongo/Id;", "deserializeObjectId", "", "Lcom/github/jershell/kbson/FlexibleDecoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Lorg/litote/kmongo/Id;)V", "kmongo-serialization-mapping"})
public final class IdSerializer<T extends Id<?>>
implements KSerializer<T> {
    private final boolean shouldBeStringId;
    @NotNull
    private final SerialDescriptor descriptor;

    public IdSerializer(boolean shouldBeStringId) {
        this.shouldBeStringId = shouldBeStringId;
        this.descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"IdSerializer", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Id id = IdTransformer.INSTANCE.wrapId(this.deserializeObjectId((FlexibleDecoder)decoder));
        Intrinsics.checkNotNull((Object)id, (String)"null cannot be cast to non-null type T of org.litote.kmongo.serialization.IdSerializer");
        return (T)id;
    }

    private final Object deserializeObjectId(FlexibleDecoder decoder) {
        Object object;
        Object alreadyRead = decoder.getAlreadyReadId();
        if (alreadyRead != null) {
            decoder.setAlreadyReadId(null);
            object = alreadyRead;
        } else if (decoder.getReader().getState() == AbstractBsonReader.State.NAME) {
            String keyId = decoder.getReader().readName();
            object = this.shouldBeStringId || !Intrinsics.areEqual((Object)IdGenerator.Companion.getDefaultGenerator(), (Object)ObjectIdGenerator.INSTANCE) ? keyId : new ObjectId(keyId);
        } else {
            BsonType bsonType = decoder.getReader().getCurrentBsonType();
            switch (bsonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
                case 1: {
                    object = decoder.decodeString();
                    break;
                }
                case 2: {
                    object = decoder.getReader().readObjectId();
                    break;
                }
                default: {
                    throw new SerializationException("Unsupported " + decoder.getReader().getCurrentBsonType() + " when reading _id");
                }
            }
        }
        return object;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull T value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object it = object = IdTransformer.INSTANCE.unwrapId(value);
        boolean bl = false;
        Object object2 = it;
        if (object2 instanceof String) {
            encoder.encodeString((String)it);
        } else if (object2 instanceof ObjectId) {
            ObjectIdSerializer.INSTANCE.serialize(encoder, (ObjectId)it);
        } else {
            throw new IllegalStateException(("unsupported id type " + value).toString());
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BsonType.values().length];
            try {
                nArray[BsonType.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.OBJECT_ID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

