/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.serialization;

import com.github.jershell.kbson.FlexibleDecoder;
import com.github.jershell.kbson.ObjectIdSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.bson.AbstractBsonReader;
import org.bson.BsonType;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import org.litote.kmongo.id.IdGenerator;
import org.litote.kmongo.id.IdTransformer;
import org.litote.kmongo.id.ObjectIdGenerator;
import org.litote.kmongo.serialization.IdSerializer$WhenMappings;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/litote/kmongo/serialization/IdSerializer;", "T", "Lorg/litote/kmongo/Id;", "Lkotlinx/serialization/KSerializer;", "shouldBeStringId", "", "(Z)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Lorg/litote/kmongo/Id;", "deserializeObjectId", "", "Lcom/github/jershell/kbson/FlexibleDecoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Lorg/litote/kmongo/Id;)V", "kmongo-serialization-mapping"})
public final class IdSerializer<T extends Id<?>>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    private final boolean shouldBeStringId;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Id id = IdTransformer.INSTANCE.wrapId(this.deserializeObjectId((FlexibleDecoder)decoder));
        if (id == null) {
            throw new NullPointerException("null cannot be cast to non-null type T");
        }
        return (T)id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object deserializeObjectId(FlexibleDecoder decoder) {
        String string;
        if (decoder.getReader().getState() == AbstractBsonReader.State.NAME) {
            String keyId = decoder.getReader().readName();
            string = this.shouldBeStringId || Intrinsics.areEqual((Object)IdGenerator.Companion.getDefaultGenerator(), (Object)ObjectIdGenerator.INSTANCE) ^ true ? keyId : new ObjectId(keyId);
        } else {
            BsonType bsonType = decoder.getReader().getCurrentBsonType();
            if (bsonType == null) throw (Throwable)new SerializationException("Unsupported " + decoder.getReader().getCurrentBsonType() + " reading object id");
            switch (IdSerializer$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
                case 1: {
                    string = decoder.decodeString();
                    break;
                }
                case 2: {
                    string = decoder.getReader().readObjectId();
                    break;
                }
                default: {
                    throw (Throwable)new SerializationException("Unsupported " + decoder.getReader().getCurrentBsonType() + " reading object id");
                }
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (decoder.reader.state\u2026)\n            }\n        }");
        return string;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object object = IdTransformer.INSTANCE.unwrapId(value);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof String) {
            encoder.encodeString((String)it);
        } else if (object2 instanceof ObjectId) {
            ObjectIdSerializer.INSTANCE.serialize(encoder, (ObjectId)it);
        } else {
            String string = "unsupported id type " + value;
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public IdSerializer(boolean shouldBeStringId) {
        this.shouldBeStringId = shouldBeStringId;
        this.descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"IdSerializer", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }
}

