/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.serialization;

import com.github.jershell.kbson.BsonDocumentDecoder;
import com.github.jershell.kbson.ObjectIdSerializer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.DescriptorsKt;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.internal.PrimitiveDescriptor;
import kotlinx.serialization.internal.StringDescriptor;
import org.bson.BsonInvalidOperationException;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import org.litote.kmongo.id.IdTransformer;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/litote/kmongo/serialization/IdSerializer;", "T", "Lorg/litote/kmongo/Id;", "Lkotlinx/serialization/KSerializer;", "shouldBeStringId", "", "(Z)V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "getShouldBeStringId", "()Z", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Lorg/litote/kmongo/Id;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "obj", "(Lkotlinx/serialization/Encoder;Lorg/litote/kmongo/Id;)V", "kmongo-serialization-mapping"})
public final class IdSerializer<T extends Id<?>>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    private final boolean shouldBeStringId;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Id id;
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        if (this.shouldBeStringId) {
            Id id2;
            try {
                id2 = IdTransformer.INSTANCE.wrapId((Object)decoder.decodeString());
            }
            catch (BsonInvalidOperationException e) {
                id2 = IdTransformer.INSTANCE.wrapId((Object)((BsonDocumentDecoder)decoder).decodeObjectId());
            }
            id = id2;
        } else {
            Id id3;
            try {
                id3 = IdTransformer.INSTANCE.wrapId((Object)((BsonDocumentDecoder)decoder).decodeObjectId());
            }
            catch (BsonInvalidOperationException e) {
                id3 = IdTransformer.INSTANCE.wrapId((Object)decoder.decodeString());
            }
            id = id3;
        }
        if (id == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)id;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull T obj) {
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Object object = IdTransformer.INSTANCE.unwrapId(obj);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof String) {
            encoder.encodeString((String)it);
        } else if (object2 instanceof ObjectId) {
            ObjectIdSerializer.INSTANCE.serialize(encoder, (ObjectId)it);
        } else {
            String string = "unsupported id type " + obj;
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public final boolean getShouldBeStringId() {
        return this.shouldBeStringId;
    }

    public IdSerializer(boolean shouldBeStringId) {
        this.shouldBeStringId = shouldBeStringId;
        this.descriptor = DescriptorsKt.withName((PrimitiveDescriptor)((PrimitiveDescriptor)StringDescriptor.INSTANCE), (String)"IdSerializer");
    }

    @NotNull
    public T patch(@NotNull Decoder decoder, @NotNull T old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull(old, (String)"old");
        return (T)((Id)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, old));
    }
}

