/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.codecs.pojo.ClassModelBuilder2;
import org.bson.codecs.pojo.Convention2;
import org.bson.codecs.pojo.ConventionAnnotationImpl2;
import org.bson.codecs.pojo.KMongoConvention;
import org.bson.codecs.pojo.KotlinInstanceCreatorFactory;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.annotations.BsonDiscriminator;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u001c\u0010\n\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/bson/codecs/pojo/KMongoAnnotationConvention;", "Lorg/bson/codecs/pojo/Convention2;", "<init>", "()V", "defaultConvention", "Lorg/bson/codecs/pojo/ConventionAnnotationImpl2;", "apply", "", "classModelBuilder", "Lorg/bson/codecs/pojo/ClassModelBuilder2;", "processClassAnnotation", "annotation", "", "processPropertyAnnotations", "propertyModelBuilder", "Lorg/bson/codecs/pojo/PropertyModelBuilder;", "cleanPropertyBuilders", "kmongo-native-mapping"})
public final class KMongoAnnotationConvention
implements Convention2 {
    @NotNull
    public static final KMongoAnnotationConvention INSTANCE = new KMongoAnnotationConvention();
    @NotNull
    private static final ConventionAnnotationImpl2 defaultConvention = new ConventionAnnotationImpl2();

    private KMongoAnnotationConvention() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void apply(@NotNull ClassModelBuilder2<?> classModelBuilder) {
        Intrinsics.checkNotNullParameter(classModelBuilder, (String)"classModelBuilder");
        Class<Collection> type = classModelBuilder.getType();
        if (!(type.isArray() || type.isEnum() || type.isAssignableFrom(Collection.class))) {
            Intrinsics.checkNotNull(type);
            if (KMongoConvention.Companion.isKotlinClass(type)) {
                for (Annotation annotation : classModelBuilder.getAnnotations()) {
                    Intrinsics.checkNotNull((Object)annotation);
                    this.processClassAnnotation(classModelBuilder, annotation);
                }
                Iterator<Annotation> iterator = classModelBuilder.getPropertyModelBuilders().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        classModelBuilder.instanceCreatorFactory(new KotlinInstanceCreatorFactory(JvmClassMappingKt.getKotlinClass(type)));
                        this.cleanPropertyBuilders(classModelBuilder);
                        return;
                    }
                    PropertyModelBuilder propertyModelBuilder = (PropertyModelBuilder)iterator.next();
                    Intrinsics.checkNotNull((Object)propertyModelBuilder);
                    this.processPropertyAnnotations(classModelBuilder, propertyModelBuilder);
                }
            }
        }
        defaultConvention.apply(classModelBuilder);
    }

    private final void processClassAnnotation(ClassModelBuilder2<?> classModelBuilder, Annotation annotation) {
        if (annotation instanceof BsonDiscriminator) {
            String name;
            String key = ((BsonDiscriminator)annotation).key();
            if (!Intrinsics.areEqual((Object)key, (Object)"")) {
                classModelBuilder.discriminatorKey(key);
            }
            if (!Intrinsics.areEqual((Object)(name = ((BsonDiscriminator)annotation).value()), (Object)"")) {
                classModelBuilder.discriminator(name);
            }
            classModelBuilder.enableDiscriminator(true);
        }
    }

    private final void processPropertyAnnotations(ClassModelBuilder2<?> classModelBuilder, PropertyModelBuilder<?> propertyModelBuilder) {
        for (Annotation annotation : propertyModelBuilder.getReadAnnotations()) {
            if (annotation instanceof BsonProperty) {
                if (!Intrinsics.areEqual((Object)"", (Object)((BsonProperty)annotation).value())) {
                    propertyModelBuilder.readName(((BsonProperty)annotation).value());
                }
                propertyModelBuilder.discriminatorEnabled(((BsonProperty)annotation).useDiscriminator());
                continue;
            }
            if (annotation instanceof BsonId) {
                classModelBuilder.idPropertyName(propertyModelBuilder.getName());
                continue;
            }
            if (!(annotation instanceof BsonIgnore)) continue;
            propertyModelBuilder.readName(null);
        }
        for (Annotation annotation : propertyModelBuilder.getWriteAnnotations()) {
            if (annotation instanceof BsonProperty) {
                if (Intrinsics.areEqual((Object)"", (Object)((BsonProperty)annotation).value())) continue;
                propertyModelBuilder.writeName(((BsonProperty)annotation).value());
                continue;
            }
            if (!(annotation instanceof BsonIgnore)) continue;
            propertyModelBuilder.writeName(null);
        }
    }

    private final void cleanPropertyBuilders(ClassModelBuilder2<?> classModelBuilder) {
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        for (PropertyModelBuilder<?> propertyModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
            if (propertyModelBuilder.isReadable() || propertyModelBuilder.isWritable()) continue;
            propertiesToRemove.add(propertyModelBuilder.getName());
        }
        Iterator iterator = propertiesToRemove.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
            String propertyName = (String)object;
            classModelBuilder.removeProperty(propertyName);
        }
    }
}

