/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeWithTypeParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.id.IdGenerator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0002\u00a8\u0006\r"}, d2={"Lorg/bson/codecs/pojo/KeyObjectMapPropertyCodecProvider;", "Lorg/bson/codecs/pojo/PropertyCodecProvider;", "()V", "get", "Lorg/bson/codecs/Codec;", "T", "type", "Lorg/bson/codecs/pojo/TypeWithTypeParameters;", "registry", "Lorg/bson/codecs/pojo/PropertyCodecRegistry;", "IdMapCodec", "KeyObjectMapCodec", "LocaleMapCodec", "kmongo-native-mapping"})
public final class KeyObjectMapPropertyCodecProvider
implements PropertyCodecProvider {
    @NotNull
    public static final KeyObjectMapPropertyCodecProvider INSTANCE = new KeyObjectMapPropertyCodecProvider();

    private KeyObjectMapPropertyCodecProvider() {
    }

    @Nullable
    public <T> Codec<T> get(@NotNull TypeWithTypeParameters<T> type, @NotNull PropertyCodecRegistry registry) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (Map.class.isAssignableFrom(type.getType()) && type.getTypeParameters().size() == 2) {
            Class keyType = ((TypeWithTypeParameters)type.getTypeParameters().get(0)).getType();
            if (keyType.isAssignableFrom(Id.class)) {
                Class clazz = type.getType();
                Intrinsics.checkNotNull((Object)clazz, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.collections.Map<org.litote.kmongo.Id<*>, kotlin.Any>>");
                Codec codec = registry.get((TypeWithTypeParameters)type.getTypeParameters().get(1));
                Intrinsics.checkNotNull((Object)codec, (String)"null cannot be cast to non-null type org.bson.codecs.Codec<kotlin.Any>");
                return new IdMapCodec(clazz, codec);
            }
            if (Intrinsics.areEqual((Object)keyType, Locale.class)) {
                Class clazz = type.getType();
                Intrinsics.checkNotNull((Object)clazz, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.collections.Map<java.util.Locale, kotlin.Any>>");
                Codec codec = registry.get((TypeWithTypeParameters)type.getTypeParameters().get(1));
                Intrinsics.checkNotNull((Object)codec, (String)"null cannot be cast to non-null type org.bson.codecs.Codec<kotlin.Any>");
                return new LocaleMapCodec(clazz, codec);
            }
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B1\u0012\u001c\u0010\u0004\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\f2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/bson/codecs/pojo/KeyObjectMapPropertyCodecProvider$IdMapCodec;", "T", "Lorg/bson/codecs/pojo/KeyObjectMapPropertyCodecProvider$KeyObjectMapCodec;", "Lorg/litote/kmongo/Id;", "mapEncoderClass", "Ljava/lang/Class;", "", "codec", "Lorg/bson/codecs/Codec;", "(Ljava/lang/Class;Lorg/bson/codecs/Codec;)V", "decode", "key", "", "encode", "kmongo-native-mapping"})
    public static final class IdMapCodec<T>
    extends KeyObjectMapCodec<Id<?>, T> {
        public IdMapCodec(@NotNull Class<Map<Id<?>, T>> mapEncoderClass, @NotNull Codec<T> codec) {
            Intrinsics.checkNotNullParameter(mapEncoderClass, (String)"mapEncoderClass");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            super(mapEncoderClass, codec);
        }

        @Override
        @NotNull
        public String encode(@NotNull Id<?> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return key.toString();
        }

        @Override
        @NotNull
        public Id<?> decode(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return IdGenerator.Companion.getDefaultGenerator().create(key);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B-\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0013H&\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0015\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001aJ,\u0010\u0019\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u0006H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/bson/codecs/pojo/KeyObjectMapPropertyCodecProvider$KeyObjectMapCodec;", "K", "T", "Lorg/bson/codecs/Codec;", "", "mapEncoderClass", "Ljava/lang/Class;", "codec", "(Ljava/lang/Class;Lorg/bson/codecs/Codec;)V", "getCodec", "()Lorg/bson/codecs/Codec;", "instance", "", "getInstance", "()Ljava/util/Map;", "getMapEncoderClass", "()Ljava/lang/Class;", "decode", "key", "", "(Ljava/lang/String;)Ljava/lang/Object;", "reader", "Lorg/bson/BsonReader;", "context", "Lorg/bson/codecs/DecoderContext;", "encode", "(Ljava/lang/Object;)Ljava/lang/String;", "", "writer", "Lorg/bson/BsonWriter;", "map", "encoderContext", "Lorg/bson/codecs/EncoderContext;", "getEncoderClass", "kmongo-native-mapping"})
    public static abstract class KeyObjectMapCodec<K, T>
    implements Codec<Map<K, ? extends T>> {
        @NotNull
        private final Class<Map<K, T>> mapEncoderClass;
        @NotNull
        private final Codec<T> codec;

        public KeyObjectMapCodec(@NotNull Class<Map<K, T>> mapEncoderClass, @NotNull Codec<T> codec) {
            Intrinsics.checkNotNullParameter(mapEncoderClass, (String)"mapEncoderClass");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            this.mapEncoderClass = mapEncoderClass;
            this.codec = codec;
        }

        @NotNull
        public final Class<Map<K, T>> getMapEncoderClass() {
            return this.mapEncoderClass;
        }

        @NotNull
        public final Codec<T> getCodec() {
            return this.codec;
        }

        private final Map<K, T> getInstance() {
            if (this.mapEncoderClass.isInterface()) {
                return new HashMap();
            }
            try {
                Map<K, T> map = this.mapEncoderClass.newInstance();
                Intrinsics.checkNotNullExpressionValue(map, (String)"mapEncoderClass.newInstance()");
                return MapsKt.toMutableMap(map);
            }
            catch (Exception e) {
                throw new CodecConfigurationException(e.getMessage(), (Throwable)e);
            }
        }

        @NotNull
        public abstract String encode(K var1);

        public abstract K decode(@NotNull String var1);

        public void encode(@NotNull BsonWriter writer, @NotNull Map<K, ? extends T> map, @NotNull EncoderContext encoderContext) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)encoderContext, (String)"encoderContext");
            writer.writeStartDocument();
            for (Map.Entry<K, T> entry : map.entrySet()) {
                K key = entry.getKey();
                T value = entry.getValue();
                writer.writeName(String.valueOf(key));
                this.codec.encode(writer, value, encoderContext);
            }
            writer.writeEndDocument();
        }

        @NotNull
        public Map<K, T> decode(@NotNull BsonReader reader, @NotNull DecoderContext context) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            reader.readStartDocument();
            Map<K, T> map = this.getInstance();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                String string = reader.readName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.readName()");
                map.put(this.decode(string), this.codec.decode(reader, context));
            }
            reader.readEndDocument();
            return map;
        }

        @NotNull
        public Class<Map<K, T>> getEncoderClass() {
            return this.mapEncoderClass;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/bson/codecs/pojo/KeyObjectMapPropertyCodecProvider$LocaleMapCodec;", "T", "Lorg/bson/codecs/pojo/KeyObjectMapPropertyCodecProvider$KeyObjectMapCodec;", "Ljava/util/Locale;", "mapEncoderClass", "Ljava/lang/Class;", "", "codec", "Lorg/bson/codecs/Codec;", "(Ljava/lang/Class;Lorg/bson/codecs/Codec;)V", "decode", "key", "", "encode", "kmongo-native-mapping"})
    public static final class LocaleMapCodec<T>
    extends KeyObjectMapCodec<Locale, T> {
        public LocaleMapCodec(@NotNull Class<Map<Locale, T>> mapEncoderClass, @NotNull Codec<T> codec) {
            Intrinsics.checkNotNullParameter(mapEncoderClass, (String)"mapEncoderClass");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            super(mapEncoderClass, codec);
        }

        @Override
        @NotNull
        public String encode(@NotNull Locale key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = key.toLanguageTag();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.toLanguageTag()");
            return string;
        }

        @Override
        @NotNull
        public Locale decode(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Locale locale = Locale.forLanguageTag(key);
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(key)");
            return locale;
        }
    }
}

