/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.ser.std.UUIDSerializer;
import de.undercouch.bson4jackson.BsonGenerator;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.types.Decimal128;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.bson.BsonBinarySubType;
import org.bson.BsonTimestamp;
import org.bson.UuidRepresentation;
import org.bson.internal.UuidHelper;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.ProjectionsKt;
import org.litote.kmongo.id.IdTransformer;
import org.litote.kmongo.id.StringId;
import org.litote.kmongo.id.WrappedObjectId;
import org.litote.kmongo.id.jackson.IdKeyDeserializer;
import org.litote.kmongo.id.jackson.IdKeySerializer;
import org.litote.kmongo.jackson.ExtendedJsonModule;
import org.litote.kmongo.jackson.KMongoAnnotationIntrospector;
import org.litote.kmongo.jackson.KMongoBsonFactory;
import org.litote.kmongo.jackson.StringDeserializationProblemHandler;
import org.litote.kmongo.util.KotlinxDatetimeLoader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b6\b\u0000\u0018\u00002\u00020\u0001:5\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006?"}, d2={"Lorg/litote/kmongo/jackson/BsonModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "uuidRepresentation", "Lorg/bson/UuidRepresentation;", "<init>", "(Lorg/bson/UuidRepresentation;)V", "setupModule", "", "context", "Lcom/fasterxml/jackson/databind/Module$SetupContext;", "KMongoObjectId", "BsonObjectIdDeserializer", "ObjectIdBsonSerializer", "ObjectIdBsonDeserializer", "BsonTimestampBsonSerializer", "BsonTimestampBsonDeserializer", "BinaryBsonSerializer", "BinaryBsonDeserializer", "MaxKeyBsonSerializer", "MaxKeyBsonDeserializer", "MinKeyBsonSerializer", "MinKeyBsonDeserializer", "TemporalBsonSerializer", "CalendarBsonSerializer", "ZonedDateTimeBsonSerializer", "OffsetDateTimeBsonSerializer", "LocalDateBsonSerializer", "LocalTimeBsonSerializer", "OffsetTimeBsonSerializer", "InstantBsonSerializer", "LocalDateTimeBsonSerializer", "KTXInstantBsonSerializer", "KTXLocalDateBsonSerializer", "KTXLocalDateTimeBsonSerializer", "KTXLocalTimeBsonSerializer", "TemporalBsonDeserializer", "CalendarBsonDeserializer", "ZonedDateTimeBsonDeserializer", "OffsetDateTimeBsonDeserializer", "LocalDateTimeBsonDeserializer", "LocalDateBsonDeserializer", "LocalTimeBsonDeserializer", "OffsetTimeBsonDeserializer", "InstantBsonDeserializer", "KTXInstantBsonDeserializer", "KTXLocalDateBsonDeserializer", "KTXLocalDateTimeBsonDeserializer", "KTXLocalTimeBsonDeserializer", "IdBsonSerializer", "IdBsonDeserializer", "StringIdBsonDeserializer", "WrappedObjectIdBsonDeserializer", "AbstractIdBsonDeserializer", "BigDecimalBsonSerializer", "BigDecimalBsonDeserializer", "Decimal128BsonSerializer", "Decimal128BsonDeserializer", "KPropertySerializer", "ZoneIdBsonSerializer", "ZoneIdBsonDeserializer", "BsonDateDeserializer", "UuidSerializer", "UuidDeserializer", "kmongo-jackson-mapping"})
public final class BsonModule
extends SimpleModule {
    public BsonModule(@Nullable UuidRepresentation uuidRepresentation) {
        this.addSerializer(ObjectId.class, ObjectIdBsonSerializer.INSTANCE);
        this.addDeserializer(ObjectId.class, ObjectIdBsonDeserializer.INSTANCE);
        this.addDeserializer(de.undercouch.bson4jackson.types.ObjectId.class, BsonObjectIdDeserializer.INSTANCE);
        this.addSerializer(Binary.class, BinaryBsonSerializer.INSTANCE);
        this.addDeserializer(Binary.class, BinaryBsonDeserializer.INSTANCE);
        this.addSerializer(BsonTimestamp.class, BsonTimestampBsonSerializer.INSTANCE);
        this.addDeserializer(BsonTimestamp.class, BsonTimestampBsonDeserializer.INSTANCE);
        this.addSerializer(MaxKey.class, MaxKeyBsonSerializer.INSTANCE);
        this.addDeserializer(MaxKey.class, MaxKeyBsonDeserializer.INSTANCE);
        this.addSerializer(MinKey.class, MinKeyBsonSerializer.INSTANCE);
        this.addDeserializer(MinKey.class, MinKeyBsonDeserializer.INSTANCE);
        this.addSerializer(BigDecimal.class, BigDecimalBsonSerializer.INSTANCE);
        this.addDeserializer(BigDecimal.class, BigDecimalBsonDeserializer.INSTANCE);
        this.addSerializer(Decimal128.class, Decimal128BsonSerializer.INSTANCE);
        this.addDeserializer(Decimal128.class, Decimal128BsonDeserializer.INSTANCE);
        this.addSerializer(Id.class, IdBsonSerializer.INSTANCE);
        this.addDeserializer(Id.class, IdBsonDeserializer.INSTANCE);
        this.addKeySerializer(Id.class, (JsonSerializer)new IdKeySerializer());
        this.addKeyDeserializer(Id.class, (KeyDeserializer)new IdKeyDeserializer(null, 1, null));
        this.addDeserializer(StringId.class, StringIdBsonDeserializer.INSTANCE);
        this.addKeyDeserializer(StringId.class, (KeyDeserializer)new IdKeyDeserializer(null, 1, null));
        this.addDeserializer(WrappedObjectId.class, WrappedObjectIdBsonDeserializer.INSTANCE);
        this.addKeyDeserializer(WrappedObjectId.class, (KeyDeserializer)new IdKeyDeserializer(null, 1, null));
        this.addSerializer(Instant.class, InstantBsonSerializer.INSTANCE);
        this.addSerializer(ZonedDateTime.class, ZonedDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, OffsetDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(LocalDate.class, LocalDateBsonSerializer.INSTANCE);
        this.addSerializer(java.time.LocalDateTime.class, LocalDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(java.time.LocalTime.class, LocalTimeBsonSerializer.INSTANCE);
        this.addSerializer(OffsetTime.class, OffsetTimeBsonSerializer.INSTANCE);
        this.addSerializer(Calendar.class, CalendarBsonSerializer.INSTANCE);
        this.addDeserializer(Instant.class, InstantBsonDeserializer.INSTANCE);
        this.addDeserializer(ZonedDateTime.class, ZonedDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(OffsetDateTime.class, OffsetDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(LocalDate.class, LocalDateBsonDeserializer.INSTANCE);
        this.addDeserializer(java.time.LocalDateTime.class, LocalDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(java.time.LocalTime.class, LocalTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(OffsetTime.class, OffsetTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(Calendar.class, CalendarBsonDeserializer.INSTANCE);
        this.addSerializer(ZoneId.class, ZoneIdBsonSerializer.INSTANCE);
        this.addDeserializer(ZoneId.class, ZoneIdBsonDeserializer.INSTANCE);
        this.addDeserializer(Date.class, BsonDateDeserializer.INSTANCE);
        this.addSerializer(KProperty.class, KPropertySerializer.INSTANCE);
        KotlinxDatetimeLoader.INSTANCE.loadKotlinxDateTime(() -> BsonModule._init_$lambda$0(this), BsonModule::_init_$lambda$1);
        if (uuidRepresentation != null) {
            this.addSerializer(UUID.class, new UuidSerializer(uuidRepresentation));
            this.addDeserializer(UUID.class, new UuidDeserializer(uuidRepresentation));
        }
    }

    public /* synthetic */ BsonModule(UuidRepresentation uuidRepresentation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uuidRepresentation = null;
        }
        this(uuidRepresentation);
    }

    public void setupModule(@NotNull Module.SetupContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.setupModule(context);
        context.appendAnnotationIntrospector((AnnotationIntrospector)KMongoAnnotationIntrospector.Companion.getINTROSPECTOR());
    }

    private static final Object _init_$lambda$0(BsonModule this$0) {
        this$0.addSerializer(kotlinx.datetime.Instant.class, KTXInstantBsonSerializer.INSTANCE);
        this$0.addSerializer(kotlinx.datetime.LocalDate.class, KTXLocalDateBsonSerializer.INSTANCE);
        this$0.addSerializer(LocalDateTime.class, KTXLocalDateTimeBsonSerializer.INSTANCE);
        this$0.addSerializer(LocalTime.class, KTXLocalTimeBsonSerializer.INSTANCE);
        this$0.addDeserializer(kotlinx.datetime.Instant.class, KTXInstantBsonDeserializer.INSTANCE);
        this$0.addDeserializer(kotlinx.datetime.LocalDate.class, KTXLocalDateBsonDeserializer.INSTANCE);
        this$0.addDeserializer(LocalDateTime.class, KTXLocalDateTimeBsonDeserializer.INSTANCE);
        return this$0.addDeserializer(LocalTime.class, KTXLocalTimeBsonDeserializer.INSTANCE);
    }

    private static final Unit _init_$lambda$1() {
        return Unit.INSTANCE;
    }

    public BsonModule() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "T", "Lorg/litote/kmongo/Id;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "targetClass", "Lkotlin/reflect/KClass;", "", "<init>", "(Lkotlin/reflect/KClass;)V", "getTargetClass", "()Lkotlin/reflect/KClass;", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Lorg/litote/kmongo/Id;", "kmongo-jackson-mapping"})
    @SourceDebugExtension(value={"SMAP\nBsonModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BsonModule.kt\norg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,659:1\n1#2:660\n*E\n"})
    private static abstract class AbstractIdBsonDeserializer<T extends Id<?>>
    extends JsonDeserializer<T> {
        @NotNull
        private final KClass<? extends Object> targetClass;

        public AbstractIdBsonDeserializer(@NotNull KClass<? extends Object> targetClass) {
            Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
            this.targetClass = targetClass;
        }

        @NotNull
        public final KClass<? extends Object> getTargetClass() {
            return this.targetClass;
        }

        @NotNull
        public T deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Id id;
            block5: {
                Object object;
                block7: {
                    Object it;
                    block6: {
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
                            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
                            if (jp.getCurrentToken() != JsonToken.VALUE_STRING) break block4;
                            String string = jp.getValueAsString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueAsString(...)");
                            Id id2 = IdTransformer.INSTANCE.wrapId((Object)string);
                            id = id2;
                            Intrinsics.checkNotNull((Object)id2, (String)"null cannot be cast to non-null type T of org.litote.kmongo.jackson.BsonModule.AbstractIdBsonDeserializer");
                            break block5;
                        }
                        object = jp.getEmbeddedObject();
                        if (object == null) break block6;
                        it = object;
                        boolean bl = false;
                        Id id3 = IdTransformer.INSTANCE.wrapId(it);
                        object = id3;
                        if (id3 != null) break block7;
                    }
                    Class clazz = JvmClassMappingKt.getJavaClass(this.targetClass);
                    JsonToken jsonToken = jp.getCurrentToken();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonToken, (String)"getCurrentToken(...)");
                    it = StringDeserializationProblemHandler.INSTANCE.handleUnexpectedToken(ctxt, clazz, jsonToken, jp, "");
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)DeserializationProblemHandler.NOT_HANDLED)) {
                        throw new IllegalStateException("not valid object found when trying to deserialize Id".toString());
                    }
                    object = it;
                }
                Object object2 = object;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type T of org.litote.kmongo.jackson.BsonModule.AbstractIdBsonDeserializer");
                id = (Id)object2;
            }
            return (T)id;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BigDecimalBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/math/BigDecimal;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BigDecimalBsonDeserializer
    extends JsonDeserializer<BigDecimal> {
        @NotNull
        public static final BigDecimalBsonDeserializer INSTANCE = new BigDecimalBsonDeserializer();

        private BigDecimalBsonDeserializer() {
        }

        @NotNull
        public BigDecimal deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            BigDecimal bigDecimal;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            if (jp.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
                bigDecimal = new BigDecimal(String.valueOf(jp.getDoubleValue()));
            } else {
                Object v = jp.getEmbeddedObject();
                if (v instanceof Integer) {
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)v).intValue());
                    bigDecimal = bigDecimal2;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
                } else if (v instanceof Long) {
                    BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)v).longValue());
                    bigDecimal = bigDecimal3;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
                } else if (v instanceof Float) {
                    bigDecimal = new BigDecimal(String.valueOf(((Number)v).floatValue()));
                } else if (v instanceof Double) {
                    bigDecimal = new BigDecimal(String.valueOf(((Number)v).doubleValue()));
                } else if (v instanceof Decimal128) {
                    BigDecimal bigDecimal4 = ((Decimal128)v).bigDecimalValue();
                    bigDecimal = bigDecimal4;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"bigDecimalValue(...)");
                } else if (v instanceof String) {
                    bigDecimal = new BigDecimal((String)v);
                } else {
                    throw new ClassCastException(v.getClass().getName() + " cannot be cast to " + BigDecimal.class.getName() + ": " + v);
                }
            }
            return bigDecimal;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BigDecimalBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/math/BigDecimal;", "<init>", "()V", "serialize", "", "decimal", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BigDecimalBsonSerializer
    extends JsonSerializer<BigDecimal> {
        @NotNull
        public static final BigDecimalBsonSerializer INSTANCE = new BigDecimalBsonSerializer();

        private BigDecimalBsonSerializer() {
        }

        public void serialize(@NotNull BigDecimal decimal, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)decimal, (String)"decimal");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            generator.writeNumber(decimal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BinaryBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/Binary;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BinaryBsonDeserializer
    extends JsonDeserializer<Binary> {
        @NotNull
        public static final BinaryBsonDeserializer INSTANCE = new BinaryBsonDeserializer();

        private BinaryBsonDeserializer() {
        }

        @NotNull
        public Binary deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode treeNode = tree.get("$binary");
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                byte[] binary = Base64Variants.MIME_NO_LINEFEEDS.decode(((ValueNode)treeNode).asText());
                TreeNode treeNode2 = tree.get("$type");
                Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                String string = ((ValueNode)treeNode2).asText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                byte type = (byte)Integer.valueOf(string2, 16).intValue();
                return new Binary(type, binary);
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.Binary");
                return (Binary)object;
            }
            if (tree instanceof BinaryNode) {
                return new Binary(((BinaryNode)tree).binaryValue());
            }
            Object object = ctxt.handleUnexpectedToken(ObjectId.class, jp);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.Binary");
            return (Binary)object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BinaryBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/Binary;", "<init>", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BinaryBsonSerializer
    extends JsonSerializer<Binary> {
        @NotNull
        public static final BinaryBsonSerializer INSTANCE = new BinaryBsonSerializer();

        private BinaryBsonSerializer() {
        }

        public void serialize(@NotNull Binary obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeBinary(obj);
            } else {
                ExtendedJsonModule.BinaryExtendedJsonSerializer.INSTANCE.serialize(obj, gen, serializerProvider);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonDateDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/util/Date;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    @SourceDebugExtension(value={"SMAP\nBsonModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BsonModule.kt\norg/litote/kmongo/jackson/BsonModule$BsonDateDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,659:1\n1#2:660\n*E\n"})
    private static final class BsonDateDeserializer
    extends JsonDeserializer<Date> {
        @NotNull
        public static final BsonDateDeserializer INSTANCE = new BsonDateDeserializer();

        private BsonDateDeserializer() {
        }

        @NotNull
        public Date deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Date date;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            if (jp instanceof BsonParser) {
                if (((BsonParser)jp).getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || ((BsonParser)jp).getCurrentBsonType() != 9) {
                    Object object = ctxt.handleUnexpectedToken(Date.class, jp);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Throwable");
                    throw (Throwable)object;
                }
                Object object = ((BsonParser)jp).getEmbeddedObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Date");
                return (Date)object;
            }
            Object object = jp.getEmbeddedObject();
            if (object != null) {
                Object it = object;
                boolean bl = false;
                date = (Date)it;
            } else {
                date = new Date(jp.getLongValue());
            }
            return date;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonObjectIdDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lde/undercouch/bson4jackson/types/ObjectId;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BsonObjectIdDeserializer
    extends JsonDeserializer<de.undercouch.bson4jackson.types.ObjectId> {
        @NotNull
        public static final BsonObjectIdDeserializer INSTANCE = new BsonObjectIdDeserializer();

        private BsonObjectIdDeserializer() {
        }

        @NotNull
        public de.undercouch.bson4jackson.types.ObjectId deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            if (jp instanceof BsonParser) {
                if (((BsonParser)jp).getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || ((BsonParser)jp).getCurrentBsonType() != 7) {
                    throw ctxt.instantiationException(de.undercouch.bson4jackson.types.ObjectId.class, "not object id");
                }
                Object object = ((BsonParser)jp).getEmbeddedObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.undercouch.bson4jackson.types.ObjectId");
                return (de.undercouch.bson4jackson.types.ObjectId)object;
            }
            TreeNode tree = jp.getCodec().readTree(jp);
            TreeNode treeNode = tree.get("$time");
            Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            int time = ((ValueNode)treeNode).asInt();
            TreeNode treeNode2 = tree.get("$machine");
            Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            int machine = ((ValueNode)treeNode2).asInt();
            TreeNode treeNode3 = tree.get("$inc");
            Intrinsics.checkNotNull((Object)treeNode3, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            int inc = ((ValueNode)treeNode3).asInt();
            return new KMongoObjectId(time, machine, inc);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonTimestampBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/BsonTimestamp;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BsonTimestampBsonDeserializer
    extends JsonDeserializer<BsonTimestamp> {
        @NotNull
        public static final BsonTimestampBsonDeserializer INSTANCE = new BsonTimestampBsonDeserializer();

        private BsonTimestampBsonDeserializer() {
        }

        @NotNull
        public BsonTimestamp deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode timestamp = tree.get("$timestamp");
                TreeNode treeNode = timestamp.get("t");
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                int time = ((ValueNode)treeNode).asInt();
                TreeNode treeNode2 = timestamp.get("i");
                Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                int inc = ((ValueNode)treeNode2).asInt();
                return new BsonTimestamp(time, inc);
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.BsonTimestamp");
                return (BsonTimestamp)object;
            }
            Object object = ctxt.handleUnexpectedToken(BsonTimestamp.class, jp);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.BsonTimestamp");
            return (BsonTimestamp)object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$BsonTimestampBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/BsonTimestamp;", "<init>", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BsonTimestampBsonSerializer
    extends JsonSerializer<BsonTimestamp> {
        @NotNull
        public static final BsonTimestampBsonSerializer INSTANCE = new BsonTimestampBsonSerializer();

        private BsonTimestampBsonSerializer() {
        }

        public void serialize(@NotNull BsonTimestamp obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeBsonTimestamp(obj);
            } else {
                ExtendedJsonModule.BsonTimestampExtendedJsonSerializer.INSTANCE.serialize(obj, gen, serializerProvider);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$CalendarBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/util/Calendar;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class CalendarBsonDeserializer
    extends TemporalBsonDeserializer<Calendar> {
        @NotNull
        public static final CalendarBsonDeserializer INSTANCE = new CalendarBsonDeserializer();

        private CalendarBsonDeserializer() {
        }

        @Override
        @NotNull
        public Calendar toObject(@NotNull Date date) {
            Calendar calendar;
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Calendar $this$toObject_u24lambda_u240 = calendar = Calendar.getInstance(java.util.TimeZone.getTimeZone("UTC"));
            boolean bl = false;
            $this$toObject_u24lambda_u240.setTime(date);
            Calendar calendar2 = calendar;
            Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"apply(...)");
            return calendar2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$CalendarBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/util/Calendar;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class CalendarBsonSerializer
    extends TemporalBsonSerializer<Calendar> {
        @NotNull
        public static final CalendarBsonSerializer INSTANCE = new CalendarBsonSerializer();

        private CalendarBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Calendar temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.CalendarExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$Decimal128BsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lde/undercouch/bson4jackson/types/Decimal128;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class Decimal128BsonDeserializer
    extends JsonDeserializer<Decimal128> {
        @NotNull
        public static final Decimal128BsonDeserializer INSTANCE = new Decimal128BsonDeserializer();

        private Decimal128BsonDeserializer() {
        }

        @NotNull
        public Decimal128 deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            return new Decimal128(BigDecimalBsonDeserializer.INSTANCE.deserialize(jp, ctxt));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$Decimal128BsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lde/undercouch/bson4jackson/types/Decimal128;", "<init>", "()V", "serialize", "", "decimal", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class Decimal128BsonSerializer
    extends JsonSerializer<Decimal128> {
        @NotNull
        public static final Decimal128BsonSerializer INSTANCE = new Decimal128BsonSerializer();

        private Decimal128BsonSerializer() {
        }

        public void serialize(@NotNull Decimal128 decimal, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)decimal, (String)"decimal");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            BigDecimal bigDecimal = decimal.bigDecimalValue();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"bigDecimalValue(...)");
            BigDecimalBsonSerializer.INSTANCE.serialize(bigDecimal, generator, provider);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$IdBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lorg/litote/kmongo/Id;", "<init>", "()V", "kmongo-jackson-mapping"})
    private static final class IdBsonDeserializer
    extends AbstractIdBsonDeserializer<Id<?>> {
        @NotNull
        public static final IdBsonDeserializer INSTANCE = new IdBsonDeserializer();

        private IdBsonDeserializer() {
            super((KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Id.class));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$IdBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/litote/kmongo/Id;", "<init>", "()V", "serialize", "", "id", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class IdBsonSerializer
    extends JsonSerializer<Id<?>> {
        @NotNull
        public static final IdBsonSerializer INSTANCE = new IdBsonSerializer();

        private IdBsonSerializer() {
        }

        public void serialize(@NotNull Id<?> id, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Object object;
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Object it = object = IdTransformer.INSTANCE.unwrapId(id);
            boolean bl = false;
            Object object2 = it;
            if (object2 instanceof String) {
                generator.writeString((String)it);
            } else if (object2 instanceof ObjectId) {
                ObjectIdBsonSerializer.INSTANCE.serialize((ObjectId)it, generator, provider);
            } else {
                throw new IllegalStateException(("unsupported id type " + id).toString());
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$InstantBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/Instant;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class InstantBsonDeserializer
    extends TemporalBsonDeserializer<Instant> {
        @NotNull
        public static final InstantBsonDeserializer INSTANCE = new InstantBsonDeserializer();

        private InstantBsonDeserializer() {
        }

        @Override
        @NotNull
        public Instant toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            Instant instant = date.toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
            return instant;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$InstantBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/Instant;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class InstantBsonSerializer
    extends TemporalBsonSerializer<Instant> {
        @NotNull
        public static final InstantBsonSerializer INSTANCE = new InstantBsonSerializer();

        private InstantBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Instant temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.InstantExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KMongoObjectId;", "Lde/undercouch/bson4jackson/types/ObjectId;", "time", "", "machine", "inc", "<init>", "(III)V", "toString", "", "kmongo-jackson-mapping"})
    public static final class KMongoObjectId
    extends de.undercouch.bson4jackson.types.ObjectId {
        public KMongoObjectId(int time, int machine, int inc) {
            super(time, machine, inc);
        }

        @NotNull
        public String toString() {
            String string = KMongoBsonFactory.Companion.createFromLegacyFormat(this.getTime(), this.getMachine(), this.getInc()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KPropertySerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lkotlin/reflect/KProperty;", "<init>", "()V", "serialize", "", "property", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "acceptJsonFormatVisitor", "visitor", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonFormatVisitorWrapper;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "kmongo-jackson-mapping"})
    private static final class KPropertySerializer
    extends JsonSerializer<KProperty<?>> {
        @NotNull
        public static final KPropertySerializer INSTANCE = new KPropertySerializer();

        private KPropertySerializer() {
        }

        public void serialize(@NotNull KProperty<?> property, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            generator.writeString(ProjectionsKt.getProjection(property));
        }

        public void acceptJsonFormatVisitor(@NotNull JsonFormatVisitorWrapper visitor, @NotNull JavaType type) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            visitor.expectStringFormat(type);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KTXInstantBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Lkotlinx/datetime/Instant;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class KTXInstantBsonDeserializer
    extends TemporalBsonDeserializer<kotlinx.datetime.Instant> {
        @NotNull
        public static final KTXInstantBsonDeserializer INSTANCE = new KTXInstantBsonDeserializer();

        private KTXInstantBsonDeserializer() {
        }

        @Override
        @NotNull
        public kotlinx.datetime.Instant toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(date.toInstant().toEpochMilli());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KTXInstantBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Lkotlinx/datetime/Instant;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class KTXInstantBsonSerializer
    extends TemporalBsonSerializer<kotlinx.datetime.Instant> {
        @NotNull
        public static final KTXInstantBsonSerializer INSTANCE = new KTXInstantBsonSerializer();

        private KTXInstantBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.Instant temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.KTXInstantExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KTXLocalDateBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Lkotlinx/datetime/LocalDate;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class KTXLocalDateBsonDeserializer
    extends TemporalBsonDeserializer<kotlinx.datetime.LocalDate> {
        @NotNull
        public static final KTXLocalDateBsonDeserializer INSTANCE = new KTXLocalDateBsonDeserializer();

        private KTXLocalDateBsonDeserializer() {
        }

        @Override
        @NotNull
        public kotlinx.datetime.LocalDate toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(date.toInstant().toEpochMilli()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KTXLocalDateBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Lkotlinx/datetime/LocalDate;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class KTXLocalDateBsonSerializer
    extends TemporalBsonSerializer<kotlinx.datetime.LocalDate> {
        @NotNull
        public static final KTXLocalDateBsonSerializer INSTANCE = new KTXLocalDateBsonSerializer();

        private KTXLocalDateBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.LocalDate temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.KTXLocalDateExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KTXLocalDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Lkotlinx/datetime/LocalDateTime;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class KTXLocalDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<LocalDateTime> {
        @NotNull
        public static final KTXLocalDateTimeBsonDeserializer INSTANCE = new KTXLocalDateTimeBsonDeserializer();

        private KTXLocalDateTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public LocalDateTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(date.toInstant().toEpochMilli()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KTXLocalDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Lkotlinx/datetime/LocalDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class KTXLocalDateTimeBsonSerializer
    extends TemporalBsonSerializer<LocalDateTime> {
        @NotNull
        public static final KTXLocalDateTimeBsonSerializer INSTANCE = new KTXLocalDateTimeBsonSerializer();

        private KTXLocalDateTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalDateTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.KTXLocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KTXLocalTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Lkotlinx/datetime/LocalTime;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class KTXLocalTimeBsonDeserializer
    extends TemporalBsonDeserializer<LocalTime> {
        @NotNull
        public static final KTXLocalTimeBsonDeserializer INSTANCE = new KTXLocalTimeBsonDeserializer();

        private KTXLocalTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public LocalTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(date.toInstant().toEpochMilli()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getTime();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$KTXLocalTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Lkotlinx/datetime/LocalTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class KTXLocalTimeBsonSerializer
    extends TemporalBsonSerializer<LocalTime> {
        @NotNull
        public static final KTXLocalTimeBsonSerializer INSTANCE = new KTXLocalTimeBsonSerializer();

        private KTXLocalTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.KTXLocalTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalDate;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalDateBsonDeserializer
    extends TemporalBsonDeserializer<LocalDate> {
        @NotNull
        public static final LocalDateBsonDeserializer INSTANCE = new LocalDateBsonDeserializer();

        private LocalDateBsonDeserializer() {
        }

        @Override
        @NotNull
        public LocalDate toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            LocalDate localDate = LocalDateTimeBsonDeserializer.INSTANCE.toObject(date).toLocalDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
            return localDate;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalDate;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalDateBsonSerializer
    extends TemporalBsonSerializer<LocalDate> {
        @NotNull
        public static final LocalDateBsonSerializer INSTANCE = new LocalDateBsonSerializer();

        private LocalDateBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalDate temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalDateExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalDateTime;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<java.time.LocalDateTime> {
        @NotNull
        public static final LocalDateTimeBsonDeserializer INSTANCE = new LocalDateTimeBsonDeserializer();

        private LocalDateTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public java.time.LocalDateTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            java.time.LocalDateTime localDateTime = java.time.LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
            return localDateTime;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalDateTimeBsonSerializer
    extends TemporalBsonSerializer<java.time.LocalDateTime> {
        @NotNull
        public static final LocalDateTimeBsonSerializer INSTANCE = new LocalDateTimeBsonSerializer();

        private LocalDateTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull java.time.LocalDateTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalTime;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalTimeBsonDeserializer
    extends TemporalBsonDeserializer<java.time.LocalTime> {
        @NotNull
        public static final LocalTimeBsonDeserializer INSTANCE = new LocalTimeBsonDeserializer();

        private LocalTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public java.time.LocalTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            java.time.LocalTime localTime = LocalDateTimeBsonDeserializer.INSTANCE.toObject(date).toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"toLocalTime(...)");
            return localTime;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$LocalTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalTimeBsonSerializer
    extends TemporalBsonSerializer<java.time.LocalTime> {
        @NotNull
        public static final LocalTimeBsonSerializer INSTANCE = new LocalTimeBsonSerializer();

        private LocalTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull java.time.LocalTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.LocalTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MaxKeyBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/MaxKey;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class MaxKeyBsonDeserializer
    extends JsonDeserializer<MaxKey> {
        @NotNull
        public static final MaxKeyBsonDeserializer INSTANCE = new MaxKeyBsonDeserializer();

        private MaxKeyBsonDeserializer() {
        }

        @NotNull
        public MaxKey deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode treeNode = tree.get("$maxKey");
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                int value = ((ValueNode)treeNode).asInt();
                if (value == 1) {
                    return new MaxKey();
                }
                Object object = ctxt.handleUnexpectedToken(MaxKey.class, jp);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.MaxKey");
                return (MaxKey)object;
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.MaxKey");
                return (MaxKey)object;
            }
            if (tree instanceof TextNode) {
                return new MaxKey();
            }
            Object object = ctxt.handleUnexpectedToken(MaxKey.class, jp);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.MaxKey");
            return (MaxKey)object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MaxKeyBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MaxKey;", "<init>", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class MaxKeyBsonSerializer
    extends JsonSerializer<MaxKey> {
        @NotNull
        public static final MaxKeyBsonSerializer INSTANCE = new MaxKeyBsonSerializer();

        private MaxKeyBsonSerializer() {
        }

        public void serialize(@NotNull MaxKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            if (jsonGenerator instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)jsonGenerator).writeMaxKey();
            } else {
                ExtendedJsonModule.MaxKeyExtendedJsonSerializer.INSTANCE.serialize(obj, jsonGenerator, serializerProvider);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MinKeyBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/MinKey;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class MinKeyBsonDeserializer
    extends JsonDeserializer<MinKey> {
        @NotNull
        public static final MinKeyBsonDeserializer INSTANCE = new MinKeyBsonDeserializer();

        private MinKeyBsonDeserializer() {
        }

        @NotNull
        public MinKey deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode treeNode = tree.get("$minKey");
                Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                int value = ((ValueNode)treeNode).asInt();
                if (value == 1) {
                    return new MinKey();
                }
                Object object = ctxt.handleUnexpectedToken(MinKey.class, jp);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.MinKey");
                return (MinKey)object;
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.MinKey");
                return (MinKey)object;
            }
            if (tree instanceof TextNode) {
                return new MinKey();
            }
            Object object = ctxt.handleUnexpectedToken(MinKey.class, jp);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.MinKey");
            return (MinKey)object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$MinKeyBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MinKey;", "<init>", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class MinKeyBsonSerializer
    extends JsonSerializer<MinKey> {
        @NotNull
        public static final MinKeyBsonSerializer INSTANCE = new MinKeyBsonSerializer();

        private MinKeyBsonSerializer() {
        }

        public void serialize(@NotNull MinKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            if (jsonGenerator instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)jsonGenerator).writeMinKey();
            } else {
                ExtendedJsonModule.MinKeyExtendedJsonSerializer.INSTANCE.serialize(obj, jsonGenerator, serializerProvider);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ObjectIdBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lorg/bson/types/ObjectId;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class ObjectIdBsonDeserializer
    extends JsonDeserializer<ObjectId> {
        @NotNull
        public static final ObjectIdBsonDeserializer INSTANCE = new ObjectIdBsonDeserializer();

        private ObjectIdBsonDeserializer() {
        }

        @NotNull
        public ObjectId deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            ObjectId objectId;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            if (p instanceof BsonParser) {
                Object object = ((BsonParser)p).getEmbeddedObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.ObjectId");
                objectId = (ObjectId)object;
            } else {
                TreeNode treeNode = p.getCodec().readTree(p);
                Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
                TreeNode tree = treeNode;
                if (tree instanceof POJONode) {
                    Object object = ((POJONode)tree).getPojo();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bson.types.ObjectId");
                    objectId = (ObjectId)object;
                } else {
                    TreeNode treeNode2 = tree.get("$oid");
                    Intrinsics.checkNotNull((Object)treeNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.JsonNode");
                    objectId = new ObjectId(((JsonNode)treeNode2).textValue());
                }
            }
            return objectId;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ObjectIdBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/ObjectId;", "<init>", "()V", "serialize", "", "objectId", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class ObjectIdBsonSerializer
    extends JsonSerializer<ObjectId> {
        @NotNull
        public static final ObjectIdBsonSerializer INSTANCE = new ObjectIdBsonSerializer();

        private ObjectIdBsonSerializer() {
        }

        public void serialize(@NotNull ObjectId objectId, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeObjectId(objectId);
            } else {
                ExtendedJsonModule.ObjectIdExtendedJsonSerializer.INSTANCE.serialize(objectId, gen, serializerProvider);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/OffsetDateTime;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class OffsetDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<OffsetDateTime> {
        @NotNull
        public static final OffsetDateTimeBsonDeserializer INSTANCE = new OffsetDateTimeBsonDeserializer();

        private OffsetDateTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public OffsetDateTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"ofInstant(...)");
            return offsetDateTime;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/OffsetDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class OffsetDateTimeBsonSerializer
    extends TemporalBsonSerializer<OffsetDateTime> {
        @NotNull
        public static final OffsetDateTimeBsonSerializer INSTANCE = new OffsetDateTimeBsonSerializer();

        private OffsetDateTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull OffsetDateTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.OffsetDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/OffsetTime;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class OffsetTimeBsonDeserializer
    extends TemporalBsonDeserializer<OffsetTime> {
        @NotNull
        public static final OffsetTimeBsonDeserializer INSTANCE = new OffsetTimeBsonDeserializer();

        private OffsetTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public OffsetTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            OffsetTime offsetTime = OffsetDateTimeBsonDeserializer.INSTANCE.toObject(date).toOffsetTime();
            Intrinsics.checkNotNullExpressionValue((Object)offsetTime, (String)"toOffsetTime(...)");
            return offsetTime;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$OffsetTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/OffsetTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class OffsetTimeBsonSerializer
    extends TemporalBsonSerializer<OffsetTime> {
        @NotNull
        public static final OffsetTimeBsonSerializer INSTANCE = new OffsetTimeBsonSerializer();

        private OffsetTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull OffsetTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.OffsetTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$StringIdBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lorg/litote/kmongo/id/StringId;", "<init>", "()V", "kmongo-jackson-mapping"})
    private static final class StringIdBsonDeserializer
    extends AbstractIdBsonDeserializer<StringId<?>> {
        @NotNull
        public static final StringIdBsonDeserializer INSTANCE = new StringIdBsonDeserializer();

        private StringIdBsonDeserializer() {
            super((KClass<? extends Object>)Reflection.getOrCreateKotlinClass(String.class));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "T", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Ljava/lang/Object;", "toObject", "date", "Ljava/util/Date;", "(Ljava/util/Date;)Ljava/lang/Object;", "kmongo-jackson-mapping"})
    private static abstract class TemporalBsonDeserializer<T>
    extends JsonDeserializer<T> {
        /*
         * WARNING - void declaration
         */
        public T deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            void $this$deserialize_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Object object = jp.getEmbeddedObject();
            TemporalBsonDeserializer temporalBsonDeserializer = this;
            boolean bl = false;
            return temporalBsonDeserializer.toObject($this$deserialize_u24lambda_u240 == null ? new Date(jp.getLongValue()) : (Date)$this$deserialize_u24lambda_u240);
        }

        public abstract T toObject(@NotNull Date var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "T", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "date", "Ljava/util/Date;", "temporal", "(Ljava/lang/Object;)Ljava/util/Date;", "epochMillis", "", "(Ljava/lang/Object;)J", "kmongo-jackson-mapping"})
    private static abstract class TemporalBsonSerializer<T>
    extends JsonSerializer<T> {
        public void serialize(T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeDateTime(this.date(value));
            } else {
                ExtendedJsonModule.DateExtendedJsonSerializer.INSTANCE.serialize(this.date(value), gen, serializerProvider);
            }
        }

        @NotNull
        public final Date date(T temporal) {
            return new Date(this.epochMillis(temporal));
        }

        public abstract long epochMillis(T var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$UuidDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/util/UUID;", "uuidRepresentation", "Lorg/bson/UuidRepresentation;", "<init>", "(Lorg/bson/UuidRepresentation;)V", "binaryType", "", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    public static final class UuidDeserializer
    extends JsonDeserializer<UUID> {
        @NotNull
        private final UuidRepresentation uuidRepresentation;
        private final byte binaryType;

        public UuidDeserializer(@NotNull UuidRepresentation uuidRepresentation) {
            Intrinsics.checkNotNullParameter((Object)uuidRepresentation, (String)"uuidRepresentation");
            this.uuidRepresentation = uuidRepresentation;
            this.binaryType = this.uuidRepresentation == UuidRepresentation.STANDARD ? BsonBinarySubType.UUID_STANDARD.getValue() : BsonBinarySubType.UUID_LEGACY.getValue();
        }

        @NotNull
        public UUID deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            Object object;
            byte[] bytes;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Object object2 = p.getEmbeddedObject();
            byte[] byArray = bytes = object2 instanceof byte[] ? (byte[])object2 : null;
            if (p.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && bytes != null) {
                object2 = UuidHelper.decodeBinaryToUuid((byte[])bytes, (byte)this.binaryType, (UuidRepresentation)this.uuidRepresentation);
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
            } else {
                object2 = new UUIDDeserializer().deserialize(p, ctxt);
                Intrinsics.checkNotNull((Object)object2);
                object = (UUID)object2;
            }
            return object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$UuidSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/util/UUID;", "uuidRepresentation", "Lorg/bson/UuidRepresentation;", "<init>", "(Lorg/bson/UuidRepresentation;)V", "binaryType", "", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class UuidSerializer
    extends JsonSerializer<UUID> {
        @NotNull
        private final UuidRepresentation uuidRepresentation;
        private final byte binaryType;

        public UuidSerializer(@NotNull UuidRepresentation uuidRepresentation) {
            Intrinsics.checkNotNullParameter((Object)uuidRepresentation, (String)"uuidRepresentation");
            this.uuidRepresentation = uuidRepresentation;
            this.binaryType = this.uuidRepresentation == UuidRepresentation.STANDARD ? BsonBinarySubType.UUID_STANDARD.getValue() : BsonBinarySubType.UUID_LEGACY.getValue();
        }

        public void serialize(@NotNull UUID value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            if (gen instanceof BsonGenerator) {
                ((BsonGenerator)gen).writeBinary(null, this.binaryType, UuidHelper.encodeUuidToBinary((UUID)value, (UuidRepresentation)this.uuidRepresentation), 0, 16);
            } else {
                new UUIDSerializer().serialize(value, gen, serializers);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$WrappedObjectIdBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lorg/litote/kmongo/id/WrappedObjectId;", "<init>", "()V", "kmongo-jackson-mapping"})
    private static final class WrappedObjectIdBsonDeserializer
    extends AbstractIdBsonDeserializer<WrappedObjectId<?>> {
        @NotNull
        public static final WrappedObjectIdBsonDeserializer INSTANCE = new WrappedObjectIdBsonDeserializer();

        private WrappedObjectIdBsonDeserializer() {
            super((KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Id.class));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZoneIdBsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Ljava/time/ZoneId;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class ZoneIdBsonDeserializer
    extends JsonDeserializer<ZoneId> {
        @NotNull
        public static final ZoneIdBsonDeserializer INSTANCE = new ZoneIdBsonDeserializer();

        private ZoneIdBsonDeserializer() {
        }

        @NotNull
        public ZoneId deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            ZoneId zoneId = ZoneId.of(jp.getValueAsString());
            Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
            return zoneId;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZoneIdBsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Ljava/time/ZoneId;", "<init>", "()V", "serialize", "", "obj", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class ZoneIdBsonSerializer
    extends JsonSerializer<ZoneId> {
        @NotNull
        public static final ZoneIdBsonSerializer INSTANCE = new ZoneIdBsonSerializer();

        private ZoneIdBsonSerializer() {
        }

        public void serialize(@NotNull ZoneId obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializerProvider, (String)"serializerProvider");
            gen.writeString(obj.toString());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZonedDateTimeBsonDeserializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/ZonedDateTime;", "<init>", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class ZonedDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<ZonedDateTime> {
        @NotNull
        public static final ZonedDateTimeBsonDeserializer INSTANCE = new ZonedDateTimeBsonDeserializer();

        private ZonedDateTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public ZonedDateTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(...)");
            return zonedDateTime;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/BsonModule$ZonedDateTimeBsonSerializer;", "Lorg/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/ZonedDateTime;", "<init>", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class ZonedDateTimeBsonSerializer
    extends TemporalBsonSerializer<ZonedDateTime> {
        @NotNull
        public static final ZonedDateTimeBsonSerializer INSTANCE = new ZonedDateTimeBsonSerializer();

        private ZonedDateTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull ZonedDateTime temporal) {
            Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
            return ExtendedJsonModule.ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }
}

