/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BsonTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import org.litote.kmongo.id.IdTransformer;
import org.litote.kmongo.jackson.KMongoAnnotationIntrospector;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u0001:\u0010\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "()V", "setupModule", "", "context", "Lcom/fasterxml/jackson/databind/Module$SetupContext;", "BinaryExtendedJsonSerializer", "BsonTimestampExtendedJsonSerializer", "CalendarExtendedJsonSerializer", "DateExtendedJsonSerializer", "IdSerializer", "InstantExtendedJsonSerializer", "LocalDateExtendedJsonSerializer", "LocalDateTimeExtendedJsonSerializer", "LocalTimeExtendedJsonSerializer", "MaxKeyExtendedJsonSerializer", "MinKeyExtendedJsonSerializer", "ObjectIdExtendedJsonSerializer", "OffsetDateTimeExtendedJsonSerializer", "OffsetTimeExtendedJsonSerializer", "TemporalExtendedJsonSerializer", "ZonedDateTimeExtendedJsonSerializer", "kmongo-jackson-mapping"})
public final class ExtendedJsonModule
extends SimpleModule {
    public void setupModule(@NotNull Module.SetupContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super.setupModule(context);
        context.appendAnnotationIntrospector((AnnotationIntrospector)KMongoAnnotationIntrospector.Companion.getINTROSPECTOR());
    }

    public ExtendedJsonModule() {
        this.addSerializer(ObjectId.class, ObjectIdExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Binary.class, BinaryExtendedJsonSerializer.INSTANCE);
        this.addSerializer(BsonTimestamp.class, BsonTimestampExtendedJsonSerializer.INSTANCE);
        this.addSerializer(MaxKey.class, MaxKeyExtendedJsonSerializer.INSTANCE);
        this.addSerializer(MinKey.class, MinKeyExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Id.class, IdSerializer.INSTANCE);
        this.addSerializer(Date.class, DateExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Calendar.class, CalendarExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Instant.class, InstantExtendedJsonSerializer.INSTANCE);
        this.addSerializer(ZonedDateTime.class, ZonedDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, OffsetDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(LocalDate.class, LocalDateExtendedJsonSerializer.INSTANCE);
        this.addSerializer(LocalDateTime.class, LocalDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(LocalTime.class, LocalTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(OffsetTime.class, OffsetTimeExtendedJsonSerializer.INSTANCE);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$ObjectIdExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/ObjectId;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class ObjectIdExtendedJsonSerializer
    extends JsonSerializer<ObjectId> {
        public static final ObjectIdExtendedJsonSerializer INSTANCE;

        public void serialize(@NotNull ObjectId value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializers, (String)"serializers");
            gen.writeStartObject();
            gen.writeStringField("$oid", value.toHexString());
            gen.writeEndObject();
        }

        private ObjectIdExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new ObjectIdExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$BinaryExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/Binary;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class BinaryExtendedJsonSerializer
    extends JsonSerializer<Binary> {
        public static final BinaryExtendedJsonSerializer INSTANCE;

        public void serialize(@NotNull Binary obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeBinaryField("$binary", obj.getData());
            String string = Integer.toHexString(obj.getType());
            String string2 = "$type";
            JsonGenerator jsonGenerator2 = jsonGenerator;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
            String string5 = string4;
            jsonGenerator2.writeStringField(string2, string5);
            jsonGenerator.writeEndObject();
        }

        private BinaryExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new BinaryExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$BsonTimestampExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/BsonTimestamp;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class BsonTimestampExtendedJsonSerializer
    extends JsonSerializer<BsonTimestamp> {
        public static final BsonTimestampExtendedJsonSerializer INSTANCE;

        public void serialize(@NotNull BsonTimestamp obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("$timestamp");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("t", obj.getTime());
            jsonGenerator.writeNumberField("i", obj.getInc());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }

        private BsonTimestampExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new BsonTimestampExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$MaxKeyExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MaxKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class MaxKeyExtendedJsonSerializer
    extends JsonSerializer<MaxKey> {
        public static final MaxKeyExtendedJsonSerializer INSTANCE;

        public void serialize(@NotNull MaxKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("$maxKey", 1);
            jsonGenerator.writeEndObject();
        }

        private MaxKeyExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new MaxKeyExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$MinKeyExtendedJsonSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/bson/types/MinKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class MinKeyExtendedJsonSerializer
    extends JsonSerializer<MinKey> {
        public static final MinKeyExtendedJsonSerializer INSTANCE;

        public void serialize(@NotNull MinKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            Intrinsics.checkParameterIsNotNull((Object)jsonGenerator, (String)"jsonGenerator");
            Intrinsics.checkParameterIsNotNull((Object)serializerProvider, (String)"serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("$minKey", 1);
            jsonGenerator.writeEndObject();
        }

        private MinKeyExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new MinKeyExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0007J%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "T", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "()V", "epochMillis", "", "temporal", "(Ljava/lang/Object;)J", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "kmongo-jackson-mapping"})
    public static abstract class TemporalExtendedJsonSerializer<T>
    extends JsonSerializer<T> {
        public void serialize(T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
            Intrinsics.checkParameterIsNotNull((Object)serializers, (String)"serializers");
            gen.writeStartObject();
            gen.writeNumberField("$date", this.epochMillis(value));
            gen.writeEndObject();
        }

        public abstract long epochMillis(T var1);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$DateExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/util/Date;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class DateExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<Date> {
        public static final DateExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull Date temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return temporal.getTime();
        }

        private DateExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new DateExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$CalendarExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/util/Calendar;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class CalendarExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<Calendar> {
        public static final CalendarExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull Calendar temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return temporal.getTimeInMillis();
        }

        private CalendarExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new CalendarExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$InstantExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/Instant;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class InstantExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<Instant> {
        public static final InstantExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull Instant temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            return temporal.toEpochMilli();
        }

        private InstantExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new InstantExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$ZonedDateTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/ZonedDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class ZonedDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<ZonedDateTime> {
        public static final ZonedDateTimeExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull ZonedDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            Instant instant = temporal.toInstant();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"temporal.toInstant()");
            return InstantExtendedJsonSerializer.INSTANCE.epochMillis(instant);
        }

        private ZonedDateTimeExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new ZonedDateTimeExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$OffsetDateTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/OffsetDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class OffsetDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<OffsetDateTime> {
        public static final OffsetDateTimeExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull OffsetDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            Instant instant = temporal.toInstant();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"temporal.toInstant()");
            return InstantExtendedJsonSerializer.INSTANCE.epochMillis(instant);
        }

        private OffsetDateTimeExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new OffsetDateTimeExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$LocalDateExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalDate;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalDateExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalDate> {
        public static final LocalDateExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalDate temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            ZonedDateTime zonedDateTime = temporal.atStartOfDay(ZoneOffset.UTC);
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"temporal.atStartOfDay(UTC)");
            return ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(zonedDateTime);
        }

        private LocalDateExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new LocalDateExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$LocalDateTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalDateTime> {
        public static final LocalDateTimeExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalDateTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            ZonedDateTime zonedDateTime = temporal.atZone(ZoneOffset.UTC);
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"temporal.atZone(UTC)");
            return ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(zonedDateTime);
        }

        private LocalDateTimeExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new LocalDateTimeExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$LocalTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalTime> {
        public static final LocalTimeExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull LocalTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            LocalDateTime localDateTime = temporal.atDate(LocalDate.ofEpochDay(0L));
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"temporal.atDate(LocalDate.ofEpochDay(0))");
            return LocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(localDateTime);
        }

        private LocalTimeExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new LocalTimeExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$OffsetTimeExtendedJsonSerializer;", "Lorg/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/OffsetTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class OffsetTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<OffsetTime> {
        public static final OffsetTimeExtendedJsonSerializer INSTANCE;

        @Override
        public long epochMillis(@NotNull OffsetTime temporal) {
            Intrinsics.checkParameterIsNotNull((Object)temporal, (String)"temporal");
            OffsetDateTime offsetDateTime = temporal.atDate(LocalDate.ofEpochDay(0L));
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"temporal.atDate(LocalDate.ofEpochDay(0))");
            return OffsetDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(offsetDateTime);
        }

        private OffsetTimeExtendedJsonSerializer() {
            INSTANCE = this;
        }

        static {
            new OffsetTimeExtendedJsonSerializer();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/litote/kmongo/jackson/ExtendedJsonModule$IdSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lorg/litote/kmongo/Id;", "()V", "serialize", "", "id", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class IdSerializer
    extends JsonSerializer<Id<?>> {
        public static final IdSerializer INSTANCE;

        public void serialize(@NotNull Id<?> id, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkParameterIsNotNull(id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            generator.writeObject(IdTransformer.INSTANCE.unwrapId(id));
        }

        private IdSerializer() {
            INSTANCE = this;
        }

        static {
            new IdSerializer();
        }
    }
}

