/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.jackson.JacksonCodec$WhenMappings;
import org.litote.kmongo.util.MongoIdUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001.B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020&H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020+2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lorg/litote/kmongo/jackson/JacksonCodec;", "T", "", "Lorg/bson/codecs/Codec;", "Lorg/bson/codecs/CollectibleCodec;", "bsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "notBsonObjectMapper", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "type", "Ljava/lang/Class;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/bson/codecs/configuration/CodecRegistry;Ljava/lang/Class;)V", "getBsonObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getCodecRegistry", "()Lorg/bson/codecs/configuration/CodecRegistry;", "getNotBsonObjectMapper", "rawBsonDocumentCodec", "Lorg/bson/RawBsonDocument;", "getType", "()Ljava/lang/Class;", "decode", "reader", "Lorg/bson/BsonReader;", "decoderContext", "Lorg/bson/codecs/DecoderContext;", "(Lorg/bson/BsonReader;Lorg/bson/codecs/DecoderContext;)Ljava/lang/Object;", "documentHasId", "", "document", "(Ljava/lang/Object;)Z", "encode", "", "writer", "Lorg/bson/BsonWriter;", "value", "encoderContext", "Lorg/bson/codecs/EncoderContext;", "(Lorg/bson/BsonWriter;Ljava/lang/Object;Lorg/bson/codecs/EncoderContext;)V", "generateIdIfAbsentFromDocument", "(Ljava/lang/Object;)Ljava/lang/Object;", "getDocumentId", "Lorg/bson/BsonValue;", "(Ljava/lang/Object;)Lorg/bson/BsonValue;", "getEncoderClass", "VisitorWrapper", "kmongo-jackson-mapping"})
public final class JacksonCodec<T>
implements Codec<T>,
CollectibleCodec<T> {
    private final Codec<RawBsonDocument> rawBsonDocumentCodec;
    @NotNull
    private final ObjectMapper bsonObjectMapper;
    @NotNull
    private final ObjectMapper notBsonObjectMapper;
    @NotNull
    private final CodecRegistry codecRegistry;
    @NotNull
    private final Class<T> type;

    @Nullable
    public T decode(@NotNull BsonReader reader, @NotNull DecoderContext decoderContext) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)decoderContext, (String)"decoderContext");
        try {
            RawBsonDocument document = (RawBsonDocument)this.rawBsonDocumentCodec.decode(reader, decoderContext);
            return (T)this.bsonObjectMapper.readValue(document.getByteBuffer().array(), this.type);
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void encode(@NotNull BsonWriter writer, @Nullable T value, @NotNull EncoderContext encoderContext) {
        block13: {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            Intrinsics.checkParameterIsNotNull((Object)encoderContext, (String)"encoderContext");
            try {
                if (value == null) {
                    writer.writeNull();
                    break block13;
                }
                visitor = new VisitorWrapper();
                this.bsonObjectMapper.acceptJsonFormatVisitor(value.getClass(), (JsonFormatVisitorWrapper)visitor);
                v0 = visitor.getJsonType();
                if (v0 == null) ** GOTO lbl-1000
                block1 : switch (JacksonCodec$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: lbl-1000:
                    // 2 sources

                    {
                        bytes = this.bsonObjectMapper.writeValueAsBytes(value);
                        this.rawBsonDocumentCodec.encode(writer, (Object)new RawBsonDocument(bytes), encoderContext);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        jsonReader = new JsonReader(this.notBsonObjectMapper.writeValueAsString(value));
                        v1 = visitor.getJsonType();
                        if (v1 != null) {
                            switch (JacksonCodec$WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
                                case 1: {
                                    writer.writeDouble(jsonReader.readDouble());
                                    break block1;
                                }
                                case 2: {
                                    writer.writeInt64(jsonReader.readInt64());
                                    break block1;
                                }
                                case 3: {
                                    writer.writeBoolean(jsonReader.readBoolean());
                                    break block1;
                                }
                            }
                        }
                        writer.writeString(jsonReader.readString());
                    }
                }
            }
            catch (IOException e) {
                throw (Throwable)new UncheckedIOException(e);
            }
        }
    }

    @NotNull
    public Class<T> getEncoderClass() {
        return this.type;
    }

    @NotNull
    public BsonValue getDocumentId(@NotNull T document) {
        BsonValue idValue;
        Intrinsics.checkParameterIsNotNull(document, (String)"document");
        KProperty1<?, ?> idProperty = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document.getClass()));
        if (idProperty == null) {
            throw (Throwable)new IllegalStateException("" + this.type + " has no id field");
        }
        BsonValue bsonValue = idValue = MongoIdUtil.INSTANCE.getIdBsonValue(idProperty, document);
        if (bsonValue == null) {
            throw (Throwable)new IllegalStateException("" + this.type + " has null id");
        }
        return bsonValue;
    }

    public boolean documentHasId(@NotNull T document) {
        Intrinsics.checkParameterIsNotNull(document, (String)"document");
        return MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document.getClass())) != null;
    }

    @NotNull
    public T generateIdIfAbsentFromDocument(@NotNull T document) {
        Object idValue;
        Intrinsics.checkParameterIsNotNull(document, (String)"document");
        KProperty1<?, ?> idProperty = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document.getClass()));
        if (idProperty != null && (idValue = MongoIdUtil.INSTANCE.getIdValue(idProperty, document)) == null) {
            Field javaField;
            String toString = idProperty.getReturnType().toString();
            Field field = javaField = ReflectJvmMapping.getJavaField((KProperty)((KProperty)idProperty));
            if (field == null) {
                Intrinsics.throwNpe();
            }
            field.setAccessible(true);
            String string = Reflection.getOrCreateKotlinClass(ObjectId.class).getQualifiedName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith$default((String)toString, (String)string, (boolean)false, (int)2, null)) {
                javaField.set(document, ObjectId.get());
            } else {
                String string2 = Reflection.getOrCreateKotlinClass(String.class).getQualifiedName();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.startsWith$default((String)toString, (String)string2, (boolean)false, (int)2, null)) {
                    javaField.set(document, ObjectId.get().toString());
                } else {
                    String string3 = "generation for id property type not supported : " + idProperty;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
            }
        }
        return document;
    }

    @NotNull
    public final ObjectMapper getBsonObjectMapper() {
        return this.bsonObjectMapper;
    }

    @NotNull
    public final ObjectMapper getNotBsonObjectMapper() {
        return this.notBsonObjectMapper;
    }

    @NotNull
    public final CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @NotNull
    public final Class<T> getType() {
        return this.type;
    }

    public JacksonCodec(@NotNull ObjectMapper bsonObjectMapper, @NotNull ObjectMapper notBsonObjectMapper, @NotNull CodecRegistry codecRegistry2, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)bsonObjectMapper, (String)"bsonObjectMapper");
        Intrinsics.checkParameterIsNotNull((Object)notBsonObjectMapper, (String)"notBsonObjectMapper");
        Intrinsics.checkParameterIsNotNull((Object)codecRegistry2, (String)"codecRegistry");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        this.bsonObjectMapper = bsonObjectMapper;
        this.notBsonObjectMapper = notBsonObjectMapper;
        this.codecRegistry = codecRegistry2;
        this.type = type;
        Codec codec = this.codecRegistry.get(RawBsonDocument.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)codec, (String)"codecRegistry.get(RawBsonDocument::class.java)");
        this.rawBsonDocumentCodec = codec;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper;", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonFormatVisitorWrapper$Base;", "()V", "jsonType", "Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "getJsonType", "()Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "setJsonType", "(Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;)V", "expectArrayFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonArrayFormatVisitor;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "expectBooleanFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonBooleanFormatVisitor;", "expectIntegerFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonIntegerFormatVisitor;", "expectMapFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonMapFormatVisitor;", "expectNumberFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonNumberFormatVisitor;", "expectObjectFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;", "expectStringFormat", "Lcom/fasterxml/jackson/databind/jsonFormatVisitors/JsonStringFormatVisitor;", "JsonType", "kmongo-jackson-mapping"})
    public static final class VisitorWrapper
    extends JsonFormatVisitorWrapper.Base {
        @Nullable
        private JsonType jsonType;

        @Nullable
        public final JsonType getJsonType() {
            return this.jsonType;
        }

        public final void setJsonType(@Nullable JsonType jsonType) {
            this.jsonType = jsonType;
        }

        @Nullable
        public JsonStringFormatVisitor expectStringFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.string;
            return null;
        }

        @Nullable
        public JsonArrayFormatVisitor expectArrayFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.array;
            return null;
        }

        @Nullable
        public JsonNumberFormatVisitor expectNumberFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.number;
            return null;
        }

        @Nullable
        public JsonMapFormatVisitor expectMapFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.map;
            return null;
        }

        @Nullable
        public JsonObjectFormatVisitor expectObjectFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.object;
            return null;
        }

        @Nullable
        public JsonIntegerFormatVisitor expectIntegerFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.integer;
            return null;
        }

        @Nullable
        public JsonBooleanFormatVisitor expectBooleanFormat(@Nullable JavaType type) {
            this.jsonType = JsonType.boolean;
            return null;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "", "(Ljava/lang/String;I)V", "string", "array", "number", "map", "object", "integer", "boolean", "kmongo-jackson-mapping"})
        public static final class JsonType
        extends Enum<JsonType> {
            public static final /* enum */ JsonType string;
            public static final /* enum */ JsonType array;
            public static final /* enum */ JsonType number;
            public static final /* enum */ JsonType map;
            public static final /* enum */ JsonType object;
            public static final /* enum */ JsonType integer;
            public static final /* enum */ JsonType boolean;
            private static final /* synthetic */ JsonType[] $VALUES;

            static {
                JsonType[] jsonTypeArray = new JsonType[7];
                JsonType[] jsonTypeArray2 = jsonTypeArray;
                jsonTypeArray[0] = string = new JsonType();
                jsonTypeArray[1] = array = new JsonType();
                jsonTypeArray[2] = number = new JsonType();
                jsonTypeArray[3] = map = new JsonType();
                jsonTypeArray[4] = object = new JsonType();
                jsonTypeArray[5] = integer = new JsonType();
                jsonTypeArray[6] = boolean = new JsonType();
                $VALUES = jsonTypeArray;
            }

            public static JsonType[] values() {
                return (JsonType[])$VALUES.clone();
            }

            public static JsonType valueOf(String string) {
                return Enum.valueOf(JsonType.class, string);
            }
        }
    }
}

