/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.flow.component.Component;
import java.util.Objects;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.dispatcher.behavior.PropertyBehavior;
import org.linkki.core.binding.dispatcher.behavior.PropertyBehaviorProvider;
import org.linkki.core.binding.validation.ValidationService;
import org.linkki.core.ui.creation.VaadinUiCreator;
import org.linkki.framework.ui.dialogs.DialogBindingManager;
import org.linkki.framework.ui.dialogs.OkCancelDialog;
import org.linkki.util.handler.Handler;

public class PmoBasedDialogFactory {
    private final ValidationService validationService;
    private final PropertyBehaviorProvider propertyBehaviorProvider;

    public PmoBasedDialogFactory() {
        this(ValidationService.NOP_VALIDATION_SERVICE);
    }

    public PmoBasedDialogFactory(ValidationService validationService) {
        this(validationService, PropertyBehaviorProvider.NO_BEHAVIOR_PROVIDER);
    }

    public PmoBasedDialogFactory(PropertyBehavior ... propertyBehavior) {
        this(ValidationService.NOP_VALIDATION_SERVICE, PropertyBehaviorProvider.with((PropertyBehavior[])propertyBehavior));
    }

    public PmoBasedDialogFactory(ValidationService validationService, PropertyBehaviorProvider propertyBehaviorProvider) {
        this.validationService = Objects.requireNonNull(validationService, "validationService must not be null");
        this.propertyBehaviorProvider = Objects.requireNonNull(propertyBehaviorProvider, "propertyBehaviorProvider must not be null");
    }

    public OkCancelDialog newOkDialog(String title, Object ... pmos) {
        return this.newOkCancelDialog(title, Handler.NOP_HANDLER, Handler.NOP_HANDLER, OkCancelDialog.ButtonOption.OK_ONLY, pmos);
    }

    public OkCancelDialog newOkCancelDialog(String title, Handler okHandler, Object ... pmos) {
        return this.newOkCancelDialog(title, okHandler, Handler.NOP_HANDLER, OkCancelDialog.ButtonOption.OK_CANCEL, pmos);
    }

    public OkCancelDialog newOkCancelDialog(String title, Handler okHandler, Handler cancelHandler, Object ... pmos) {
        return this.newOkCancelDialog(title, okHandler, cancelHandler, OkCancelDialog.ButtonOption.OK_CANCEL, pmos);
    }

    OkCancelDialog newOkCancelDialog(String title, Handler okHandler, Handler cancelHandler, OkCancelDialog.ButtonOption buttonOption, Object ... pmos) {
        OkCancelDialog dialog = OkCancelDialog.builder(title).okHandler(okHandler).cancelHandler(cancelHandler).buttonOption(buttonOption).build();
        DialogBindingManager bindingManager = new DialogBindingManager(dialog, this.validationService, this.propertyBehaviorProvider);
        BindingContext bindingContext = bindingManager.getContext(((Object)((Object)dialog)).getClass());
        for (Object pmo : pmos) {
            Component content = VaadinUiCreator.createComponent((Object)pmo, (BindingContext)bindingContext);
            float expRatio = 0.0f;
            if (pmo == pmos[pmos.length - 1]) {
                expRatio = 1.0f;
            }
            dialog.addContent(content, expRatio);
        }
        bindingContext.modelChanged();
        return dialog;
    }

    public OkCancelDialog openOkDialog(String title, Object ... pmos) {
        OkCancelDialog dialog = this.newOkDialog(title, pmos);
        dialog.open();
        return dialog;
    }

    public OkCancelDialog openOkCancelDialog(String title, Handler okHandler, Object ... pmos) {
        OkCancelDialog dialog = this.newOkCancelDialog(title, okHandler, pmos);
        dialog.open();
        return dialog;
    }

    public OkCancelDialog openOkCancelDialog(String title, Handler okHandler, Handler cancelHandler, Object ... pmos) {
        OkCancelDialog dialog = this.newOkCancelDialog(title, okHandler, cancelHandler, pmos);
        dialog.open();
        return dialog;
    }
}

