/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.util.function.Supplier;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.validation.message.Severity;
import org.linkki.core.defaults.columnbased.pmo.ContainerPmo;
import org.linkki.core.ui.creation.table.GridComponentCreator;
import org.linkki.core.vaadin.component.base.LinkkiText;
import org.linkki.framework.ui.component.MessageTablePmo;

@CssImport(value="./styles/linkki-messages.css")
public final class MessageUiComponents {
    private MessageUiComponents() {
    }

    public static String getStyle(Severity severity) {
        return "linkki-message-" + severity.name().toLowerCase();
    }

    public static VaadinIcon getIcon(Severity severity) {
        switch (severity) {
            case ERROR: {
                return VaadinIcon.EXCLAMATION_CIRCLE;
            }
            case WARNING: {
                return VaadinIcon.WARNING;
            }
        }
        return VaadinIcon.INFO_CIRCLE;
    }

    public static Component createMessageComponent(Message message) {
        Severity severity = message.getSeverity();
        LinkkiText messageLabel = new LinkkiText(message.getText(), MessageUiComponents.getIcon(severity));
        messageLabel.addClassNames(new String[]{MessageUiComponents.getStyle(severity)});
        return messageLabel;
    }

    public static Component createMessageTable(Supplier<MessageList> messages, BindingContext bindingContext) {
        Grid messagesGrid = GridComponentCreator.createGrid((ContainerPmo)new MessageTablePmo(messages), (BindingContext)bindingContext);
        messagesGrid.addClassName("linkki-message-table");
        messagesGrid.setWidthFull();
        messagesGrid.setSelectionMode(Grid.SelectionMode.NONE);
        return messagesGrid;
    }

    public static Component createMessageTable(String title, Supplier<MessageList> messages, BindingContext bindingContext) {
        Component messageTable = MessageUiComponents.createMessageTable(messages, bindingContext);
        VerticalLayout content = new VerticalLayout(new Component[]{new Label(title), messageTable});
        content.setPadding(false);
        return content;
    }
}

