/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application.menu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.linkki.framework.ui.application.menu.ApplicationMenu;
import org.linkki.util.handler.Handler;

public class ApplicationMenuItemDefinition {
    private static final String APPMENU_ID_PREFIX = "appmenu";
    private static final Pattern REGEX_UNKNOWN_CHARS = Pattern.compile("[^a-z0-9]");
    private static final Pattern REGEX_WHITESPACES = Pattern.compile("\\s+");
    private final String name;
    private final String id;
    private final Handler command;
    private final List<ApplicationMenuItemDefinition> subMenuItemDefinitions;

    @Deprecated(since="2.0.0")
    public ApplicationMenuItemDefinition(String name, Handler command) {
        this(name, ApplicationMenuItemDefinition.nameToId(name), command);
    }

    public ApplicationMenuItemDefinition(String name, String id, Handler command) {
        this.name = name;
        this.id = id;
        this.command = command;
        this.subMenuItemDefinitions = Collections.emptyList();
    }

    @Deprecated(since="2.0.0")
    public ApplicationMenuItemDefinition(String name, String url) {
        this(name, () -> ApplicationMenuItemDefinition.navigateToLink(url));
    }

    public ApplicationMenuItemDefinition(String name, String id, String url) {
        this(name, id, () -> ApplicationMenuItemDefinition.navigateToLink(url));
    }

    @Deprecated(since="2.0.0")
    public ApplicationMenuItemDefinition(String name, Class<? extends Component> navigationTarget) {
        this(name, () -> UI.getCurrent().navigate(navigationTarget));
    }

    public ApplicationMenuItemDefinition(String name, String id, Class<? extends Component> navigationTarget) {
        this(name, id, () -> UI.getCurrent().navigate(navigationTarget));
    }

    @Deprecated(since="2.0.0")
    public ApplicationMenuItemDefinition(String name, List<ApplicationMenuItemDefinition> subMenuItemDefinitions) {
        this(name, ApplicationMenuItemDefinition.nameToId(name), subMenuItemDefinitions);
    }

    public ApplicationMenuItemDefinition(String name, String id, List<ApplicationMenuItemDefinition> subMenuItemDefinitions) {
        this.name = name;
        this.id = id;
        this.command = Handler.NOP_HANDLER;
        this.subMenuItemDefinitions = subMenuItemDefinitions;
    }

    static void navigateToLink(String location) {
        try {
            URL parsedUrl = new URL(location);
            UI.getCurrent().getPage().setLocation(parsedUrl.toString());
        }
        catch (MalformedURLException e) {
            UI.getCurrent().navigate(location);
        }
    }

    public MenuItem createItem(ApplicationMenu menuBar) {
        return this.createItem(arg_0 -> ((ApplicationMenu)menuBar).addItem(arg_0));
    }

    public MenuItem createItem(SubMenu subMenu) {
        return this.createItem(arg_0 -> ((SubMenu)subMenu).addItem(arg_0));
    }

    private MenuItem createItem(Function<String, MenuItem> createItemWithCaption) {
        MenuItem item = createItemWithCaption.apply(this.name);
        item.setId(this.id);
        item.addClickListener((ComponentEventListener & Serializable)event -> this.command.apply());
        for (ApplicationMenuItemDefinition subMenuItemDefinition : this.subMenuItemDefinitions) {
            subMenuItemDefinition.createItem((SubMenu)item.getSubMenu());
        }
        return item;
    }

    private static String nameToId(String name) {
        String id = name.toLowerCase().replaceAll(REGEX_UNKNOWN_CHARS.pattern(), " ").replaceAll(REGEX_WHITESPACES.pattern(), "-");
        id = StringUtils.removeEnd((String)id, (String)"-");
        return "appmenu-" + id;
    }
}

