/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

final class TermUtils {
    private TermUtils() {
    }

    static String toTermName(String string) {
        if (!TermUtils.isValidEntityName(string)) {
            throw new IllegalArgumentException("Object '" + string + "' is not a valid entity name");
        }
        State state = new Start();
        Context context = new Context();
        for (int i = 0; i < string.length(); ++i) {
            state = state.accept(i, string.charAt(i), context);
        }
        return context.complete();
    }

    static boolean isValidTermName(String string) {
        if (string == null) {
            return false;
        }
        return Pattern.matches("^\\p{javaUpperCase}[_\\p{javaUpperCase}]*$", string);
    }

    static boolean isValidEntityName(String string) {
        if (string == null) {
            return false;
        }
        return Pattern.matches("^[\\p{javaLowerCase}\\p{javaUpperCase}]+$", string);
    }

    private static final class UpperCase
    extends State {
        private UpperCase() {
        }

        @Override
        protected State handleUpperCase(int position, char character, Context state) {
            state.save(character);
            return this;
        }

        @Override
        protected State handleLowerCase(int position, char character, Context state) {
            state.pushGroup();
            state.push(character);
            return new Start();
        }
    }

    private static final class Start
    extends State {
        private Start() {
        }

        @Override
        protected State handleUpperCase(int position, char character, Context state) {
            state.startGroup(position);
            state.save(character);
            return new UpperCase();
        }

        @Override
        protected State handleLowerCase(int position, char character, Context state) {
            state.push(character);
            return this;
        }
    }

    private static abstract class State {
        private State() {
        }

        private State accept(int position, char character, Context state) {
            if (Character.isUpperCase(character)) {
                return this.handleUpperCase(position, character, state);
            }
            return this.handleLowerCase(position, character, state);
        }

        protected abstract State handleUpperCase(int var1, char var2, Context var3);

        protected abstract State handleLowerCase(int var1, char var2, Context var3);
    }

    private static final class Context {
        private final StringBuilder builder = new StringBuilder();
        private final List<Character> buffer = new ArrayList<Character>();
        private int mark = 0;

        private Context() {
        }

        private final void push(char character) {
            this.builder.append(Character.toUpperCase(character));
        }

        private final void startGroup(int position) {
            this.mark = position;
        }

        private final void save(char character) {
            this.buffer.add(Character.valueOf(character));
        }

        private final void pushGroup() {
            int size;
            if (this.mark != 0) {
                this.builder.append("_");
            }
            if ((size = this.buffer.size()) > 1) {
                for (int j = 0; j < size - 1; ++j) {
                    this.builder.append(this.buffer.get(j));
                }
                this.builder.append("_");
            }
            this.builder.append(this.buffer.get(size - 1));
            this.buffer.clear();
        }

        private final String complete() {
            if (!this.buffer.isEmpty()) {
                if (this.mark > 0) {
                    this.builder.append("_");
                }
                for (int j = 0; j < this.buffer.size(); ++j) {
                    this.builder.append(this.buffer.get(j));
                }
                this.buffer.clear();
            }
            return this.builder.toString();
        }
    }
}

