/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.ldp4j.application.data.AbstractMutableIndividual;
import org.ldp4j.application.data.ExternalIndividual;
import org.ldp4j.application.data.IndividualVisitor;
import org.ldp4j.application.data.MutableDataSet;
import org.ldp4j.application.data.Value;

final class MutableExternalIndividual
extends AbstractMutableIndividual<URI, ExternalIndividual>
implements ExternalIndividual {
    MutableExternalIndividual(URI id, MutableDataSet context) {
        super(id, context);
        Preconditions.checkArgument((boolean)id.isAbsolute(), (Object)"External individual URIs must be absolute");
    }

    @Override
    public URI location() {
        return (URI)super.id();
    }

    @Override
    public ExternalIndividual addValue(URI propertyId, Value value) {
        super.addPropertyValue(propertyId, value);
        return this;
    }

    @Override
    public ExternalIndividual removeValue(URI propertyId, Value value) {
        super.removePropertyValue(propertyId, value);
        return this;
    }

    @Override
    public void accept(IndividualVisitor visitor) {
        visitor.visitExternalIndividual(this);
    }
}

