/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import java.net.URI;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.IndividualFinder;
import org.ldp4j.application.data.Literal;
import org.ldp4j.application.data.Property;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.data.ValueVisitor;

public final class Individuals {
    private Individuals() {
    }

    public static void merge(Individual<?, ?> source, Individual<?, ?> target) {
        ValueReplicator replicator = new ValueReplicator(target.dataSet());
        for (Property property : source.properties()) {
            for (Value value : property) {
                target.addValue(property.predicate(), replicator.replicate(value));
            }
        }
    }

    public static void remove(Individual<?, ?> source, final Individual<?, ?> target) {
        for (Property property : source.properties()) {
            final URI propertyId = property.predicate();
            ValueVisitor visitor = new ValueVisitor(){

                @Override
                public void visitLiteral(Literal<?> value) {
                    target.removeValue(propertyId, value);
                }

                @Override
                public void visitIndividual(Individual<?, ?> value) {
                    Object cValue = target.dataSet().individualOfId(value.id());
                    if (cValue != null) {
                        target.removeValue(propertyId, (Value)cValue);
                    }
                }
            };
            for (Value value : property) {
                value.accept(visitor);
            }
        }
    }

    private static class ValueReplicator
    implements ValueVisitor {
        private final IndividualFinder finder;
        private Value result = null;

        ValueReplicator(DataSet dataSet) {
            this.finder = new IndividualFinder(dataSet);
        }

        Value replicate(Value value) {
            value.accept(this);
            return this.result;
        }

        @Override
        public void visitLiteral(Literal<?> value) {
            this.result = value;
        }

        @Override
        public void visitIndividual(Individual<?, ?> value) {
            this.result = this.finder.findOrCreate(value);
        }
    }
}

