/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.namespace.QName;

final class Datatypes {
    static final URI STRING = URI.create("http://www.w3.org/2001/XMLSchema#string");
    static final URI DATE_TIME = Datatypes.toURI(DatatypeConstants.DATETIME);
    static final URI DATE = Datatypes.toURI(DatatypeConstants.DATE);
    static final URI TIME = Datatypes.toURI(DatatypeConstants.TIME);
    static final URI GYEAR = Datatypes.toURI(DatatypeConstants.GYEAR);
    static final URI GMONTH = Datatypes.toURI(DatatypeConstants.GMONTH);
    static final URI GDAY = Datatypes.toURI(DatatypeConstants.GDAY);
    static final URI GYEARMONTH = Datatypes.toURI(DatatypeConstants.GYEARMONTH);
    static final URI GMONTHDAY = Datatypes.toURI(DatatypeConstants.GMONTHDAY);
    static final URI DURATION = Datatypes.toURI(DatatypeConstants.DURATION);
    private static final ImmutableList<URI> TEMPORAL_DATATYPES = ImmutableList.builder().add((Object)DATE_TIME).add((Object)DATE).add((Object)TIME).add((Object)GYEAR).add((Object)GMONTH).add((Object)GDAY).add((Object)GYEARMONTH).add((Object)GMONTHDAY).build();

    private Datatypes() {
    }

    private static URI toURI(QName qName) {
        return URI.create(qName.getNamespaceURI() + "#" + qName.getLocalPart());
    }

    static boolean isDuration(URI datatype) {
        return DURATION.equals(datatype);
    }

    static boolean isTemporal(URI datatype) {
        return DATE_TIME.equals(datatype) || DATE.equals(datatype) || TIME.equals(datatype) || GYEAR.equals(datatype) || GMONTH.equals(datatype) || GDAY.equals(datatype) || GYEARMONTH.equals(datatype) || GMONTHDAY.equals(datatype);
    }

    static List<URI> temporalDatatypes() {
        return TEMPORAL_DATATYPES;
    }
}

