/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.ldp4j.application.vocabulary.TermUtils;
import org.ldp4j.commons.testing.Utils;

public class TermUtilsTest {
    private final Map<String, String> termMappings = ImmutableMap.builder().put((Object)"v", (Object)"V").put((Object)"va", (Object)"VA").put((Object)"vA", (Object)"V_A").put((Object)"Va", (Object)"VA").put((Object)"VA", (Object)"VA").put((Object)"valid", (Object)"VALID").put((Object)"valiD", (Object)"VALI_D").put((Object)"valID", (Object)"VAL_ID").put((Object)"Valid", (Object)"VALID").put((Object)"VaLID", (Object)"VA_LID").put((Object)"vALid", (Object)"V_A_LID").put((Object)"vALId", (Object)"V_AL_ID").put((Object)"VALid", (Object)"VA_LID").put((Object)"VALId", (Object)"VAL_ID").put((Object)"vALID", (Object)"V_ALID").put((Object)"VALID", (Object)"VALID").put((Object)"validComposite", (Object)"VALID_COMPOSITE").build();

    @Test
    public void verifyIsUtilityClass() {
        MatcherAssert.assertThat((Object)Utils.isUtilityClass(TermUtils.class), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testToTermName$valid() throws Exception {
        for (Map.Entry<String, String> entry : this.termMappings.entrySet()) {
            MatcherAssert.assertThat((String)(entry.getKey() + "-->" + entry.getValue()), (Object)TermUtils.toTermName((String)entry.getKey()), (Matcher)Matchers.equalTo((Object)entry.getValue()));
        }
    }

    @Test
    public void testToTermName$invalid() throws Exception {
        try {
            TermUtils.toTermName((String)"invalid name");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Object 'invalid name' is not a valid entity name"));
        }
    }

    @Test
    public void testIsValidTermName$invalid() throws Exception {
        MatcherAssert.assertThat((Object)TermUtils.isValidTermName((String)"invalid name"), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValidTermName$null() throws Exception {
        MatcherAssert.assertThat((Object)TermUtils.isValidTermName(null), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValidEntityName$invalid() throws Exception {
        MatcherAssert.assertThat((Object)TermUtils.isValidEntityName((String)"invalid name"), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsValidEntityName$null() throws Exception {
        MatcherAssert.assertThat((Object)TermUtils.isValidEntityName(null), (Matcher)Matchers.equalTo((Object)false));
    }
}

