/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import mockit.Deencapsulation;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.vocabulary.AbstractImmutableVocabulary;
import org.ldp4j.application.vocabulary.ImmutableTerm;

@RunWith(value=JMockit.class)
public class AbstractImmutableVocabularyTest {
    @Test
    public void testValueOf() throws Exception {
        Class<?> enumClass = Thread.currentThread().getContextClassLoader().loadClass(AbstractImmutableVocabulary.class.getName() + "$Status");
        this.exerciseEnumerationGeneratedCode(enumClass);
    }

    private void exerciseEnumerationGeneratedCode(Class<?> enumClass) {
        Object[] enumValues;
        for (Object enumValue : enumValues = (Object[])Deencapsulation.invoke(enumClass, (String)"values", (Object[])new Object[0])) {
            Object valueOf = Deencapsulation.invoke(enumClass, (String)"valueOf", (Object[])new Object[]{enumValue.toString()});
            MatcherAssert.assertThat((Object)valueOf, (Matcher)Matchers.sameInstance((Object)enumValue));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicatedTerms() throws Exception {
        V v = new V();
        new ImmutableTerm((AbstractImmutableVocabulary)v, "entity");
        new ImmutableTerm((AbstractImmutableVocabulary)v, "entity");
    }

    @Test(expected=IllegalStateException.class)
    public void testBadRegistration$afterInitialized() throws Exception {
        V v = new V();
        new ImmutableTerm((AbstractImmutableVocabulary)v, "entity");
        v.initialize();
        new ImmutableTerm((AbstractImmutableVocabulary)v, "entity");
    }

    @Test(expected=IllegalStateException.class)
    public void testInitialize$cannotReinit() throws Exception {
        V v = new V();
        new ImmutableTerm((AbstractImmutableVocabulary)v, "entity");
        v.initialize();
        v.initialize();
    }

    @Test
    public void testBadRegistration$invalidOrdinal$lowerBound() throws Exception {
        V v = new V();
        new MockUp<ImmutableTerm>(){

            @Mock
            public int ordinal() {
                return -1;
            }
        };
        try {
            new ImmutableTerm((AbstractImmutableVocabulary)v, "entity");
            Assert.fail((String)"Should not allow register a term with invalid ordinal (lower)");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Vocabulary 'namespace' ("));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)") initialization failure: Invalid ordinal '-1' for reserved name 'ENTITY'"));
        }
    }

    @Test
    public void testBadRegistration$invalidOrdinal$upperBound() throws Exception {
        V v = new V();
        new MockUp<ImmutableTerm>(){

            @Mock
            public int ordinal() {
                return 3;
            }
        };
        try {
            new ImmutableTerm((AbstractImmutableVocabulary)v, "entity");
            Assert.fail((String)"Should not allow register a term with invalid ordinal (upper)");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Vocabulary 'namespace' ("));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)") initialization failure: Invalid ordinal '3' for reserved name 'ENTITY'"));
        }
    }

    @Test
    public void testBadRegistration$incomplete() throws Exception {
        V v = new V();
        new MockUp<AbstractImmutableVocabulary<ImmutableTerm>>(){

            @Mock
            public void registerTerm(ImmutableTerm term) {
            }
        };
        new ImmutableTerm((AbstractImmutableVocabulary)v, "one");
        try {
            v.initialize();
            Assert.fail((String)"Shot not initialize vocabulary without completing term registration");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Vocabulary 'namespace' ("));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)") initialization failure: not all reserved names have been registered"));
        }
    }

    static class V
    extends AbstractImmutableVocabulary<ImmutableTerm> {
        private static final long serialVersionUID = 6320487110172330521L;

        V() {
            super(ImmutableTerm.class, "namespace", "prefix");
        }
    }
}

