/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import java.io.Serializable;
import java.net.URI;
import mockit.Injectable;
import mockit.Tested;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.data.ExternalIndividual;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.MutableDataSet;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NewIndividual;
import org.ldp4j.application.data.Value;

@RunWith(value=JMockit.class)
public class MutableDataSetTest {
    @Injectable
    private Name<?> name;
    @Tested
    private MutableDataSet sut;

    @Test
    public void testName() {
        MatcherAssert.assertThat((Object)this.sut.name(), (Matcher)Matchers.sameInstance(this.name));
    }

    @Test
    public void testIsEmpty$noIndividuals() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testIsEmpty$anEmptyIndividual() throws Exception {
        this.sut.individual((Serializable)URI.create("urn:individual"), ExternalIndividual.class);
        MatcherAssert.assertThat((Object)this.sut.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testIsEmpty$nonEmptyIndividual() throws Exception {
        Individual individual = this.sut.individual((Serializable)URI.create("urn:individual"), ExternalIndividual.class);
        individual.addValue(URI.create("urn:property"), (Value)Literals.newLiteral((Object)"data"));
        MatcherAssert.assertThat((Object)this.sut.isEmpty(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testHasIndividuals$noIndividuals() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.hasIndividuals(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testHasIndividuals$anEmptyIndividual() throws Exception {
        this.sut.individual((Serializable)URI.create("urn:individual"), ExternalIndividual.class);
        MatcherAssert.assertThat((Object)this.sut.hasIndividuals(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testNumberOfIndividuals$noIndividuals() throws Exception {
        MatcherAssert.assertThat((Object)this.sut.numberOfIndividuals(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testNumberOfIndividuals$anEmptyIndividual() throws Exception {
        this.sut.individual((Serializable)URI.create("urn:individual"), ExternalIndividual.class);
        MatcherAssert.assertThat((Object)this.sut.numberOfIndividuals(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testIndividual$unsupportedClass() throws Exception {
        try {
            this.sut.individual((Serializable)((Object)"urn:individual"), UnsupportedIndividual.class);
            Assert.fail((String)"Should not create individuals for unsupported individual types");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Unsupported individual type 'org.ldp4j.application.data.MutableDataSetTest.UnsupportedIndividual'"));
        }
    }

    @Test
    public void testIdentifierReuseIsForbidden() throws Exception {
        this.sut.individual((Serializable)URI.create("urn:individual"), ExternalIndividual.class);
        try {
            this.sut.individual((Serializable)URI.create("urn:individual"), NewIndividual.class);
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Existing individual 'urn:individual' is not compatible with 'org.ldp4j.application.data.NewIndividual' (org.ldp4j.application.data.MutableExternalIndividual)"));
        }
    }

    @Test
    public void testIndividualsAreOnlyCreatedOnce() throws Exception {
        ExternalIndividual individual = (ExternalIndividual)this.sut.individual((Serializable)URI.create("urn:individual"), ExternalIndividual.class);
        MatcherAssert.assertThat((Object)this.sut.individual((Serializable)URI.create("urn:individual"), ExternalIndividual.class), (Matcher)Matchers.sameInstance((Object)individual));
    }

    private static interface UnsupportedIndividual
    extends Individual<String, UnsupportedIndividual> {
    }
}

