/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import com.google.common.base.Throwables;
import java.util.concurrent.TimeUnit;
import mockit.Deencapsulation;
import mockit.Expectations;
import mockit.Mocked;
import mockit.Verifications;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.ldp4j.application.ApplicationContext;
import org.ldp4j.application.ApplicationContextException;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.ext.ResourceHandler;
import org.ldp4j.application.ext.UnknownResourceException;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.spi.RuntimeDelegate;
import org.ldp4j.commons.testing.Utils;

@RunWith(value=JMockit.class)
public class ApplicationContextTest {
    @Rule
    public TestName name = new TestName();
    @Rule
    public Timeout timeout = Timeout.builder().withTimeout(5L, TimeUnit.SECONDS).withLookingForStuckThread(true).build();
    @Mocked
    private RuntimeDelegate delegate;
    @Mocked
    private ResourceSnapshot resource;
    @Mocked
    private Name<?> resourceName;

    private ApplicationContext createContext() {
        ApplicationContext sut = ApplicationContext.getInstance();
        Deencapsulation.setField((Object)sut, (String)"delegate", (Object)this.delegate);
        return sut;
    }

    @Test
    public void testGetInstance() throws Exception {
        MatcherAssert.assertThat((Object)this.createContext(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void verifyIsUtilityClass() throws ClassNotFoundException {
        Class<?> innerClass = Thread.currentThread().getContextClassLoader().loadClass(ApplicationContext.class.getCanonicalName() + "$ApplicationEngineSingleton");
        MatcherAssert.assertThat((Object)Utils.isUtilityClass(innerClass), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testToString() throws Exception {
        ApplicationContext sut = this.createContext();
        MatcherAssert.assertThat((Object)sut.toString(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)Utils.defaultToString((Object)sut))));
    }

    @Test
    public void testCreateSession$happyPath(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        WriteSession session = this.createContext().createSession();
        MatcherAssert.assertThat((Object)session, (Matcher)Matchers.notNullValue());
        session.close();
        new Verifications(){
            {
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testCreateSession$nullNativeSession() throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = null;
            }
        };
        try {
            this.createContext().createSession();
        }
        catch (ApplicationContextException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testCreateSession$offline(@Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.isOffline();
                this.result = true;
            }
        };
        try {
            this.createContext().createSession();
            Assert.fail((String)"Should not create session when off-line");
        }
        catch (ApplicationContextException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.notNullValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSession$singleSessionPerThread(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        try (WriteSession session = sut.createSession();){
            sut.createSession();
            Assert.fail((String)"Should not allow creating multiple sessions per thread");
        }
        new Verifications(){
            {
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$active$find(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
                nativeSession.find(ResourceSnapshot.class, ApplicationContextTest.this.resourceName, CustomResourceHandler.class);
                this.result = ApplicationContextTest.this.resource;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        MatcherAssert.assertThat((Object)session.find(ResourceSnapshot.class, this.resourceName, CustomResourceHandler.class), (Matcher)Matchers.sameInstance((Object)this.resource));
        session.close();
        new Verifications(){
            {
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$active$find(final @Mocked WriteSession nativeSession, final @Mocked Individual<?, ?> individual) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
                nativeSession.resolve(ResourceSnapshot.class, individual);
                this.result = ApplicationContextTest.this.resource;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        MatcherAssert.assertThat((Object)session.resolve(ResourceSnapshot.class, individual), (Matcher)Matchers.sameInstance((Object)this.resource));
        session.close();
        new Verifications(){
            {
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$active$modify(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.modify(this.resource);
        session.close();
        new Verifications(){
            {
                nativeSession.modify(ApplicationContextTest.this.resource);
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$active$delete(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.delete(this.resource);
        session.close();
        new Verifications(){
            {
                nativeSession.delete(ApplicationContextTest.this.resource);
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$active$saveChanges(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.saveChanges();
        session.close();
        this.verifySessionUsage(nativeSession);
    }

    @Test
    public void testWriteSession$active$discardChanges(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.discardChanges();
        session.close();
        new Verifications(){
            {
                nativeSession.discardChanges();
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$closed$find(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.close();
        try {
            session.find(ResourceSnapshot.class, this.resourceName, CustomResourceHandler.class);
            Assert.fail((String)"Session should not find resources after being closed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)Throwables.getRootCause((Throwable)e), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
        new Verifications(){
            {
                nativeSession.find(ResourceSnapshot.class, ApplicationContextTest.this.resourceName, CustomResourceHandler.class);
                this.maxTimes = 0;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$closed$find(final @Mocked WriteSession nativeSession, final @Mocked Individual<?, ?> individual) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.close();
        try {
            session.resolve(ResourceSnapshot.class, individual);
            Assert.fail((String)"Session should not resolve resources after being closed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)Throwables.getRootCause((Throwable)e), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
        new Verifications(){
            {
                nativeSession.resolve(ResourceSnapshot.class, individual);
                this.maxTimes = 0;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$closed$modify(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.close();
        try {
            session.modify(this.resource);
            Assert.fail((String)"Session should not modify resources after being closed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)Throwables.getRootCause((Throwable)e), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
        new Verifications(){
            {
                nativeSession.modify(ApplicationContextTest.this.resource);
                this.maxTimes = 0;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$closed$delete(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.close();
        try {
            session.delete(this.resource);
            Assert.fail((String)"Session should not delete resources after being closed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)Throwables.getRootCause((Throwable)e), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
        new Verifications(){
            {
                nativeSession.delete(ApplicationContextTest.this.resource);
                this.maxTimes = 0;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$closed$saveChanges(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.close();
        try {
            session.saveChanges();
            Assert.fail((String)"Session should not save changes after being closed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)Throwables.getRootCause((Throwable)e), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
        new Verifications(){
            {
                nativeSession.saveChanges();
                this.maxTimes = 0;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    @Test
    public void testWriteSession$closed$discardChanges(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        WriteSession session = sut.createSession();
        session.close();
        try {
            session.discardChanges();
            Assert.fail((String)"Session should not discard changes after being closed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)Throwables.getRootCause((Throwable)e), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
        new Verifications(){
            {
                nativeSession.discardChanges();
                this.maxTimes = 0;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteSession$completed$find(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        session.saveChanges();
        try (WriteSession session = sut.createSession();){
            session.find(ResourceSnapshot.class, this.resourceName, CustomResourceHandler.class);
            Assert.fail((String)"Session should not find resources after being closed");
        }
        new Verifications(){
            {
                nativeSession.find(ResourceSnapshot.class, ApplicationContextTest.this.resourceName, CustomResourceHandler.class);
                this.maxTimes = 0;
                nativeSession.saveChanges();
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteSession$completed$find(final @Mocked WriteSession nativeSession, final @Mocked Individual<?, ?> individual) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        session.saveChanges();
        try (WriteSession session = sut.createSession();){
            session.resolve(ResourceSnapshot.class, individual);
            Assert.fail((String)"Session should not resolve resources after being completed");
        }
        new Verifications(){
            {
                nativeSession.resolve(ResourceSnapshot.class, individual);
                this.maxTimes = 0;
                nativeSession.saveChanges();
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteSession$completed$modify(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        session.saveChanges();
        try (WriteSession session = sut.createSession();){
            session.modify(this.resource);
            Assert.fail((String)"Session should not modify resources after being completed");
        }
        new Verifications(){
            {
                nativeSession.modify(ApplicationContextTest.this.resource);
                this.maxTimes = 0;
                nativeSession.saveChanges();
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteSession$completed$delete(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        session.saveChanges();
        try (WriteSession session = sut.createSession();){
            session.delete(this.resource);
            Assert.fail((String)"Session should not delete resources after being completed");
        }
        new Verifications(){
            {
                nativeSession.delete(ApplicationContextTest.this.resource);
                this.maxTimes = 0;
                nativeSession.saveChanges();
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteSession$completed$saveChanges(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        session.saveChanges();
        try (WriteSession session = sut.createSession();){
            session.saveChanges();
            Assert.fail((String)"Session should not save changes after being completed");
        }
        this.verifySessionUsage(nativeSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteSession$completed$discardChanges(final @Mocked WriteSession nativeSession) throws Exception {
        new Expectations(){
            {
                ApplicationContextTest.this.delegate.createSession();
                this.result = nativeSession;
            }
        };
        ApplicationContext sut = this.createContext();
        session.saveChanges();
        try (WriteSession session = sut.createSession();){
            session.discardChanges();
            Assert.fail((String)"Session should not discard changes after being completed");
        }
        new Verifications(){
            {
                nativeSession.discardChanges();
                this.maxTimes = 0;
                nativeSession.saveChanges();
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    private void verifySessionUsage(final WriteSession nativeSession) throws Exception {
        new Verifications(){
            {
                nativeSession.saveChanges();
                this.maxTimes = 1;
                this.minTimes = 1;
                nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    public static class CustomResourceHandler
    implements ResourceHandler {
        public DataSet get(ResourceSnapshot resource) throws UnknownResourceException {
            return null;
        }
    }
}

