/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data.constraints;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Literal;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.data.ValueVisitor;
import org.ldp4j.application.data.constraints.ConstraintsHelper;

public final class Constraints
implements Serializable {
    private static final long serialVersionUID = 4368698694568719975L;
    private Map<Serializable, Shape> nodeShapes = Maps.newLinkedHashMap();
    private Map<URI, Shape> typeShapes = Maps.newLinkedHashMap();

    private Constraints() {
    }

    public List<Shape> shapes() {
        return ImmutableList.builder().addAll(this.typeShapes.values()).addAll(this.nodeShapes.values()).build();
    }

    public Set<URI> types() {
        return ImmutableSet.copyOf(this.typeShapes.keySet());
    }

    public Set<Individual<?, ?>> nodes(DataSet dataSet) {
        Preconditions.checkNotNull((Object)dataSet, (Object)"Data set cannot be null");
        return ConstraintsHelper.getOrCreateIndividuals(dataSet, this.nodeShapes.keySet());
    }

    public Shape typeShape(URI type) {
        return this.typeShapes.get(type);
    }

    public Shape nodeShape(Individual<?, ?> individual) {
        return this.nodeShapes.get(individual.id());
    }

    public Constraints withTypeShape(URI type, Shape shape) {
        Preconditions.checkNotNull((Object)type, (Object)"Type URI cannot be null");
        Preconditions.checkNotNull((Object)shape, (Object)"Shape cannot be null");
        Preconditions.checkArgument((!this.typeShapes.containsKey(type) ? 1 : 0) != 0, (Object)("A shape is already defined for type '" + type + "'"));
        this.typeShapes.put(type, shape);
        return this;
    }

    public Constraints withNodeShape(Individual<?, ?> individual, Shape shape) {
        Preconditions.checkNotNull(individual, (Object)"Type URI cannot be null");
        Preconditions.checkNotNull((Object)shape, (Object)"Shape cannot be null");
        Preconditions.checkArgument((!this.nodeShapes.containsKey(individual.id()) ? 1 : 0) != 0, (Object)("A shape is already defined for individual '" + individual.id() + "'"));
        this.nodeShapes.put((Serializable)individual.id(), shape);
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("typeShapes", this.typeShapes).add("nodeShapes", this.nodeShapes).toString();
    }

    public static Shape shape() {
        return new Shape();
    }

    public static Constraints constraints() {
        return new Constraints();
    }

    public static PropertyConstraint propertyConstraint(URI predicate) {
        return new PropertyConstraint(predicate);
    }

    public static InversePropertyConstraint inversePropertyConstraint(URI predicate) {
        return new InversePropertyConstraint(predicate);
    }

    public static final class Shape
    implements Describable,
    Serializable {
        private static final long serialVersionUID = 3966457418001884744L;
        private Map<URI, AbstractPropertyConstraint<?>> constraints = Maps.newLinkedHashMap();
        private String label;
        private String comment;

        private Shape() {
        }

        public Shape withLabel(String label) {
            this.label = label;
            return this;
        }

        @Override
        public String label() {
            return this.label;
        }

        public Shape withComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public String comment() {
            return this.comment;
        }

        public Shape withPropertyConstraint(PropertyConstraint constraint) {
            Preconditions.checkNotNull((Object)constraint);
            URI predicate = constraint.predicate();
            Preconditions.checkArgument((!this.constraints.containsKey(predicate) ? 1 : 0) != 0, (Object)("Shape already defines constraints for predicate '" + predicate + "'"));
            this.constraints.put(predicate, constraint);
            return this;
        }

        public Shape withPropertyConstraint(InversePropertyConstraint constraint) {
            Preconditions.checkNotNull((Object)constraint);
            URI predicate = constraint.predicate();
            Preconditions.checkArgument((!this.constraints.containsKey(predicate) ? 1 : 0) != 0, (Object)("Shape already defines constraints for predicate '" + predicate + "'"));
            this.constraints.put(predicate, constraint);
            return this;
        }

        public List<PropertyConstraint> propertyConstraints() {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.filter(builder, PropertyConstraint.class);
            return builder.build();
        }

        public List<InversePropertyConstraint> inversePropertyConstraints() {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.filter(builder, InversePropertyConstraint.class);
            return builder.build();
        }

        private <T extends AbstractPropertyConstraint<?>> void filter(ImmutableList.Builder<T> builder, Class<? extends T> clazz) {
            for (AbstractPropertyConstraint<?> c : this.constraints.values()) {
                if (!clazz.isInstance(c)) continue;
                builder.add(clazz.cast(c));
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("label", (Object)this.label).add("comment", (Object)this.comment).add("constraints", this.constraints).toString();
        }
    }

    public static final class InversePropertyConstraint
    extends AbstractPropertyConstraint<InversePropertyConstraint>
    implements Describable {
        private static final long serialVersionUID = -6328974380403084873L;

        private InversePropertyConstraint(URI predicate) {
            super(predicate);
        }

        @Override
        protected InversePropertyConstraint delegate() {
            return this;
        }
    }

    public static final class PropertyConstraint
    extends AbstractPropertyConstraint<PropertyConstraint>
    implements Describable {
        private static final long serialVersionUID = -2646499801130951583L;

        private PropertyConstraint(URI predicate) {
            super(predicate);
        }

        @Override
        protected PropertyConstraint delegate() {
            return this;
        }
    }

    public static abstract class AbstractPropertyConstraint<T extends AbstractPropertyConstraint<T>>
    implements Serializable {
        private static final long serialVersionUID = 6473281395518369031L;
        private final URI predicate;
        private String comment;
        private String label;
        private Set<Serializable> allowedIndividuals;
        private Set<Literal<?>> allowedLiterals;
        private List<Serializable> individuals;
        private List<Literal<?>> literals;
        private URI datatype;
        private NodeKind nodeKind;
        private Shape valueShape;
        private URI valueType;
        private Cardinality cardinality;

        protected AbstractPropertyConstraint(URI predicate) {
            this.predicate = predicate;
        }

        protected abstract T delegate();

        public T withLabel(String label) {
            Preconditions.checkNotNull((Object)label, (Object)"Label cannot be null");
            this.label = label;
            return this.delegate();
        }

        public String label() {
            return this.label;
        }

        public T withComment(String comment) {
            Preconditions.checkNotNull((Object)comment, (Object)"Comment cannot be null");
            this.comment = comment;
            return this.delegate();
        }

        public String comment() {
            return this.comment;
        }

        public URI predicate() {
            return this.predicate;
        }

        public T withCardinality(Cardinality cardinality) {
            Preconditions.checkNotNull((Object)cardinality, (Object)"Cardinality cannot be null");
            this.cardinality = cardinality;
            return this.delegate();
        }

        public Cardinality cardinality() {
            Cardinality result = this.cardinality;
            if (result == null) {
                result = Cardinality.unbound();
            }
            return result;
        }

        public T withAllowedValues(Value ... allowedValues) {
            Preconditions.checkNotNull((Object)allowedValues, (Object)"Allowed values cannot be null");
            this.allowedLiterals = Sets.newLinkedHashSet();
            this.allowedIndividuals = Sets.newLinkedHashSet();
            ValueCollector valueCollector = new ValueCollector(this.allowedIndividuals, this.allowedLiterals);
            for (Value value : allowedValues) {
                value.accept(valueCollector);
            }
            return this.delegate();
        }

        public Set<Literal<?>> allowedLiterals() {
            LinkedHashSet result = this.allowedLiterals;
            if (result == null) {
                result = Sets.newLinkedHashSet();
            }
            return ImmutableSet.copyOf((Collection)result);
        }

        public Set<Individual<?, ?>> allowedIndividuals(DataSet dataSet) {
            LinkedHashSet result = this.allowedIndividuals;
            if (result == null) {
                result = Sets.newLinkedHashSet();
            }
            return ConstraintsHelper.getOrCreateIndividuals(dataSet, result);
        }

        public T withDatatype(URI datatype) {
            Preconditions.checkNotNull((Object)datatype, (Object)"Datatype cannot be null");
            this.datatype = datatype;
            return this.delegate();
        }

        public URI datatype() {
            return this.datatype;
        }

        public T withValue(Value ... values) {
            Preconditions.checkNotNull((Object)values, (Object)"Value cannot be null");
            this.literals = Lists.newArrayList();
            this.individuals = Lists.newArrayList();
            ValueCollector valueCollector = new ValueCollector(this.individuals, this.literals);
            for (Value value : values) {
                value.accept(valueCollector);
            }
            return this.delegate();
        }

        public List<Literal<?>> literals() {
            ArrayList result = this.literals;
            if (result == null) {
                result = Lists.newArrayList();
            }
            return ImmutableList.copyOf((Collection)result);
        }

        public List<Individual<?, ?>> individuals(DataSet dataSet) {
            ArrayList result = this.individuals;
            if (result == null) {
                result = Lists.newArrayList();
            }
            return ConstraintsHelper.getOrCreateIndividuals(dataSet, result);
        }

        public T withNodeKind(NodeKind nodeKind) {
            Preconditions.checkNotNull((Object)((Object)nodeKind), (Object)"Node kind cannot be null");
            this.nodeKind = nodeKind;
            return this.delegate();
        }

        public NodeKind nodeKind() {
            return this.nodeKind;
        }

        public T withValueShape(Shape valueShape) {
            this.valueShape = valueShape;
            return this.delegate();
        }

        public Shape valueShape() {
            return this.valueShape;
        }

        public T withValueType(URI valueType) {
            this.valueType = valueType;
            return this.delegate();
        }

        public URI valueType() {
            return this.valueType;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("predicate", (Object)this.predicate).add("label", (Object)this.label).add("comment", (Object)this.comment).add("cardinality", (Object)this.cardinality()).add("allowedLiterals", this.allowedLiterals).add("allowedIndividuals", this.allowedIndividuals).add("datatype", (Object)this.datatype).add("literals", this.literals).add("literals", this.individuals).add("nodeKind", (Object)this.nodeKind).add("valueShape", (Object)this.valueShape).add("valueType", (Object)this.valueType).toString();
        }

        private static final class ValueCollector
        implements ValueVisitor {
            private final Collection<Serializable> individuals;
            private final Collection<Literal<?>> literals;

            private ValueCollector(Collection<Serializable> individuals, Collection<Literal<?>> lLiterals) {
                this.individuals = individuals;
                this.literals = lLiterals;
            }

            @Override
            public void visitLiteral(Literal<?> value) {
                this.literals.add(value);
            }

            @Override
            public void visitIndividual(Individual<?, ?> value) {
                this.individuals.add((Serializable)value.id());
            }
        }
    }

    public static final class Cardinality
    implements Serializable {
        private static final long serialVersionUID = 7262473645776142538L;
        private int min;
        private int max;

        private Cardinality(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int min() {
            return this.min;
        }

        public int max() {
            return this.max;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("min", this.min).add("max", this.max).toString();
        }

        public static Cardinality mandatory() {
            return new Cardinality(1, 1);
        }

        public static Cardinality atMost(int max) {
            return new Cardinality(0, max);
        }

        public static Cardinality atLeast(int min) {
            return new Cardinality(min, -1);
        }

        public static Cardinality create(int min, int max) {
            return new Cardinality(min, max);
        }

        public static Cardinality optional() {
            return new Cardinality(0, 1);
        }

        public static Cardinality unbound() {
            return new Cardinality(0, -1);
        }
    }

    public static interface Describable {
        public String label();

        public String comment();
    }

    public static enum NodeKind {
        NODE("Node"),
        BLANK_NODE_OR_IRI("BlankNodeOrIRI"),
        BLANK_NODE_OR_LITERAL("BlankNodeOrLiteral"),
        LITERAL_OR_IRI("LiteralOrIRI"),
        BLANK_NODE("BlankNode"),
        IRI("IRI"),
        LITERAL("Literal");

        private final String localName;

        private NodeKind(String localName) {
            this.localName = localName;
        }

        public String localName() {
            return this.localName;
        }
    }
}

