/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ldp4j.application.data.ImmutableProperty;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.MutableDataSet;
import org.ldp4j.application.data.MutableProperty;
import org.ldp4j.application.data.Property;
import org.ldp4j.application.data.Value;

final class PropertyCollection
implements Iterable<Property> {
    private final Map<URI, MutableProperty> properties;
    private final ReentrantReadWriteLock lock;
    private final MutableDataSet dataSet;
    private final Individual<?, ?> individual;

    PropertyCollection(Individual<?, ?> individual, MutableDataSet context) {
        this.individual = individual;
        this.dataSet = context;
        this.properties = new LinkedHashMap<URI, MutableProperty>();
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        this.lock.readLock().lock();
        try {
            int n = this.properties.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.properties.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Property> properties() {
        this.lock.readLock().lock();
        try {
            ArrayList<Property> result = new ArrayList<Property>();
            for (MutableProperty property : this.properties.values()) {
                result.add(new ImmutableProperty(property));
            }
            ArrayList<Property> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasProperty(URI propertyId) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.properties.containsKey(propertyId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Property property(URI propertyId) {
        this.lock.readLock().lock();
        try {
            MutableProperty result = this.properties.get(propertyId);
            if (result != null) {
                ImmutableProperty immutableProperty = new ImmutableProperty(result);
                return immutableProperty;
            }
            MutableProperty mutableProperty = result;
            return mutableProperty;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addValue(URI propertyId, Value value) {
        Preconditions.checkNotNull((Object)propertyId, (Object)"Property identifier cannot be null");
        Preconditions.checkNotNull((Object)value, (Object)"Property value cannot be null");
        this.lock.writeLock().lock();
        try {
            MutableProperty property = this.properties.get(propertyId);
            if (property == null) {
                property = new MutableProperty(this.individual, this.dataSet, propertyId);
                this.properties.put(propertyId, property);
            }
            property.addValue(value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeValue(URI propertyId, Value value) {
        Preconditions.checkNotNull((Object)propertyId, (Object)"Property identifier cannot be null");
        Preconditions.checkNotNull((Object)value, (Object)"Property value cannot be null");
        this.lock.writeLock().lock();
        try {
            MutableProperty property = this.properties.get(propertyId);
            if (property != null) {
                property.removeValue(value);
                if (!property.hasValues()) {
                    this.properties.remove(propertyId);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<URI> propertyIds() {
        this.lock.readLock().lock();
        try {
            LinkedHashSet<URI> linkedHashSet = new LinkedHashSet<URI>(this.properties.keySet());
            return linkedHashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

