/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ldp4j.application.data.ImmutableName;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.vocabulary.Term;

public final class NamingScheme {
    private static final Map<NamingStrategy, NameFactory> FACTORIES = ImmutableMap.builder().put((Object)NamingStrategy.GLOBAL, (Object)new GlobalNameFactory()).put((Object)NamingStrategy.LOCAL, (Object)new LocalNameFactory()).build();
    private final Map<NameType, NamingStrategy> configuration;

    private NamingScheme(Map<NameType, NamingStrategy> configuration) {
        this.configuration = configuration;
    }

    private NameFactory getFactory(NameType type) {
        NamingStrategy namingStrategy = this.configuration.get((Object)type);
        if (namingStrategy == null) {
            namingStrategy = NamingStrategy.GLOBAL;
        }
        return FACTORIES.get((Object)namingStrategy);
    }

    private static void append(StringBuilder builder, String part) {
        if (part != null && !part.isEmpty()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
    }

    private static String assemble(String name, String ... names) {
        StringBuilder builder = new StringBuilder();
        NamingScheme.append(builder, name);
        if (names != null) {
            for (String s : names) {
                NamingScheme.append(builder, s);
            }
        }
        return builder.toString();
    }

    private <T extends Serializable> Name<T> createName(T id) {
        return this.getFactory(NameType.valueOf(id)).create(id);
    }

    public Name<URI> name(URI id) {
        return this.createName(id);
    }

    public Name<QName> name(QName id) {
        return this.createName(id);
    }

    public Name<Term> name(Term id) {
        return this.createName(id);
    }

    public Name<String> name(String name, String ... names) {
        return this.createName(NamingScheme.assemble(name, names));
    }

    public Name<String> name(Class<?> clazz, String ... names) {
        return this.name(clazz.getCanonicalName(), names);
    }

    public <T extends Number> Name<T> name(T id) {
        return this.createName(id);
    }

    public <T extends Serializable> Name<T> name(T id) {
        return this.createName(id);
    }

    public static NamingSchemeBuilder builder() {
        return new NamingSchemeBuilder();
    }

    public static NamingScheme getDefault() {
        return NamingScheme.builder().build();
    }

    public static final class NamingSchemeBuilder {
        private Map<NameType, NamingStrategy> configuration = new HashMap<NameType, NamingStrategy>();

        private void addMappings(NamingStrategy strategy, NameType type, NameType ... rest) {
            this.configuration.put(type, strategy);
            for (NameType r : rest) {
                this.configuration.put(r, strategy);
            }
        }

        public NamingSchemeBuilder withLocal(NameType type, NameType ... rest) {
            this.addMappings(NamingStrategy.LOCAL, type, rest);
            return this;
        }

        public NamingSchemeBuilder withGlobal(NameType type, NameType ... rest) {
            this.addMappings(NamingStrategy.GLOBAL, type, rest);
            return this;
        }

        public NamingScheme build() {
            return new NamingScheme(this.configuration);
        }
    }

    private static final class LocalNameFactory
    implements NameFactory {
        private LocalNameFactory() {
        }

        @Override
        public <T extends Serializable> Name<T> create(T id) {
            return ImmutableName.newLocalName(id);
        }
    }

    private static final class GlobalNameFactory
    implements NameFactory {
        private GlobalNameFactory() {
        }

        @Override
        public <T extends Serializable> Name<T> create(T id) {
            return ImmutableName.newGlobalName(id);
        }
    }

    private static interface NameFactory {
        public <T extends Serializable> Name<T> create(T var1);
    }

    private static enum NamingStrategy {
        LOCAL,
        GLOBAL;

    }

    public static enum NameType {
        TERM(Term.class),
        URI(URI.class),
        QNAME(QName.class),
        STRING(String.class),
        NUMBER(Number.class),
        SERIALIZABLE(Serializable.class);

        private final Class<?> clazz;

        private NameType(Class<?> clazz) {
            this.clazz = clazz;
        }

        private static NameType valueOf(Object t) {
            for (NameType candidate : NameType.values()) {
                if (!candidate.clazz.isInstance(t)) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Invalid name type '" + t.getClass().getCanonicalName() + "'");
        }

        public String toString() {
            return this.clazz.getCanonicalName();
        }
    }
}

