/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.ldp4j.application.ApplicationContext;
import org.ldp4j.application.ContextWriteSessionStateListener;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.ext.ResourceHandler;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.SessionTerminationException;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.session.WriteSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ContextWriteSessionState
implements WriteSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContext.class);
    private static final AtomicLong SESSION_COUNTER = new AtomicLong();
    private final long id;
    private final WriteSession delegate;
    private final ContextWriteSessionStateListener listener;
    private boolean disposed;
    private boolean completed;

    ContextWriteSessionState(WriteSession delegate, ContextWriteSessionStateListener listener) {
        this.delegate = delegate;
        this.listener = listener;
        this.id = SESSION_COUNTER.incrementAndGet();
    }

    private void doDispose() throws SessionTerminationException {
        this.listener.onDispose(this);
        this.disposed = true;
        this.delegate.close();
    }

    private void verifyExecutability() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Session has already been disposed");
        Preconditions.checkState((!this.completed ? 1 : 0) != 0, (Object)"Session has already been completed");
    }

    long id() {
        return this.id;
    }

    synchronized void dispose() {
        LOGGER.warn("Closing session {} which was not closed by the user...", (Object)this);
        try {
            this.doDispose();
        }
        catch (SessionTerminationException e) {
            LOGGER.error("Could not close session {}", (Object)this, (Object)e);
        }
    }

    @Override
    public synchronized <S extends ResourceSnapshot> S resolve(Class<? extends S> snapshotClass, Individual<?, ?> individual) {
        this.verifyExecutability();
        return this.delegate.resolve(snapshotClass, individual);
    }

    @Override
    public synchronized <S extends ResourceSnapshot> S find(Class<? extends S> snapshotClass, Name<?> id, Class<? extends ResourceHandler> handlerClass) {
        this.verifyExecutability();
        return this.delegate.find(snapshotClass, id, handlerClass);
    }

    @Override
    public synchronized void modify(ResourceSnapshot resource) {
        this.verifyExecutability();
        this.delegate.modify(resource);
    }

    @Override
    public synchronized void delete(ResourceSnapshot resource) {
        this.verifyExecutability();
        this.delegate.delete(resource);
    }

    @Override
    public synchronized void saveChanges() throws WriteSessionException {
        this.verifyExecutability();
        this.delegate.saveChanges();
        this.completed = true;
    }

    @Override
    public synchronized void discardChanges() throws WriteSessionException {
        this.verifyExecutability();
        this.delegate.discardChanges();
        this.completed = true;
    }

    @Override
    public synchronized void close() throws SessionTerminationException {
        if (this.disposed) {
            return;
        }
        this.doDispose();
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id).add("completed", this.completed).add("disposed", this.disposed).add("delegate", (Object)this.delegate).toString();
    }
}

