/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import com.google.common.base.Throwables;
import java.net.URI;
import javax.xml.namespace.QName;
import mockit.Deencapsulation;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.vocabulary.CannotAdaptClassesException;
import org.ldp4j.application.vocabulary.External;
import org.ldp4j.application.vocabulary.RDF;
import org.ldp4j.application.vocabulary.Term;
import org.ldp4j.application.vocabulary.TypeAdapter;
import org.ldp4j.commons.testing.Utils;

@RunWith(value=JMockit.class)
public class TypeAdapterTest {
    private static final String SHOULD_BE_ACCESIBLE = "Chosen adapter method 'private static void org.ldp4j.application.vocabulary.External.privateMethod()' should be accesible";
    private static final String SHOULD_ACCEPT = "Chosen adapter method 'public static void org.ldp4j.application.vocabulary.External.noParameterMethod()' should accept 'org.ldp4j.application.vocabulary.ImmutableTerm'";
    private static final String ADAPTER_FAILED = "Chosen adapter method 'public static java.net.URI org.ldp4j.application.vocabulary.TypeAdapter$URIAdapter.adaptTo(org.ldp4j.application.vocabulary.Term)' failed while adapting value 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type'";
    private static final String COULD_NOT_ADAPT = "Chosen adapter method 'public static java.net.URI org.ldp4j.application.vocabulary.TypeAdapter$URIAdapter.adaptTo(org.ldp4j.application.vocabulary.Term)' could not adapt value 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type";

    @Test
    public void verifyIsUtilityClass$QNameAdapter() {
        MatcherAssert.assertThat((Object)Utils.isUtilityClass(TypeAdapter.QNameAdapter.class), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void verifyIsUtilityClass$URIAdapter() {
        MatcherAssert.assertThat((Object)Utils.isUtilityClass(TypeAdapter.URIAdapter.class), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testAdapt$URI() {
        MatcherAssert.assertThat((Object)TypeAdapter.adapt((Object)RDF.TYPE, URI.class), (Matcher)Matchers.equalTo((Object)URI.create(RDF.TYPE.qualifiedEntityName())));
    }

    @Test
    public void testAdapt$QName() {
        MatcherAssert.assertThat((Object)TypeAdapter.adapt((Object)RDF.TYPE, QName.class), (Matcher)Matchers.equalTo((Object)new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", RDF.TYPE.entityName(), "rdf")));
    }

    @Test
    public void testAdapt$notFound() {
        try {
            TypeAdapter.adapt((Object)"uri", URI.class);
            Assert.fail((String)"Should not adapt String to URI");
        }
        catch (CannotAdaptClassesException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Could not find adapter of adapting class 'java.lang.String' to 'java.net.URI'"));
        }
    }

    @Test
    public void testAdapt$nullResult() {
        new MockUp<TypeAdapter.URIAdapter>(){

            @Mock
            public URI adaptTo(Term term) {
                return null;
            }
        };
        try {
            TypeAdapter.adapt((Object)RDF.TYPE, URI.class);
            Assert.fail((String)"Should not adapt Term to URI if null is returned");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)COULD_NOT_ADAPT));
        }
    }

    @Test
    public void testAdapt$illegalArgumentException() throws Exception {
        TypeAdapter adapter = TypeAdapter.createAdapter(Term.class, URI.class);
        Deencapsulation.setField((Object)adapter, (String)"adapterMethod", (Object)External.class.getDeclaredMethod("noParameterMethod", new Class[0]));
        try {
            adapter.adapt((Object)RDF.TYPE);
            Assert.fail((String)"Should not adapt Term to URI if IllegalArgumentException is thrown");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)SHOULD_ACCEPT));
        }
    }

    @Test
    public void testAdapt$illegalAccessException() throws Exception {
        TypeAdapter adapter = TypeAdapter.createAdapter(Term.class, URI.class);
        Deencapsulation.setField((Object)adapter, (String)"adapterMethod", (Object)External.class.getDeclaredMethod("privateMethod", new Class[0]));
        try {
            adapter.adapt((Object)RDF.TYPE);
            Assert.fail((String)"Should not adapt Term to URI if IllegalAccessException is thrown");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)SHOULD_BE_ACCESIBLE));
        }
    }

    @Test
    public void testAdapt$invocationTargetException() {
        new MockUp<TypeAdapter.URIAdapter>(){

            @Mock
            public URI adaptTo(Term term) {
                throw new IllegalArgumentException("FAILURE");
            }
        };
        try {
            TypeAdapter.adapt((Object)RDF.TYPE, URI.class);
            Assert.fail((String)"Should not adapt Term to URI if InvocationTargetException is thrown");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)ADAPTER_FAILED));
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            MatcherAssert.assertThat((Object)rootCause, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
            MatcherAssert.assertThat((Object)rootCause.getMessage(), (Matcher)Matchers.equalTo((Object)"FAILURE"));
        }
    }
}

