/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import com.google.common.collect.Lists;
import java.net.URI;
import javax.xml.namespace.QName;
import mockit.Deencapsulation;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.ldp4j.application.vocabulary.AbstractImmutableVocabulary;
import org.ldp4j.application.vocabulary.Term;

public abstract class AbstractVocabularyTest<T extends AbstractImmutableVocabulary<?>> {
    protected abstract T vocabulary();

    protected abstract String namespace();

    protected abstract String preferredPrefix();

    protected abstract URI unknownURITerm();

    protected abstract QName unknownQNameTerm();

    @Test
    public void testGetId() {
        MatcherAssert.assertThat((Object)this.vocabulary().getId(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testGetNamespace() {
        MatcherAssert.assertThat((Object)this.vocabulary().getNamespace(), (Matcher)Matchers.equalTo((Object)this.namespace()));
    }

    @Test
    public void testGetPreferredPrefix() {
        MatcherAssert.assertThat((Object)this.vocabulary().getPreferredPrefix(), (Matcher)Matchers.equalTo((Object)this.preferredPrefix()));
    }

    @Test
    public void testFromName() {
        T vocabulary = this.vocabulary();
        for (Term term : vocabulary.terms()) {
            MatcherAssert.assertThat((Object)vocabulary.fromName(term.name()), (Matcher)Matchers.sameInstance((Object)term));
        }
    }

    @Test
    public void testFromName$unknown() {
        T vocabulary = this.vocabulary();
        MatcherAssert.assertThat((Object)vocabulary.fromName("$$"), (Matcher)Matchers.nullValue());
    }

    @Test(expected=NullPointerException.class)
    public void testFromName$null() {
        T vocabulary = this.vocabulary();
        vocabulary.fromName(null);
    }

    @Test
    public void testFromOrdinal() {
        T vocabulary = this.vocabulary();
        for (Term term : vocabulary.terms()) {
            MatcherAssert.assertThat((String)("fromOrdinal(" + term.name() + ".ordinal()) failed"), (Object)vocabulary.fromOrdinal(term.ordinal()), (Matcher)Matchers.sameInstance((Object)term));
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testFromOrdinal$outOfBounds$upper() {
        T vocabulary = this.vocabulary();
        vocabulary.fromOrdinal(vocabulary.size() + 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testFromOrdinal$outOfBounds$lower() {
        T vocabulary = this.vocabulary();
        vocabulary.fromOrdinal(-1);
    }

    @Test
    public void testFromValue() {
        T vocabulary = this.vocabulary();
        for (Term term : vocabulary.terms()) {
            MatcherAssert.assertThat((Object)vocabulary.fromValue(term.as(URI.class)), (Matcher)Matchers.sameInstance((Object)term));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testFromValue$null() {
        T vocabulary = this.vocabulary();
        vocabulary.fromValue(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFromValue$incompatible() {
        T vocabulary = this.vocabulary();
        vocabulary.fromValue((Object)"1");
    }

    @Test
    public void testFromValue$compatible$unknown$uri() {
        T vocabulary = this.vocabulary();
        MatcherAssert.assertThat((Object)vocabulary.fromValue((Object)this.unknownURITerm()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testFromValue$compatible$unknown$qname() {
        T vocabulary = this.vocabulary();
        MatcherAssert.assertThat((Object)vocabulary.fromValue((Object)this.unknownQNameTerm()), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testSize() {
        T vocabulary = this.vocabulary();
        MatcherAssert.assertThat((Object)vocabulary.size(), (Matcher)Matchers.equalTo((Object)vocabulary.terms().length));
    }

    @Test
    public void testIterator() {
        T vocabulary = this.vocabulary();
        MatcherAssert.assertThat((Object)Lists.newArrayList(vocabulary), (Matcher)Matchers.contains((Object[])vocabulary.terms()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIterator$removeNotSupported() {
        T vocabulary = this.vocabulary();
        vocabulary.iterator().remove();
    }

    @Test
    public void testValues() {
        T vocabulary = this.vocabulary();
        MatcherAssert.assertThat((Object)Lists.newArrayList((Object[])((Term[])Deencapsulation.invoke(vocabulary.getClass(), (String)"values", (Object[])new Object[0]))), (Matcher)Matchers.contains((Object[])vocabulary.terms()));
    }

    @Test
    public void testValueOf$fromString() {
        T vocabulary = this.vocabulary();
        for (Term term : vocabulary.terms()) {
            MatcherAssert.assertThat((Object)((Term)Deencapsulation.invoke(vocabulary.getClass(), (String)"valueOf", (Object[])new Object[]{term.name()})), (Matcher)Matchers.sameInstance((Object)term));
        }
    }

    @Test
    public void testValueOf$fromURI() {
        T vocabulary = this.vocabulary();
        for (Term term : vocabulary.terms()) {
            MatcherAssert.assertThat((Object)((Term)Deencapsulation.invoke(vocabulary.getClass(), (String)"valueOf", (Object[])new Object[]{term.as(URI.class)})), (Matcher)Matchers.sameInstance((Object)term));
        }
    }

    @Test
    public void testValueOf$fromQName() {
        T vocabulary = this.vocabulary();
        for (Term term : vocabulary.terms()) {
            MatcherAssert.assertThat((Object)((Term)Deencapsulation.invoke(vocabulary.getClass(), (String)"valueOf", (Object[])new Object[]{term.as(QName.class)})), (Matcher)Matchers.sameInstance((Object)term));
        }
    }
}

