/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.session;

import java.net.URI;
import mockit.Deencapsulation;
import mockit.Mocked;
import mockit.Verifications;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.ApplicationContextException;
import org.ldp4j.application.session.ReadSession;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.SnapshotResolver;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.spi.ResourceSnapshotResolver;
import org.ldp4j.application.spi.RuntimeDelegate;
import org.ldp4j.application.spi.ShutdownListener;

@RunWith(value=JMockit.class)
public class SnapshotResolverTest {
    private static final URI CANONICAL_BASE = URI.create("http://www.ldp4j.org/context/");
    private static final URI NON_HIERARCHICAL_CANONICAL_BASE = URI.create("urn:www.ldp4j.org/context/");
    private static final URI NON_ABSOLUTE_CANONICAL_BASE = URI.create("context/");

    @Test
    public void testToURI(@Mocked ReadSession session, final @Mocked ResourceSnapshotResolver resolver) throws Exception {
        SnapshotResolver sut = this.buildResolver(session, resolver);
        sut.fromURI(CANONICAL_BASE);
        new Verifications(){
            {
                resolver.resolve(CANONICAL_BASE);
            }
        };
    }

    @Test
    public void testFromURI(@Mocked ReadSession session, final @Mocked ResourceSnapshotResolver resolver, final @Mocked ResourceSnapshot snapshot) throws Exception {
        SnapshotResolver sut = this.buildResolver(session, resolver);
        sut.toURI(snapshot);
        new Verifications(){
            {
                resolver.resolve(snapshot);
            }
        };
    }

    @Test(expected=NullPointerException.class)
    public void testBuilder$nullSession() {
        SnapshotResolver.builder().withReadSession(null).withCanonicalBase(CANONICAL_BASE).build();
    }

    @Test(expected=NullPointerException.class)
    public void testBuilder$nullCanonicalBase(@Mocked ReadSession session) {
        SnapshotResolver.builder().withReadSession(session).withCanonicalBase(null).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuilder$nonHierarchicalCanonicalBase(@Mocked ReadSession session) {
        SnapshotResolver.builder().withReadSession(session).withCanonicalBase(NON_HIERARCHICAL_CANONICAL_BASE).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuilder$nonAbsoluteCanonicalBase(@Mocked ReadSession session) {
        SnapshotResolver.builder().withReadSession(session).withCanonicalBase(NON_ABSOLUTE_CANONICAL_BASE).build();
    }

    @Test
    public void testBuilder$validBase(@Mocked ReadSession session, @Mocked ResourceSnapshotResolver resolver) {
        this.buildResolver(session, resolver);
    }

    private SnapshotResolver buildResolver(ReadSession session, ResourceSnapshotResolver resolver) {
        RuntimeDelegate.setInstance((RuntimeDelegate)new MockedRuntimeDelegate(resolver));
        SnapshotResolver result = SnapshotResolver.builder().withReadSession(session).withCanonicalBase(CANONICAL_BASE).build();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)Deencapsulation.getField((Object)result, (String)"resolver"), (Matcher)Matchers.sameInstance((Object)resolver));
        return result;
    }

    private final class MockedRuntimeDelegate
    extends RuntimeDelegate {
        private final ResourceSnapshotResolver resolver;

        private MockedRuntimeDelegate(ResourceSnapshotResolver resolver) {
            this.resolver = resolver;
        }

        public boolean isOffline() {
            return false;
        }

        public WriteSession createSession() throws ApplicationContextException {
            return null;
        }

        public ResourceSnapshotResolver createResourceResolver(URI canonicalBase, ReadSession session) {
            return this.resolver;
        }

        public void registerShutdownListener(ShutdownListener listener) {
        }
    }
}

