/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import mockit.Deencapsulation;
import mockit.Mock;
import mockit.MockUp;
import mockit.Mocked;
import mockit.Verifications;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ldp4j.application.ApplicationContext;
import org.ldp4j.application.ContextWriteSession;
import org.ldp4j.application.WriteSessionCleaner;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.spi.RuntimeDelegate;
import org.ldp4j.application.spi.ShutdownListener;

@RunWith(value=JMockit.class)
public class ApplicationContextExtendedTest {
    @Mocked
    WriteSession nativeSession;

    @Test
    public void testTerminatesWriteCleaner() throws Exception {
        final AtomicBoolean launched = new AtomicBoolean();
        final AtomicBoolean terminated = new AtomicBoolean();
        final AtomicReference listener = new AtomicReference();
        new MockUp<WriteSessionCleaner>(){

            @Mock
            void launch(ReferenceQueue<ContextWriteSession> queue) {
                MatcherAssert.assertThat(queue, (Matcher)Matchers.notNullValue());
                launched.set(true);
            }

            @Mock
            void terminate() {
                terminated.set(true);
            }

            @Mock
            boolean isActive() {
                return false;
            }
        };
        RuntimeDelegate delegate = (RuntimeDelegate)new MockUp<RuntimeDelegate>(){

            @Mock
            WriteSession createSession() {
                return ApplicationContextExtendedTest.this.nativeSession;
            }

            @Mock
            boolean isOffline() {
                return false;
            }

            @Mock
            void registerShutdownListener(ShutdownListener aListener) {
                listener.set(aListener);
            }
        }.getMockInstance();
        ApplicationContext sut = this.setUpContext(delegate);
        WriteSession session = sut.createSession();
        MatcherAssert.assertThat((Object)session, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)launched.get(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat(listener.get(), (Matcher)Matchers.notNullValue());
        session.close();
        ((ShutdownListener)listener.get()).engineShutdown();
        MatcherAssert.assertThat((Object)launched.get(), (Matcher)Matchers.equalTo((Object)true));
        new Verifications(){
            {
                ApplicationContextExtendedTest.this.nativeSession.close();
                this.maxTimes = 1;
                this.minTimes = 1;
            }
        };
    }

    private ApplicationContext setUpContext(RuntimeDelegate delegate) {
        ApplicationContext sut = ApplicationContext.getInstance();
        Deencapsulation.setField((Object)sut, (String)"delegate", (Object)delegate);
        return sut;
    }
}

