/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.ldp4j.application.data.ExternalIndividual;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.IndividualVisitor;
import org.ldp4j.application.data.Literal;
import org.ldp4j.application.data.LocalIndividual;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.MutableDataSet;
import org.ldp4j.application.data.NewIndividual;
import org.ldp4j.application.data.Properties;
import org.ldp4j.application.data.Property;
import org.ldp4j.application.data.RelativeIndividual;
import org.ldp4j.application.data.Value;
import org.ldp4j.application.data.ValueVisitor;

final class MutableProperty
implements Property {
    private final URI predicate;
    private final Individual<?, ?> individual;
    private final Set<Value> values;
    private final MutableDataSet dataSet;

    MutableProperty(Individual<?, ?> individual, MutableDataSet dataSet, URI predicate) {
        this.individual = individual;
        this.dataSet = dataSet;
        this.predicate = predicate;
        this.values = new CopyOnWriteArraySet<Value>();
    }

    MutableProperty(MutableProperty property) {
        this(property.individual, property.dataSet, property.predicate);
        this.values.addAll(property.values());
    }

    void addValue(Value value) {
        value.accept(new ValueAdder());
    }

    void removeValue(Value value) {
        this.values.remove(value);
    }

    private void addLiteral(Literal<?> value) {
        this.values.add(value);
    }

    private MutableDataSet dataSet() {
        return this.dataSet;
    }

    private void addIndividual(Individual<?, ?> value) {
        Individual<Object, Object> target = null;
        target = this.dataSet().hasIndividual(value.id()) ? (this.dataSet().equals(value.dataSet()) ? value : this.dataSet().individualOfId(value.id())) : this.addIndividualToDataset(value);
        if (target != value) {
            this.mergeIndividuals(value, target);
        }
        this.values.add(target);
    }

    private Individual<?, ?> addIndividualToDataset(Individual<?, ?> value) {
        IndividualTranslator translator = new IndividualTranslator();
        value.accept(translator);
        return translator.getIndividual();
    }

    private void mergeIndividuals(Individual<?, ?> source, Individual<?, ?> target) {
        for (Property property : source.properties()) {
            for (Value value : property) {
                target.addValue(property.predicate(), value);
            }
        }
    }

    @Override
    public Individual<?, ?> individual() {
        return this.individual;
    }

    @Override
    public URI predicate() {
        return this.predicate;
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values().iterator();
    }

    public Collection<Value> values() {
        return new ArrayList<Value>(this.values);
    }

    @Override
    public int numberOfValues() {
        return this.values.size();
    }

    @Override
    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    @Override
    public void accept(ValueVisitor visitor) {
        for (Value value : this.values()) {
            value.accept(visitor);
        }
    }

    @Override
    public boolean hasLiteralValue(Literal<?> value) {
        return Properties.hasLiteral(this, value);
    }

    @Override
    public boolean hasIdentifiedIndividual(Object id) {
        return Properties.hasIdentifiedIndividual(this, id);
    }

    private final class IndividualTranslator
    implements IndividualVisitor {
        private Individual<?, ?> newIndividual = null;

        private IndividualTranslator() {
        }

        private Individual<?, ?> getIndividual() {
            return this.newIndividual;
        }

        @Override
        public void visitManagedIndividual(ManagedIndividual individual) {
            this.newIndividual = MutableProperty.this.dataSet().individual(individual.id(), ManagedIndividual.class);
        }

        @Override
        public void visitLocalIndividual(LocalIndividual individual) {
            this.newIndividual = MutableProperty.this.dataSet().individual(individual.id(), LocalIndividual.class);
        }

        @Override
        public void visitExternalIndividual(ExternalIndividual individual) {
            this.newIndividual = MutableProperty.this.dataSet().individual(individual.id(), ExternalIndividual.class);
        }

        @Override
        public void visitRelativeIndividual(RelativeIndividual individual) {
            this.newIndividual = MutableProperty.this.dataSet().individual(individual.id(), RelativeIndividual.class);
        }

        @Override
        public void visitNewIndividual(NewIndividual individual) {
            this.newIndividual = MutableProperty.this.dataSet().individual(individual.id(), NewIndividual.class);
        }
    }

    private final class ValueAdder
    implements ValueVisitor {
        private ValueAdder() {
        }

        @Override
        public void visitLiteral(Literal<?> value) {
            MutableProperty.this.addLiteral(value);
        }

        @Override
        public void visitIndividual(Individual<?, ?> value) {
            MutableProperty.this.addIndividual(value);
        }
    }
}

