/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.ldp4j.application.data.AbstractMutableIndividual;
import org.ldp4j.application.data.IndividualVisitor;
import org.ldp4j.application.data.MutableDataSet;
import org.ldp4j.application.data.NewIndividual;
import org.ldp4j.application.data.Value;

final class MutableNewIndividual
extends AbstractMutableIndividual<URI, NewIndividual>
implements NewIndividual {
    MutableNewIndividual(URI id, MutableDataSet context) {
        super(id, context);
        Preconditions.checkArgument((!id.isAbsolute() ? 1 : 0) != 0, (Object)"New individual URIs must be relative");
    }

    @Override
    public URI path() {
        return (URI)super.id();
    }

    @Override
    public NewIndividual addValue(URI propertyId, Value value) {
        super.addPropertyValue(propertyId, value);
        return this;
    }

    @Override
    public NewIndividual removeValue(URI propertyId, Value value) {
        super.removePropertyValue(propertyId, value);
        return this;
    }

    @Override
    public void accept(IndividualVisitor visitor) {
        visitor.visitNewIndividual(this);
    }
}

