/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.ISOPeriodFormat;
import org.ldp4j.application.data.DatatypeCohercionException;
import org.ldp4j.application.data.Datatypes;
import org.ldp4j.application.data.DateTimeLiteral;
import org.ldp4j.application.data.DurationLiteral;
import org.ldp4j.application.data.ImmutableDateTimeLiteral;
import org.ldp4j.application.data.ImmutableDurationLiteral;
import org.ldp4j.application.data.ImmutableLanguageLiteral;
import org.ldp4j.application.data.ImmutableLiteral;
import org.ldp4j.application.data.ImmutableTypedLiteral;
import org.ldp4j.application.data.LanguageLiteral;
import org.ldp4j.application.data.Literal;
import org.ldp4j.application.data.TypedLiteral;

public final class Literals {
    private static final ImmutableMap<Class<?>, DateTimeLiteralBuilderFactory> FACTORIES = ImmutableMap.builder().put(java.util.Date.class, (Object)new DateTimeLiteralBuilderFactory(){

        @Override
        public DateTimeLiteralBuilder createBuilder(Object value, URI datatype) {
            return Literals.of((java.util.Date)value);
        }
    }).put(GregorianCalendar.class, (Object)new DateTimeLiteralBuilderFactory(){

        @Override
        public DateTimeLiteralBuilder createBuilder(Object value, URI datatype) {
            return Literals.of((GregorianCalendar)value);
        }
    }).put(Calendar.class, (Object)new DateTimeLiteralBuilderFactory(){

        @Override
        public DateTimeLiteralBuilder createBuilder(Object value, URI datatype) {
            return Literals.of((Calendar)value);
        }
    }).put(DateTime.class, (Object)new DateTimeLiteralBuilderFactory(){

        @Override
        public DateTimeLiteralBuilder createBuilder(Object value, URI datatype) {
            return Literals.of((DateTime)value);
        }
    }).put(XMLGregorianCalendar.class, (Object)new DateTimeLiteralBuilderFactory(){

        @Override
        public DateTimeLiteralBuilder createBuilder(Object value, URI datatype) {
            return Literals.of((XMLGregorianCalendar)value);
        }
    }).put(String.class, (Object)new DateTimeLiteralBuilderFactory(){

        @Override
        public DateTimeLiteralBuilder createBuilder(Object value, URI datatype) {
            try {
                return Literals.of(new DateTime(value));
            }
            catch (Exception e) {
                throw new DatatypeCohercionException(value, datatype, e);
            }
        }
    }).build();
    private static final ImmutableMap<URI, DateTimeLiteralBuilderAdapter> ADAPTERS = ImmutableMap.builder().put((Object)Datatypes.DATE_TIME, (Object)new DateTimeLiteralBuilderAdapter(){

        @Override
        public DateTimeLiteral adapt(DateTimeLiteralBuilder builder) {
            return builder.dateTime();
        }
    }).put((Object)Datatypes.DATE, (Object)new DateTimeLiteralBuilderAdapter(){

        @Override
        public DateTimeLiteral adapt(DateTimeLiteralBuilder builder) {
            return builder.date();
        }
    }).put((Object)Datatypes.TIME, (Object)new DateTimeLiteralBuilderAdapter(){

        @Override
        public DateTimeLiteral adapt(DateTimeLiteralBuilder builder) {
            return builder.time();
        }
    }).put((Object)Datatypes.GYEAR, (Object)new DateTimeLiteralBuilderAdapter(){

        @Override
        public DateTimeLiteral adapt(DateTimeLiteralBuilder builder) {
            return builder.year();
        }
    }).put((Object)Datatypes.GMONTH, (Object)new DateTimeLiteralBuilderAdapter(){

        @Override
        public DateTimeLiteral adapt(DateTimeLiteralBuilder builder) {
            return builder.month();
        }
    }).put((Object)Datatypes.GDAY, (Object)new DateTimeLiteralBuilderAdapter(){

        @Override
        public DateTimeLiteral adapt(DateTimeLiteralBuilder builder) {
            return builder.day();
        }
    }).put((Object)Datatypes.GYEARMONTH, (Object)new DateTimeLiteralBuilderAdapter(){

        @Override
        public DateTimeLiteral adapt(DateTimeLiteralBuilder builder) {
            return builder.yearAndMonth();
        }
    }).put((Object)Datatypes.GMONTHDAY, (Object)new DateTimeLiteralBuilderAdapter(){

        @Override
        public DateTimeLiteral adapt(DateTimeLiteralBuilder builder) {
            return builder.monthAndDay();
        }
    }).build();
    private static final String DATATYPE_CANNOT_BE_NULL = "Datatype cannot be null";
    private static final String LANGUAGE_CANNOT_BE_NULL = "Language cannot be null";
    private static final String STRING_CANNOT_BE_NULL = "String cannot be null";
    private static final String TIME_UNIT_CANNOT_BE_NULL = "Time unit cannot be null";
    private static final String DATE_TIME_CANNOT_BE_NULL = "Date-time cannot be null";
    private static final String LITERAL_VALUE_CANNOT_BE_NULL = "Literal value cannot be null";
    private static final String CALENDAR_CANNOT_BE_NULL = "Calendar cannot be null";
    private static final String TIME_CANNOT_BE_NULL = "Time cannot be null";
    private static final String DATE_CANNOT_BE_NULL = "Date cannot be null";
    private static final String DURATION_CANNOT_BE_NULL = "Duration cannot be null";
    private static final Class<?>[] DATE_TIME_CLASSES = new Class[]{Date.class, java.util.Date.class, Time.class, DateTime.class, GregorianCalendar.class, Calendar.class, XMLGregorianCalendar.class};
    private static final Class<?>[] DURATION_CLASSES = new Class[]{Duration.class, javax.xml.datatype.Duration.class};

    private Literals() {
    }

    private static boolean isDateTime(Object obj) {
        return Literals.isInstanceOf(obj, DATE_TIME_CLASSES);
    }

    private static boolean isDuration(Object obj) {
        return Literals.isInstanceOf(obj, DURATION_CLASSES);
    }

    private static boolean isInstanceOf(Object obj, Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    private static DateTime normalizeChronology(DateTime dateTime) {
        return dateTime.withChronology((Chronology)ISOChronology.getInstance());
    }

    private static <T> DurationLiteral coherceDuration(T value) {
        DurationLiteral duration = null;
        if (value instanceof Duration) {
            duration = Literals.of((Duration)value);
        } else if (value instanceof javax.xml.datatype.Duration) {
            duration = Literals.of((javax.xml.datatype.Duration)value);
        } else if (value instanceof String) {
            try {
                Period period = ISOPeriodFormat.standard().parsePeriod((String)value);
                duration = Literals.of(period.toStandardDuration());
            }
            catch (Exception e) {
                throw new DatatypeCohercionException(value, Datatypes.DURATION, e);
            }
        } else {
            throw new DatatypeCohercionException(value, Datatypes.DURATION);
        }
        return duration;
    }

    private static DateTimeLiteral coherceDateTime(Object value, URI datatype) throws AssertionError {
        DateTimeLiteral dateTime = null;
        dateTime = value instanceof Date ? Literals.of((Date)value) : (value instanceof Time ? Literals.of((Time)value) : Literals.coherceVariableDateTime(value, datatype));
        return dateTime;
    }

    private static DateTimeLiteral coherceVariableDateTime(Object value, URI datatype) {
        return ((DateTimeLiteralBuilderAdapter)ADAPTERS.get((Object)datatype)).adapt(Literals.getBuilder(value, datatype));
    }

    private static DateTimeLiteralBuilder getBuilder(Object value, URI datatype) {
        for (Map.Entry entry : FACTORIES.entrySet()) {
            if (!((Class)entry.getKey()).isInstance(value)) continue;
            return ((DateTimeLiteralBuilderFactory)entry.getValue()).createBuilder(value, datatype);
        }
        throw new DatatypeCohercionException(value, datatype);
    }

    public static Literal<String> of(String value) {
        Preconditions.checkNotNull((Object)value, (Object)STRING_CANNOT_BE_NULL);
        return new ImmutableLiteral<String>(value);
    }

    public static DurationLiteral of(javax.xml.datatype.Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)DURATION_CANNOT_BE_NULL);
        Period period = ISOPeriodFormat.standard().parsePeriod(duration.toString());
        return new ImmutableDurationLiteral(period.toStandardDuration(), Datatypes.DURATION);
    }

    public static DurationLiteral of(Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)DURATION_CANNOT_BE_NULL);
        return new ImmutableDurationLiteral(duration, Datatypes.DURATION);
    }

    public static DateTimeDateTimeLiteralBuilder of(java.util.Date date) {
        Preconditions.checkNotNull((Object)date, (Object)DATE_CANNOT_BE_NULL);
        return new DateTimeDateTimeLiteralBuilder(new DateTime((Object)date));
    }

    public static DateTimeLiteral of(Date date) {
        Preconditions.checkNotNull((Object)date, (Object)DATE_CANNOT_BE_NULL);
        return new ImmutableDateTimeLiteral(new DateTime((Object)date), Datatypes.DATE);
    }

    public static DateTimeLiteral of(Time time) {
        Preconditions.checkNotNull((Object)time, (Object)TIME_CANNOT_BE_NULL);
        return new ImmutableDateTimeLiteral(new DateTime(time.getTime()), Datatypes.TIME);
    }

    public static DateTimeDateTimeLiteralBuilder of(Calendar calendar) {
        Preconditions.checkNotNull((Object)calendar, (Object)CALENDAR_CANNOT_BE_NULL);
        return new DateTimeDateTimeLiteralBuilder(Literals.normalizeChronology(new DateTime((Object)calendar)));
    }

    public static DateTimeDateTimeLiteralBuilder of(GregorianCalendar calendar) {
        Preconditions.checkNotNull((Object)calendar, (Object)CALENDAR_CANNOT_BE_NULL);
        return new DateTimeDateTimeLiteralBuilder(Literals.normalizeChronology(new DateTime((Object)calendar)));
    }

    public static XMLGregorianCalendarDateTimeLiteralBuilder of(XMLGregorianCalendar calendar) {
        Preconditions.checkNotNull((Object)calendar, (Object)CALENDAR_CANNOT_BE_NULL);
        return new XMLGregorianCalendarDateTimeLiteralBuilder(calendar);
    }

    public static DateTimeDateTimeLiteralBuilder of(DateTime dateTime) {
        Preconditions.checkNotNull((Object)dateTime, (Object)DATE_TIME_CANNOT_BE_NULL);
        return new DateTimeDateTimeLiteralBuilder(dateTime);
    }

    public static DurationLiteral duration(long time, TimeUnit unit) {
        Preconditions.checkNotNull((Object)time, (Object)TIME_CANNOT_BE_NULL);
        Preconditions.checkNotNull((Object)((Object)unit), (Object)TIME_UNIT_CANNOT_BE_NULL);
        return Literals.of(new Duration(TimeUnit.MILLISECONDS.convert(time, unit)));
    }

    public static Literal<? extends Serializable> newLiteral(Object value) {
        Preconditions.checkNotNull((Object)value, (Object)LITERAL_VALUE_CANNOT_BE_NULL);
        Literal<Duration> result = null;
        result = Literals.isDuration(value) ? Literals.coherceDuration(value) : (Literals.isDateTime(value) ? Literals.coherceDateTime(value, Datatypes.DATE_TIME) : (value instanceof Serializable ? new ImmutableLiteral<Serializable>((Serializable)value) : new ImmutableTypedLiteral<String>(value.toString(), Datatypes.STRING)));
        return result;
    }

    public static TypedLiteral<? extends Serializable> newTypedLiteral(Object value, URI datatype) {
        Preconditions.checkNotNull((Object)value, (Object)LITERAL_VALUE_CANNOT_BE_NULL);
        Preconditions.checkNotNull((Object)datatype, (Object)DATATYPE_CANNOT_BE_NULL);
        TypedLiteral<Duration> result = null;
        result = Datatypes.isDuration(datatype) ? Literals.coherceDuration(value) : (Datatypes.isTemporal(datatype) ? Literals.coherceDateTime(value, datatype) : (value instanceof Serializable ? new ImmutableTypedLiteral<Serializable>((Serializable)value, datatype) : new ImmutableTypedLiteral<String>(value.toString(), Datatypes.STRING)));
        return result;
    }

    public static LanguageLiteral newLanguageLiteral(String value, String language) {
        Preconditions.checkNotNull((Object)value, (Object)STRING_CANNOT_BE_NULL);
        Preconditions.checkNotNull((Object)language, (Object)LANGUAGE_CANNOT_BE_NULL);
        return new ImmutableLanguageLiteral(value, language);
    }

    private static interface DateTimeLiteralBuilderAdapter {
        public DateTimeLiteral adapt(DateTimeLiteralBuilder var1);
    }

    private static interface DateTimeLiteralBuilderFactory {
        public DateTimeLiteralBuilder createBuilder(Object var1, URI var2);
    }

    public static final class XMLGregorianCalendarDateTimeLiteralBuilder
    extends DateTimeLiteralBuilder {
        private final XMLGregorianCalendar calendar;
        private TimeZone timezone;
        private Locale locale;
        private XMLGregorianCalendar defaults;

        private XMLGregorianCalendarDateTimeLiteralBuilder(XMLGregorianCalendar calendar) {
            this.calendar = calendar;
        }

        public XMLGregorianCalendarDateTimeLiteralBuilder withTimeZone(TimeZone timezone) {
            this.timezone = timezone;
            return this;
        }

        public XMLGregorianCalendarDateTimeLiteralBuilder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public XMLGregorianCalendarDateTimeLiteralBuilder withDefaults(XMLGregorianCalendar defaults) {
            this.defaults = defaults;
            return this;
        }

        @Override
        protected DateTime getDateTime() {
            return Literals.normalizeChronology(new DateTime((Object)this.calendar.toGregorianCalendar(this.timezone, this.locale, this.defaults)));
        }
    }

    public static final class DateTimeDateTimeLiteralBuilder
    extends DateTimeLiteralBuilder {
        private final DateTime dateTime;

        private DateTimeDateTimeLiteralBuilder(DateTime dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        protected DateTime getDateTime() {
            return this.dateTime;
        }
    }

    public static abstract class DateTimeLiteralBuilder {
        private DateTimeLiteralBuilder() {
        }

        public final DateTimeLiteral dateTime() {
            return new ImmutableDateTimeLiteral(this.getDateTime(), Datatypes.DATE_TIME);
        }

        public final DateTimeLiteral date() {
            return new ImmutableDateTimeLiteral(this.getDateTime(), Datatypes.DATE);
        }

        public final DateTimeLiteral time() {
            return new ImmutableDateTimeLiteral(this.getDateTime(), Datatypes.TIME);
        }

        public final DateTimeLiteral year() {
            return new ImmutableDateTimeLiteral(this.getDateTime(), Datatypes.GYEAR);
        }

        public final DateTimeLiteral month() {
            return new ImmutableDateTimeLiteral(this.getDateTime(), Datatypes.GMONTH);
        }

        public final DateTimeLiteral day() {
            return new ImmutableDateTimeLiteral(this.getDateTime(), Datatypes.GDAY);
        }

        public final DateTimeLiteral yearAndMonth() {
            return new ImmutableDateTimeLiteral(this.getDateTime(), Datatypes.GYEARMONTH);
        }

        public final DateTimeLiteral monthAndDay() {
            return new ImmutableDateTimeLiteral(this.getDateTime(), Datatypes.GMONTHDAY);
        }

        protected abstract DateTime getDateTime();
    }
}

