/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.ldp4j.application.data.ExternalIndividual;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.LocalIndividual;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.MutableDataSet;
import org.ldp4j.application.data.MutableExternalIndividual;
import org.ldp4j.application.data.MutableLocalIndividual;
import org.ldp4j.application.data.MutableManagedIndividual;
import org.ldp4j.application.data.MutableNewIndividual;
import org.ldp4j.application.data.MutableRelativeIndividual;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NewIndividual;
import org.ldp4j.application.data.RelativeIndividual;
import org.ldp4j.application.data.RelativeIndividualId;

final class IndividualFactory {
    private static final Map<Class<? extends Individual<?, ?>>, Factory<?>> FACTORIES = ImmutableMap.builder().put(LocalIndividual.class, (Object)new Factory<MutableLocalIndividual>(){

        @Override
        public Class<?> idClass() {
            return Name.class;
        }

        @Override
        public MutableLocalIndividual newIndividual(Object id, MutableDataSet context) {
            return new MutableLocalIndividual((Name)id, context);
        }
    }).put(ManagedIndividual.class, (Object)new SimpleFactory<ManagedIndividualId, MutableManagedIndividual>(ManagedIndividualId.class){

        @Override
        protected MutableManagedIndividual createIndividual(ManagedIndividualId id, MutableDataSet context) {
            return new MutableManagedIndividual(id, context);
        }
    }).put(RelativeIndividual.class, (Object)new SimpleFactory<RelativeIndividualId, MutableRelativeIndividual>(RelativeIndividualId.class){

        @Override
        protected MutableRelativeIndividual createIndividual(RelativeIndividualId id, MutableDataSet context) {
            return new MutableRelativeIndividual(id, context);
        }
    }).put(ExternalIndividual.class, (Object)new SimpleFactory<URI, MutableExternalIndividual>(URI.class){

        @Override
        protected MutableExternalIndividual createIndividual(URI id, MutableDataSet context) {
            return new MutableExternalIndividual(id, context);
        }
    }).put(NewIndividual.class, (Object)new SimpleFactory<URI, MutableNewIndividual>(URI.class){

        @Override
        protected MutableNewIndividual createIndividual(URI id, MutableDataSet context) {
            return new MutableNewIndividual(id, context);
        }
    }).build();
    private final MutableDataSet dataSet;

    IndividualFactory(MutableDataSet dataSet) {
        this.dataSet = dataSet;
    }

    <T extends Serializable, S extends Individual<T, S>> Individual<T, S> newIndividual(Class<? extends S> clazz, T id) {
        Factory<?> factory = FACTORIES.get(clazz);
        if (factory == null) {
            throw new IllegalStateException("Unsupported individual type '" + clazz.getCanonicalName() + "'");
        }
        Class<?> idClass = factory.idClass();
        if (!idClass.isInstance(id)) {
            throw new IllegalStateException("Could not create an individual of type '" + clazz.getCanonicalName() + "' with identifier '" + id + "'. Expected an identifier of type '" + idClass.getCanonicalName() + "' not '" + id.getClass().getCanonicalName() + "'");
        }
        return (Individual)clazz.cast(factory.newIndividual(id, this.dataSet));
    }

    private static abstract class SimpleFactory<S, T extends Individual<?, ?>>
    implements Factory<T> {
        private final Class<? extends S> clazz;

        private SimpleFactory(Class<? extends S> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Class<? extends S> idClass() {
            return this.clazz;
        }

        @Override
        public T newIndividual(Object id, MutableDataSet context) {
            return this.createIndividual(this.idClass().cast(id), context);
        }

        protected abstract T createIndividual(S var1, MutableDataSet var2);
    }

    private static interface Factory<T extends Individual<?, ?>> {
        public Class<?> idClass();

        public T newIndividual(Object var1, MutableDataSet var2);
    }
}

