/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import java.net.URI;
import javax.xml.namespace.QName;
import org.ldp4j.application.vocabulary.AbstractImmutableVocabulary;
import org.ldp4j.application.vocabulary.ImmutableTerm;
import org.ldp4j.application.vocabulary.Term;

public final class RDFS
extends AbstractImmutableVocabulary<ImmutableTerm> {
    private static final long serialVersionUID = 1083533867342570283L;
    public static final String NAMESPACE = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String NS_PREFIX = "rdfs";
    public static final Term SUB_CLASS_OF;
    public static final Term SUB_PROPERTY_OF;
    public static final Term DOMAIN;
    public static final Term RANGE;
    public static final Term LABEL;
    public static final Term COMMENT;
    public static final Term MEMBER;
    public static final Term SEE_ALSO;
    public static final Term IS_DEFINED_BY;
    public static final Term RESOURCE;
    public static final Term LITERAL;
    public static final Term CLASS;
    public static final Term DATATYPE;
    public static final Term CONTAINER;
    public static final Term CONTAINER_MEMBERSHIP_PROPERTY;
    private static final RDFS VOCABULARY;

    private RDFS() {
        super(ImmutableTerm.class, NAMESPACE, NS_PREFIX);
    }

    private static Term term(String localPart) {
        return new ImmutableTerm(VOCABULARY, localPart);
    }

    public static RDFS getInstance() {
        return VOCABULARY;
    }

    public static Term[] values() {
        return RDFS.getInstance().terms();
    }

    public static Term valueOf(String term) {
        return RDFS.getInstance().fromValue(term);
    }

    public static Term valueOf(QName term) {
        return RDFS.getInstance().fromValue(term);
    }

    public static Term valueOf(URI term) {
        return RDFS.getInstance().fromValue(term);
    }

    static {
        VOCABULARY = new RDFS();
        SUB_CLASS_OF = RDFS.term("subClassOf");
        SUB_PROPERTY_OF = RDFS.term("subPropertyOf");
        DOMAIN = RDFS.term("domain");
        RANGE = RDFS.term("range");
        LABEL = RDFS.term("label");
        COMMENT = RDFS.term("comment");
        MEMBER = RDFS.term("member");
        SEE_ALSO = RDFS.term("seeAlso");
        IS_DEFINED_BY = RDFS.term("isDefinedBy");
        RESOURCE = RDFS.term("Resource");
        LITERAL = RDFS.term("Literal");
        CLASS = RDFS.term("Class");
        DATATYPE = RDFS.term("Datatype");
        CONTAINER = RDFS.term("Container");
        CONTAINER_MEMBERSHIP_PROPERTY = RDFS.term("ContainerMembershipProperty");
        VOCABULARY.initialize();
    }
}

