/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class AdapterMethodValidator {
    private final Class<?> returnType;
    private final TypeValidator parameterValidator;

    private AdapterMethodValidator(Class<?> returnType, TypeValidator parameterValidator) {
        this.parameterValidator = parameterValidator;
        this.returnType = returnType;
    }

    boolean isValid(Method method) {
        return "adaptTo".equals(method.getName()) && this.hasValidSignature(method) && this.isVisible(method);
    }

    Class<?> getTargetClass() {
        return this.parameterValidator.getTargetClass();
    }

    private boolean hasValidSignature(Method method) {
        return this.returnType.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 1 && this.parameterValidator.isValid(method.getParameterTypes()[0]);
    }

    private boolean isVisible(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers);
    }

    static AdapterMethodValidator newInstance(Class<?> returnType, Class<?> parameterType) {
        return new AdapterMethodValidator(returnType, new SubclassTypeValidator(parameterType));
    }

    static AdapterMethodValidator newInstance(Class<?> returnType, Object value) {
        return new AdapterMethodValidator(returnType, new InstanceTypeValidator(value));
    }

    private static final class InstanceTypeValidator
    implements TypeValidator {
        private final Object instance;

        private InstanceTypeValidator(Object term) {
            this.instance = term;
        }

        @Override
        public boolean isValid(Class<?> parameterType) {
            return parameterType.isInstance(this.instance);
        }

        @Override
        public Class<?> getTargetClass() {
            return this.instance.getClass();
        }
    }

    private static final class SubclassTypeValidator
    implements TypeValidator {
        private final Class<?> subClass;

        private SubclassTypeValidator(Class<?> termClass) {
            this.subClass = termClass;
        }

        @Override
        public boolean isValid(Class<?> parameterType) {
            return parameterType.isAssignableFrom(this.subClass);
        }

        @Override
        public Class<?> getTargetClass() {
            return this.subClass;
        }
    }

    private static interface TypeValidator {
        public boolean isValid(Class<?> var1);

        public Class<?> getTargetClass();
    }
}

