/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.cache.Cache;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.Info;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.guava.cache.CacheMetricsCollector;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.util.Objects;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.server.HTTPServerConfig;

public class ServerMetricsCollector {
    public static final String UNKNOWN = "unknown";
    private static final double[] LATENCY_BUCKETS = new double[]{0.025, 0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 2.0, 4.0, 6.0, 8.0, 10.0, 15.0};
    private static final double[] SIZE_BUCKETS = new double[]{25.0, 100.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0, 20000.0, 40000.0};
    private static final double[] SPEED_BUCKETS = new double[]{10.0, 100.0, 500.0, 1000.0, 2500.0, 5000.0, 7500.0, 10000.0, 20000.0, 50000.0};
    private static final ServerMetricsCollector collector = new ServerMetricsCollector();
    private static HTTPServer server;
    private final Counter matchCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_check_matches_total", (String)"Total amount of rule matches").labelNames(new String[]{"language", "mode"})).register();
    private final Counter checkCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_checks_total", (String)"Total text checks").labelNames(new String[]{"language", "mode"})).register();
    private final Counter charactersCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_characters_total", (String)"Total processed characters").labelNames(new String[]{"language", "mode"})).register();
    private final Counter computationTimeCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_computation_time_seconds_total", (String)"Total computation time, in seconds").labelNames(new String[]{"language", "mode"})).register();
    private final Histogram checkLatency = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_check_latency_seconds", (String)"Histogram of check times").buckets(LATENCY_BUCKETS).labelNames(new String[]{"language", "mode"})).register();
    private final Histogram checkSize = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_check_size_characters", (String)"Histogram of check sizes").buckets(SIZE_BUCKETS).labelNames(new String[]{"language", "mode"})).register();
    private final Histogram checkSpeed = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_check_speed_chars_per_second", (String)"Histogram of relative check speed").buckets(SPEED_BUCKETS).labelNames(new String[]{"language", "mode"})).register();
    private final Counter requestErrorCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_request_errors_total", (String)"Various request errors").labelNames(new String[]{"reason"})).register();
    private final Counter httpRequestCounter = (Counter)Counter.build((String)"languagetool_http_requests_total", (String)"Received HTTP requests").register();
    private final Counter httpResponseCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_http_responses_total", (String)"HTTP responses by code").labelNames(new String[]{"code"})).register();
    private final Counter failedHealthcheckCounter = (Counter)Counter.build((String)"languagetool_failed_healthchecks_total", (String)"Failed healthchecks").register();
    private final Info buildInfo = (Info)Info.build((String)"languagetool_build", (String)"Build information").register();
    private final Gauge configValues = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_configuration_values", (String)"Configuration settings").labelNames(new String[]{"name"})).register();
    private final CacheMetricsCollector cacheMetrics = (CacheMetricsCollector)new CacheMetricsCollector().register();

    public static void init(HTTPServerConfig config) throws IOException {
        DefaultExports.initialize();
        server = new HTTPServer(config.getPrometheusPort(), true);
        Gauge c = ServerMetricsCollector.getInstance().configValues;
        ServerMetricsCollector.exposeConfigurationValues(config, c);
    }

    private static void exposeConfigurationValues(HTTPServerConfig config, Gauge c) {
        ((Gauge.Child)c.labels(new String[]{"maxCheckThreads"})).set((double)config.getMaxCheckThreads());
        ((Gauge.Child)c.labels(new String[]{"maxWorkQueueSize"})).set((double)config.getMaxWorkQueueSize());
        ((Gauge.Child)c.labels(new String[]{"cacheSize"})).set((double)config.getCacheSize());
        ((Gauge.Child)c.labels(new String[]{"cacheTTLSeconds"})).set((double)config.getCacheTTLSeconds());
        ((Gauge.Child)c.labels(new String[]{"maxCheckTimeMillisAnonymous"})).set((double)config.getMaxCheckTimeMillisAnonymous());
        ((Gauge.Child)c.labels(new String[]{"maxCheckTimeMillisLoggedIn"})).set((double)config.getMaxCheckTimeMillisLoggedIn());
        ((Gauge.Child)c.labels(new String[]{"maxCheckTimeMillisPremium"})).set((double)config.getMaxCheckTimeMillisPremium());
        ((Gauge.Child)c.labels(new String[]{"maxTextLengthAnonymous"})).set((double)config.getMaxTextLengthAnonymous());
        ((Gauge.Child)c.labels(new String[]{"maxTextLengthLoggedIn"})).set((double)config.getMaxTextLengthLoggedIn());
        ((Gauge.Child)c.labels(new String[]{"maxTextLengthPremium"})).set((double)config.getMaxTextLengthPremium());
    }

    public static void stop() {
        server.stop();
    }

    public static ServerMetricsCollector getInstance() {
        return collector;
    }

    public ServerMetricsCollector() {
        this.buildInfo.info(new String[]{"version", Objects.toString("5.6"), "buildDate", Objects.toString(JLanguageTool.BUILD_DATE), "revision", Objects.toString(JLanguageTool.GIT_SHORT_ID), "premium", Objects.toString(String.valueOf(Premium.isPremiumVersion()))});
    }

    public void monitorCache(String name, Cache cache) {
        this.cacheMetrics.addCache(name, cache);
    }

    public void logCheck(Language language, long milliseconds, int textSize, int matchCount, JLanguageTool.Mode mode) {
        String langLabel = language != null ? language.getShortCode() : UNKNOWN;
        String modeLabel = mode != null ? mode.name() : UNKNOWN;
        ((Counter.Child)this.checkCounter.labels(new String[]{langLabel, modeLabel})).inc();
        ((Counter.Child)this.matchCounter.labels(new String[]{langLabel, modeLabel})).inc((double)matchCount);
        ((Counter.Child)this.charactersCounter.labels(new String[]{langLabel, modeLabel})).inc((double)textSize);
        ((Histogram.Child)this.checkSize.labels(new String[]{langLabel, ""})).observe((double)textSize);
        ((Histogram.Child)this.checkSize.labels(new String[]{"", modeLabel})).observe((double)textSize);
        double seconds = (double)milliseconds / 1000.0;
        ((Counter.Child)this.computationTimeCounter.labels(new String[]{langLabel, modeLabel})).inc(seconds);
        ((Histogram.Child)this.checkLatency.labels(new String[]{langLabel, ""})).observe(seconds);
        ((Histogram.Child)this.checkLatency.labels(new String[]{"", modeLabel})).observe(seconds);
        double speed = (double)textSize / seconds;
        ((Histogram.Child)this.checkSpeed.labels(new String[]{langLabel, ""})).observe(speed);
        ((Histogram.Child)this.checkSpeed.labels(new String[]{"", modeLabel})).observe(speed);
    }

    public void logRequestError(RequestErrorType type) {
        ((Counter.Child)this.requestErrorCounter.labels(new String[]{type.name().toLowerCase()})).inc();
    }

    public void logRequest() {
        this.httpRequestCounter.inc();
    }

    public void logResponse(int httpCode) {
        ((Counter.Child)this.httpResponseCounter.labels(new String[]{String.valueOf(httpCode)})).inc();
    }

    public void logFailedHealthcheck() {
        this.failedHealthcheckCounter.inc();
    }

    public static enum RequestErrorType {
        QUEUE_FULL,
        TOO_MANY_ERRORS,
        MAX_CHECK_TIME,
        MAX_TEXT_SIZE,
        INVALID_REQUEST;

    }
}

