/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.cache.Cache;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.guava.cache.CacheMetricsCollector;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;

public class ServerMetricsCollector {
    public static final String UNKNOWN = "unknown";
    private static final double[] LATENCY_BUCKETS = new double[]{0.025, 0.05, 0.075, 0.1, 0.125, 0.15, 0.175, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.5, 3.0, 4.0, 5.0, 7.5, 10.0, 15.0};
    private static final double[] SIZE_BUCKETS = new double[]{25.0, 50.0, 100.0, 150.0, 200.0, 250.0, 300.0, 400.0, 500.0, 750.0, 1000.0, 2500.0, 5000.0, 7500.0, 10000.0, 15000.0, 20000.0, 30000.0, 40000.0};
    private static final Set<String> CLIENTS = new HashSet<String>(Arrays.asList("webextension-chrome-ng", "webextension-firefox-ng", "ltorg", "sdl-trados-addon-public", "webextension-opera-ng", "ltplus", "googledocs", "webextension-firefox", "webextension-chrome", "mswordpremiumJS-demo", "webextension-unknown-ng", "java-http-client", "msword", "androidspell", "mswordpremiumJS", "webextension-edge-ng"));
    private static final String CLIENT_OTHER = "other";
    private static final ServerMetricsCollector collector = new ServerMetricsCollector();
    private static HTTPServer server;
    private final Counter checkCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_checks_total", (String)"Total text checks").labelNames(new String[]{"language", "client", "mode"})).register();
    private final Counter charactersCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_characters_total", (String)"Total processed characters").labelNames(new String[]{"language", "client", "mode"})).register();
    private final Counter matchCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_check_matches_total", (String)"Total amount of rule matches").labelNames(new String[]{"language", "client", "mode"})).register();
    private final Counter computationTimeCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_computation_time_seconds_total", (String)"Total computation time, in seconds").labelNames(new String[]{"language", "client", "mode"})).register();
    private final Histogram checkLatency = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_check_latency_seconds", (String)"Histogram of check times").buckets(LATENCY_BUCKETS).labelNames(new String[]{"language", "mode"})).register();
    private final Histogram checkSize = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_check_size_characters", (String)"Histogram of check sizes").buckets(SIZE_BUCKETS).labelNames(new String[]{"language", "mode"})).register();
    private final Counter ruleMatchCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_rule_matches_total", (String)"Total amount of matches of a given rule").labelNames(new String[]{"language", "rule_id"})).register();
    private final Counter requestErrorCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_request_errors_total", (String)"Various request errors").labelNames(new String[]{"reason"})).register();
    private final Counter httpRequestCounter = (Counter)Counter.build((String)"languagetool_http_requests_total", (String)"Received HTTP requests").register();
    private final Counter httpResponseCounter = (Counter)((Counter.Builder)Counter.build((String)"languagetool_http_responses_total", (String)"HTTP responses by code").labelNames(new String[]{"code"})).register();
    private final Counter failedHealthcheckCounter = (Counter)Counter.build((String)"languagetool_failed_healthchecks_total", (String)"Failed healthchecks").register();
    private final Gauge hiddenMatchesServerEnabled = (Gauge)Gauge.build((String)"languagetool_hidden_matches_server_enabled", (String)"Configuration of hidden matches server").register();
    private final Gauge hiddenMatchesServerStatus = (Gauge)Gauge.build((String)"languagetool_hidden_matches_server_up", (String)"Status of hidden matches server").register();
    private final CacheMetricsCollector cacheMetrics = (CacheMetricsCollector)new CacheMetricsCollector().register();

    public static void init(int port) throws IOException {
        DefaultExports.initialize();
        server = new HTTPServer(port, true);
    }

    public static void stop() {
        server.stop();
    }

    public static ServerMetricsCollector getInstance() {
        return collector;
    }

    public void monitorCache(String name, Cache cache) {
        this.cacheMetrics.addCache(name, cache);
    }

    public void logHiddenServerConfiguration(boolean enabled) {
        this.hiddenMatchesServerEnabled.set(enabled ? 1.0 : 0.0);
    }

    public void logHiddenServerStatus(boolean up) {
        this.hiddenMatchesServerStatus.set(up ? 1.0 : 0.0);
    }

    public void logCheck(Language language, long milliseconds, int textSize, int matchCount, JLanguageTool.Mode mode, @Nullable String client, Map<String, Integer> ruleMatches) {
        String clientLabel = this.cleanClientLabel(client);
        String langLabel = language != null ? language.getShortCode() : UNKNOWN;
        String modeLabel = mode != null ? mode.name() : UNKNOWN;
        ((Counter.Child)this.checkCounter.labels(new String[]{langLabel, clientLabel, modeLabel})).inc();
        ((Counter.Child)this.matchCounter.labels(new String[]{langLabel, clientLabel, modeLabel})).inc((double)matchCount);
        ((Counter.Child)this.charactersCounter.labels(new String[]{langLabel, clientLabel, modeLabel})).inc((double)textSize);
        ((Histogram.Child)this.checkSize.labels(new String[]{langLabel, modeLabel})).observe((double)textSize);
        double seconds = (double)milliseconds / 1000.0;
        ((Counter.Child)this.computationTimeCounter.labels(new String[]{langLabel, clientLabel, modeLabel})).inc(seconds);
        ((Histogram.Child)this.checkLatency.labels(new String[]{langLabel, modeLabel})).observe(seconds);
        ruleMatches.forEach((ruleId, ruleMatchCount) -> ((Counter.Child)this.ruleMatchCounter.labels(new String[]{langLabel, ruleId})).inc((double)ruleMatchCount.intValue()));
    }

    @NotNull
    private String cleanClientLabel(@Nullable String client) {
        String clientLabel = client != null && !client.equals("-") ? (CLIENTS.contains(client) ? client : CLIENT_OTHER) : UNKNOWN;
        return clientLabel;
    }

    public void logRequestError(RequestErrorType type) {
        ((Counter.Child)this.requestErrorCounter.labels(new String[]{type.name().toLowerCase()})).inc();
    }

    public void logRequest() {
        this.httpRequestCounter.inc();
    }

    public void logResponse(int httpCode) {
        ((Counter.Child)this.httpResponseCounter.labels(new String[]{String.valueOf(httpCode)})).inc();
    }

    public void logFailedHealthcheck() {
        this.failedHealthcheckCounter.inc();
    }

    public static enum RequestErrorType {
        QUEUE_FULL,
        TOO_MANY_ERRORS,
        MAX_CHECK_TIME,
        MAX_TEXT_SIZE,
        INVALID_REQUEST;

    }
}

