/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.PrintStream;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.languagetool.OutputStreamLogger;
import org.languagetool.RuleCheckTimeMessage;
import org.languagetool.RuleLoggerMessage;

public class SlowRuleLogger
extends OutputStreamLogger
implements Predicate<RuleLoggerMessage> {
    private int threshold = 50;

    public SlowRuleLogger(PrintStream stream) {
        super(stream);
        this.addFilter(this);
        this.setLevel(Level.FINE);
    }

    public SlowRuleLogger(PrintStream stream, int slowRuleLoggingThreshold) {
        this(stream);
        this.setThreshold(slowRuleLoggingThreshold);
    }

    @Override
    public boolean test(RuleLoggerMessage message) {
        RuleCheckTimeMessage msg;
        if (this.threshold < 0) {
            return false;
        }
        return message instanceof RuleCheckTimeMessage && (msg = (RuleCheckTimeMessage)message).getExecutionTime() >= (long)this.threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

