/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.ServerTools;

public class DatabaseMiscLogEntry
extends DatabaseLogEntry {
    private final Calendar date;
    private final Long server;
    private final Long client;
    private final Long user;
    private final String message;

    public DatabaseMiscLogEntry(Long server, Long client, Long user, String message) {
        this.server = server;
        this.client = client;
        this.user = user;
        this.message = message;
        this.date = Calendar.getInstance();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put("date", ServerTools.getSQLDatetimeString(this.date));
        parameters.put("server", this.server);
        parameters.put("client", this.client);
        parameters.put("user", this.user);
        parameters.put("message", StringUtils.abbreviate((String)this.message, (int)1024));
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.miscLogs";
    }
}

