/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.Language;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.ServerTools;

public class DatabaseCheckErrorLogEntry
extends DatabaseLogEntry {
    private final Calendar date;
    private final String type;
    private final Long server;
    private final Long client;
    private final Long user;
    private final Language languageSet;
    private final Language languageDetected;
    private final int textLength;
    private final String extra;

    public DatabaseCheckErrorLogEntry(String type, Long server, Long client, Long user, Language languageSet, Language languageDetected, int textLength, String extra) {
        this.type = type;
        this.server = server;
        this.client = client;
        this.user = user;
        this.languageSet = languageSet;
        this.languageDetected = languageDetected;
        this.textLength = textLength;
        this.extra = extra;
        this.date = Calendar.getInstance();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put("type", StringUtils.abbreviate((String)this.type, (int)64));
        parameters.put("date", ServerTools.getSQLDatetimeString(this.date));
        parameters.put("server", this.server);
        parameters.put("client", this.client);
        parameters.put("user", this.user);
        parameters.put("language", StringUtils.abbreviate((String)this.languageSet.getShortCodeWithCountryAndVariant(), (int)30));
        parameters.put("language_detected", StringUtils.abbreviate((String)this.languageDetected.getShortCodeWithCountryAndVariant(), (int)30));
        parameters.put("text_length", this.textLength);
        parameters.put("extra", StringUtils.abbreviate((String)this.extra, (int)256));
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.checkError";
    }
}

