/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.File;
import java.io.FileInputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.gui.Tools;
import org.languagetool.server.HTTPSServerConfig;
import org.languagetool.server.LanguageToolHttpHandler;
import org.languagetool.server.PortBindingException;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.Server;

public class HTTPSServer
extends Server {
    private final ExecutorService executorService;

    public HTTPSServer(HTTPSServerConfig config, boolean runInternally, String host, Set<String> allowedIps) {
        this.port = config.getPort();
        this.host = host;
        try {
            this.server = host == null ? HttpsServer.create(new InetSocketAddress(this.port), 0) : HttpsServer.create(new InetSocketAddress(host, this.port), 0);
            SSLContext sslContext = this.getSslContext(config.getKeystore(), config.getKeyStorePassword());
            HttpsConfigurator configurator = this.getConfigurator(sslContext);
            ((HttpsServer)this.server).setHttpsConfigurator(configurator);
            RequestLimiter limiter = this.getRequestLimiterOrNull(config);
            LanguageToolHttpHandler httpHandler = new LanguageToolHttpHandler(config.isVerbose(), allowedIps, runInternally, limiter);
            httpHandler.setMaxTextLength(config.getMaxTextLength());
            httpHandler.setAllowOriginUrl(config.getAllowOriginUrl());
            this.server.createContext("/", httpHandler);
            this.executorService = Executors.newFixedThreadPool(10);
            this.server.setExecutor(this.executorService);
        }
        catch (BindException e) {
            ResourceBundle messages = JLanguageTool.getMessageBundle();
            String message = Tools.makeTexti18n((ResourceBundle)messages, (String)"https_server_start_failed", (Object[])new Object[]{host, Integer.toString(this.port)});
            throw new PortBindingException(message, e);
        }
        catch (Exception e) {
            ResourceBundle messages = JLanguageTool.getMessageBundle();
            String message = Tools.makeTexti18n((ResourceBundle)messages, (String)"https_server_start_failed_unknown_reason", (Object[])new Object[]{host, Integer.toString(this.port)});
            throw new RuntimeException(message, e);
        }
    }

    private RequestLimiter getRequestLimiterOrNull(HTTPSServerConfig config) {
        int requestLimit = config.getRequestLimit();
        int requestLimitPeriodInSeconds = config.getRequestLimitPeriodInSeconds();
        if (requestLimit > 0 || requestLimitPeriodInSeconds > 0) {
            return new RequestLimiter(requestLimit, requestLimitPeriodInSeconds);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLContext getSslContext(File keyStoreFile, String passPhrase) {
        try (FileInputStream keyStoreStream = new FileInputStream(keyStoreFile);){
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(keyStoreStream, passPhrase.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keystore, passPhrase.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(keystore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            SSLContext sSLContext = sslContext;
            return sSLContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set up SSL context", e);
        }
    }

    private HttpsConfigurator getConfigurator(SSLContext sslContext) {
        return new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters params) {
                SSLContext context = this.getSSLContext();
                SSLParameters sslParams = context.getDefaultSSLParameters();
                params.setNeedClientAuth(false);
                params.setSSLParameters(sslParams);
            }
        };
    }

    @Override
    public void stop() {
        super.stop();
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public static void main(String[] args) {
        if (args.length > 7 || HTTPSServer.usageRequested(args)) {
            System.out.println("Usage: " + HTTPSServer.class.getSimpleName() + " --config propertyFile [--port|-p port] [--public]");
            System.out.println("  --config file  a Java property file with values for:");
            System.out.println("                 'keystore' - a Java keystore with an SSL certificate");
            System.out.println("                 'password' - the keystore's password");
            System.out.println("                 'maxTextLength' - maximum text length, longer texts will cause an error (optional)");
            System.out.println("                 'requestLimit' - maximum number of requests (optional)");
            System.out.println("                 'requestLimitPeriodInSeconds' - time period to which requestLimit applies (optional)");
            HTTPSServer.printCommonOptions();
            System.exit(1);
        }
        boolean runInternal = false;
        HTTPSServerConfig config = new HTTPSServerConfig(args);
        try {
            HTTPSServer server;
            if (config.isPublicAccess()) {
                System.out.println("WARNING: running in public mode, LanguageTool API can be accessed without restrictions!");
                server = new HTTPSServer(config, false, null, null);
            } else {
                server = new HTTPSServer(config, false, "localhost", DEFAULT_ALLOWED_IPS);
            }
            server.run();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start LanguageTool HTTPS server on localhost, port " + config.getPort(), e);
        }
    }

    @Override
    protected String getProtocol() {
        return "https";
    }
}

